##*************************************************************************##
##  CUBE        http://www.scalasca.org/                                   ##
##*************************************************************************##
##  Copyright (c) 1998-2023                                                ##
##  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          ##
##                                                                         ##
##  Copyright (c) 2009-2015                                                ##
##  German Research School for Simulation Sciences GmbH,                   ##
##  Laboratory for Parallel Programming                                    ##
##                                                                         ##
##  This software may be modified and distributed under the terms of       ##
##  a BSD-style license.  See the COPYING file in the package base         ##
##  directory for details.                                                 ##
##*************************************************************************##


ANDROID_API_VERSION=31
#// 24
ANDROID_MIN_SDK_VERSION=31
#// 24
ANDROID_TARGET_SDK_VERSION=31
#// 28

CONFIG	+= thread rtti exceptions warn_on  release  c++1z
TEMPLATE = lib
CUBE +=
CUBE_SRC = ../../../../src/cube
TOOLS_LIBRARY_SRC = ../../../../src/tools/tools/0001.library
COMMON_SRC = ../../../../src/tools/
CSTR_SRC = ../../../../common/utils/src/cstr
EXCEPTION_SRC = ../../../../common/utils/src/exception
IO_SRC = ../../../../common/utils/src/io
UTILS_INCLUDE = ../../../../common/utils/include
JSON_INCLUDE = ../../../../vendor/json-cpp


CUBE4_POPX_CALCULATION_INC = ../../../../src/tools/tools/0001.library/popx/calculation/
CUBE4_POPX_COMMON_INC = ../../../../src/tools/tools/0001.library/popx/common/
CUBE4_POPX_MPI_INC = ../../../../src/tools/tools/0001.library/popx/mpi/
CUBE4_POPX_HYBRID_ADD_INC = ../../../../src/tools/tools/0001.library/popx/hybrid_add/
CUBE4_POPX_HYBRID_MULT_INC = ../../../../src/tools/tools/0001.library/popx/hybrid_mult/
CUBE4_POPX_BS_INC = ../../../../src/tools/tools/0001.library/popx/bs/
CUBE4_POPX_TOP_INC = ../../../../src/tools/tools/0001.library/popx/


DEPENDPATH += $${COMMON_SRC} $${COMMON_SRC}/common_inc
INCLUDEPATH += $${CUBE_TOOL_SRC} \
    $${TOOLS_LIBRARY_SRC} \
    $${COMMON_SRC}/common_inc \
    $${CUBE_SRC}/../ \
    ../../src \
    ../../include \
    $${CUBE4_POPX_COMMON_INC} \
    $${CUBE4_POPX_CALCULATION_INC} \
    $${CUBE4_POPX_MPI_INC} \
    $${CUBE4_POPX_HYBRID_ADD_INC} \
    $${CUBE4_POPX_HYBRID_MULT_INC} \
    $${CUBE4_POPX_BS_INC} \
    $${CUBE4_POPX_TOP_INC} \
    $${JSON_INCLUDE} \
    $${CUBE_SRC}/include/service\
    $${CUBE_SRC}/include/service/cubelayout \
    $${CUBE_SRC}/include/service/cubelayout/layout \
    $${CUBE_SRC}/include/service/cubelayout/readers \
    $${CUBE_SRC}/include/dimensions/metric \
    $${CUBE_SRC}/include/dimensions/metric/strategies \
    $${CUBE_SRC}/include/dimensions/metric/data \
    $${CUBE_SRC}/include/dimensions/metric/cache \
    $${CUBE_SRC}/include/dimensions/metric/data/rows \
    $${CUBE_SRC}/include/dimensions/metric/matrix \
    $${CUBE_SRC}/include/dimensions/metric/index \
    $${CUBE_SRC}/include/dimensions/metric/value \
    $${CUBE_SRC}/include/dimensions/metric/value/trafo \
    $${CUBE_SRC}/include/dimensions/metric/value/trafo/single_value \
    $${CUBE_SRC}/include/dimensions/calltree \
    $${CUBE_SRC}/include/dimensions/system \
    $${CUBE_SRC}/include/dimensions \
    $${CUBE_SRC}/include/network \
    $${CUBE_SRC}/include/syntax \
    $${CUBE_SRC}/include/syntax/cubepl/evaluators \
    $${CUBE_SRC}/include/syntax/cubepl/evaluators/nullary \
    $${CUBE_SRC}/include/syntax/cubepl/evaluators/nullary/statements \
    $${CUBE_SRC}/include/syntax/cubepl/evaluators/unary \
    $${CUBE_SRC}/include/syntax/cubepl/evaluators/unary/functions/single_argument \
    $${CUBE_SRC}/include/syntax/cubepl/evaluators/unary/functions/two_arguments \
    $${CUBE_SRC}/include/syntax/cubepl/evaluators/unary/functions/lambda_calcul \
    $${CUBE_SRC}/include/syntax/cubepl/evaluators/binary \
    $${CUBE_SRC}/include/syntax/cubepl \
    $${CUBE_SRC}/include/derivated \
    $${CUBE_SRC}/include/topologies \
    $${CUBE_SRC}/include/ \
    ${MINGW}/opt/include

win32:INCLUDEPATH +="C:/Program Files (x86)/GnuWin32/include"
win32:LIBS += -L../../cube/release -lcube

armeabi-v7a:LIBS += -L../../cube/android-build/libs/armeabi-v7a -lcube_armeabi-v7a -L../common/android-build/libs/armeabi-v7a -lcommon_armeabi-v7a
arm64-v8a:LIBS += -L../../cube/android-build/libs/arm64-v8a -lcube_arm64-v8a -L../common/android-build/libs/arm64-v8a -lcommon_arm64-v8a
x86:LIBS += -L../../cube/android-build/libs/x86 -lcube_x86 -L../common/android-build/libs/x86 -lcommon_x86
x86_64:LIBS += -L../../cube/android-build/libs/x86_64 -lcube_x86_64 -L../common/android-build/libs/x86_64 -lcommon_x86_64

RESOURCES =



QMAKE_CXXFLAGS+=-fexceptions

QT -= gui core

# Input{
HEADERS += \
$${TOOLS_LIBRARY_SRC}/AbridgeTraversal.h \
$${TOOLS_LIBRARY_SRC}/AbstractConstraint.h \
$${TOOLS_LIBRARY_SRC}/AggregatedMetric.h \
$${TOOLS_LIBRARY_SRC}/Blacklist.h \
$${TOOLS_LIBRARY_SRC}/CCnode.h \
$${TOOLS_LIBRARY_SRC}/CMetricCnodeConstraint.h \
$${TOOLS_LIBRARY_SRC}/CRegion.h \
$${TOOLS_LIBRARY_SRC}/Cacheable.h \
$${TOOLS_LIBRARY_SRC}/CnodeConstraint.h \
$${TOOLS_LIBRARY_SRC}/CnodeInfo.h \
$${TOOLS_LIBRARY_SRC}/CnodeMetric.h \
$${TOOLS_LIBRARY_SRC}/CnodeSubForest.h \
$${TOOLS_LIBRARY_SRC}/CnodeSubTree.h \
$${TOOLS_LIBRARY_SRC}/ComputeTraversal.h \
$${TOOLS_LIBRARY_SRC}/CowTree.h \
$${TOOLS_LIBRARY_SRC}/DiffPrintTraversal.h \
$${TOOLS_LIBRARY_SRC}/InfoObj.h \
$${TOOLS_LIBRARY_SRC}/MdAggrCube.h \
$${TOOLS_LIBRARY_SRC}/MdTraversal.h \
$${TOOLS_LIBRARY_SRC}/MultiMdAggrCube.h \
$${TOOLS_LIBRARY_SRC}/PrintableCCnode.h \
$${TOOLS_LIBRARY_SRC}/RegionConstraint.h \
$${TOOLS_LIBRARY_SRC}/RegionInfo.h \
$${TOOLS_LIBRARY_SRC}/Traversal.h \
$${TOOLS_LIBRARY_SRC}/TreeConstraint.h \
$${TOOLS_LIBRARY_SRC}/VisitorsMetric.h \
$${TOOLS_LIBRARY_SRC}/popx/PerformanceAnalysis.h \
$${TOOLS_LIBRARY_SRC}/popx/PerformanceTest.h \
$${TOOLS_LIBRARY_SRC}/popx/PerformanceTest_incl.h \
$${TOOLS_LIBRARY_SRC}/popx/bs/BSPOPHybridAuditAnalysis.h \
$${TOOLS_LIBRARY_SRC}/popx/bs/BSPOPHybridCommunicationEfficiencyTest.h \
$${TOOLS_LIBRARY_SRC}/popx/bs/BSPOPHybridLoadBalanceTest.h \
$${TOOLS_LIBRARY_SRC}/popx/bs/BSPOPHybridMPICommunicationEfficiencyTest.h \
$${TOOLS_LIBRARY_SRC}/popx/bs/BSPOPHybridMPILoadBalanceTest.h \
$${TOOLS_LIBRARY_SRC}/popx/bs/BSPOPHybridMPIParallelEfficiencyTest.h \
$${TOOLS_LIBRARY_SRC}/popx/bs/BSPOPHybridMPISerialisationTest.h \
$${TOOLS_LIBRARY_SRC}/popx/bs/BSPOPHybridMPITransferTest.h \
$${TOOLS_LIBRARY_SRC}/popx/bs/BSPOPHybridOMPCommunicationEfficiencyTest.h \
$${TOOLS_LIBRARY_SRC}/popx/bs/BSPOPHybridOMPLoadBalanceEfficiencyTest.h \
$${TOOLS_LIBRARY_SRC}/popx/bs/BSPOPHybridOMPParallelEfficiencyTest.h \
$${TOOLS_LIBRARY_SRC}/popx/bs/BSPOPHybridParallelEfficiencyTest.h \
$${TOOLS_LIBRARY_SRC}/popx/calculation/POPCalculation.h \
$${TOOLS_LIBRARY_SRC}/popx/calculation/POPServerRequest.h \
$${TOOLS_LIBRARY_SRC}/popx/common/POPComputationTimeTest.h \
$${TOOLS_LIBRARY_SRC}/popx/common/POPIOEfficiencyTest.h \
$${TOOLS_LIBRARY_SRC}/popx/common/POPIPCTest.h \
$${TOOLS_LIBRARY_SRC}/popx/common/POPMpiIOTimeTest.h \
$${TOOLS_LIBRARY_SRC}/popx/common/POPNoWaitINSTest.h \
$${TOOLS_LIBRARY_SRC}/popx/common/POPPosixIOTimeTest.h \
$${TOOLS_LIBRARY_SRC}/popx/common/POPStalledResourcesTest.h \
$${TOOLS_LIBRARY_SRC}/popx/common/POPWallTimeTest.h \
$${TOOLS_LIBRARY_SRC}/popx/hybrid_add/POPHybridAmdahlTestAdd.h \
$${TOOLS_LIBRARY_SRC}/popx/hybrid_add/POPHybridAuditAnalysisAdd.h \
$${TOOLS_LIBRARY_SRC}/popx/hybrid_add/POPHybridCommunicationEfficiencyTestAdd.h \
$${TOOLS_LIBRARY_SRC}/popx/hybrid_add/POPHybridImbalanceTestAdd.h \
$${TOOLS_LIBRARY_SRC}/popx/hybrid_add/POPHybridOMPRegionEfficiencyTestAdd.h \
$${TOOLS_LIBRARY_SRC}/popx/hybrid_add/POPHybridParallelEfficiencyTestAdd.h \
$${TOOLS_LIBRARY_SRC}/popx/hybrid_add/POPHybridProcessEfficiencyTestAdd.h \
$${TOOLS_LIBRARY_SRC}/popx/hybrid_add/POPHybridSerialisationTestAdd.h \
$${TOOLS_LIBRARY_SRC}/popx/hybrid_add/POPHybridThreadEfficiencyTestAdd.h \
$${TOOLS_LIBRARY_SRC}/popx/hybrid_add/POPHybridTransferTestAdd.h \
$${TOOLS_LIBRARY_SRC}/popx/hybrid_mult/POPHybridAmdahlTest.h \
$${TOOLS_LIBRARY_SRC}/popx/hybrid_mult/POPHybridAuditAnalysis.h \
$${TOOLS_LIBRARY_SRC}/popx/hybrid_mult/POPHybridCommunicationEfficiencyTest.h \
$${TOOLS_LIBRARY_SRC}/popx/hybrid_mult/POPHybridImbalanceTest.h \
$${TOOLS_LIBRARY_SRC}/popx/hybrid_mult/POPHybridOMPRegionEfficiencyTest.h \
$${TOOLS_LIBRARY_SRC}/popx/hybrid_mult/POPHybridParallelEfficiencyTest.h \
$${TOOLS_LIBRARY_SRC}/popx/hybrid_mult/POPHybridProcessEfficiencyTest.h \
$${TOOLS_LIBRARY_SRC}/popx/hybrid_mult/POPHybridSerialisationTest.h \
$${TOOLS_LIBRARY_SRC}/popx/hybrid_mult/POPHybridThreadEfficiencyTest.h \
$${TOOLS_LIBRARY_SRC}/popx/hybrid_mult/POPHybridTransferTest.h \
$${TOOLS_LIBRARY_SRC}/popx/mpi/POPAuditAnalysis.h \
$${TOOLS_LIBRARY_SRC}/popx/mpi/POPCommunicationEfficiencyTest.h \
$${TOOLS_LIBRARY_SRC}/popx/mpi/POPImbalanceTest.h \
$${TOOLS_LIBRARY_SRC}/popx/mpi/POPParallelEfficiencyTest.h \
$${TOOLS_LIBRARY_SRC}/popx/mpi/POPSerialisationTest.h \
$${TOOLS_LIBRARY_SRC}/popx/mpi/POPTransferTest.h




SOURCES += \
$${TOOLS_LIBRARY_SRC}/AbridgeTraversal.cpp \
$${TOOLS_LIBRARY_SRC}/AbstractConstraint.cpp \
$${TOOLS_LIBRARY_SRC}/AggregatedMetric.cpp \
$${TOOLS_LIBRARY_SRC}/Blacklist.cpp \
$${TOOLS_LIBRARY_SRC}/CCnode.cpp \
$${TOOLS_LIBRARY_SRC}/CMetricCnodeConstraint.cpp \
$${TOOLS_LIBRARY_SRC}/CRegion.cpp \
$${TOOLS_LIBRARY_SRC}/Cacheable.cpp \
$${TOOLS_LIBRARY_SRC}/CnodeConstraint.cpp \
$${TOOLS_LIBRARY_SRC}/CnodeInfo.cpp \
$${TOOLS_LIBRARY_SRC}/CnodeMetric.cpp \
$${TOOLS_LIBRARY_SRC}/CnodeSubForest.cpp \
$${TOOLS_LIBRARY_SRC}/CnodeSubTree.cpp \
$${TOOLS_LIBRARY_SRC}/ComputeTraversal.cpp \
$${TOOLS_LIBRARY_SRC}/CowTree.cpp \
$${TOOLS_LIBRARY_SRC}/DiffPrintTraversal.cpp \
$${TOOLS_LIBRARY_SRC}/MdAggrCube.cpp \
$${TOOLS_LIBRARY_SRC}/MdTraversal.cpp \
$${TOOLS_LIBRARY_SRC}/MultiMdAggrCube.cpp \
$${TOOLS_LIBRARY_SRC}/PrintableCCnode.cpp \
$${TOOLS_LIBRARY_SRC}/RegionConstraint.cpp \
$${TOOLS_LIBRARY_SRC}/RegionInfo.cpp \
$${TOOLS_LIBRARY_SRC}/Traversal.cpp \
$${TOOLS_LIBRARY_SRC}/TreeConstraint.cpp \
$${TOOLS_LIBRARY_SRC}/VisitorsMetric.cpp \
$${TOOLS_LIBRARY_SRC}/popx/PerformanceAnalysis.cpp \
$${TOOLS_LIBRARY_SRC}/popx/PerformanceTest.cpp \
$${TOOLS_LIBRARY_SRC}/popx/PerformanceTest_incl.cpp \
$${TOOLS_LIBRARY_SRC}/popx/bs/BSPOPHybridAuditAnalysis.cpp \
$${TOOLS_LIBRARY_SRC}/popx/bs/BSPOPHybridCommunicationEfficiencyTest.cpp \
$${TOOLS_LIBRARY_SRC}/popx/bs/BSPOPHybridLoadBalanceTest.cpp \
$${TOOLS_LIBRARY_SRC}/popx/bs/BSPOPHybridMPICommunicationEfficiencyTest.cpp \
$${TOOLS_LIBRARY_SRC}/popx/bs/BSPOPHybridMPILoadBalanceTest.cpp \
$${TOOLS_LIBRARY_SRC}/popx/bs/BSPOPHybridMPIParallelEfficiencyTest.cpp \
$${TOOLS_LIBRARY_SRC}/popx/bs/BSPOPHybridMPISerialisationTest.cpp \
$${TOOLS_LIBRARY_SRC}/popx/bs/BSPOPHybridMPITransferTest.cpp \
$${TOOLS_LIBRARY_SRC}/popx/bs/BSPOPHybridOMPCommunicationEfficiencyTest.cpp \
$${TOOLS_LIBRARY_SRC}/popx/bs/BSPOPHybridOMPLoadBalanceEfficiencyTest.cpp \
$${TOOLS_LIBRARY_SRC}/popx/bs/BSPOPHybridOMPParallelEfficiencyTest.cpp \
$${TOOLS_LIBRARY_SRC}/popx/bs/BSPOPHybridParallelEfficiencyTest.cpp \
$${TOOLS_LIBRARY_SRC}/popx/calculation/POPCalculation.cpp \
$${TOOLS_LIBRARY_SRC}/popx/common/POPComputationTimeTest.cpp \
$${TOOLS_LIBRARY_SRC}/popx/common/POPIOEfficiencyTest.cpp \
$${TOOLS_LIBRARY_SRC}/popx/common/POPIPCTest.cpp \
$${TOOLS_LIBRARY_SRC}/popx/common/POPMpiIOTimeTest.cpp \
$${TOOLS_LIBRARY_SRC}/popx/common/POPNoWaitINSTest.cpp \
$${TOOLS_LIBRARY_SRC}/popx/common/POPPosixIOTimeTest.cpp \
$${TOOLS_LIBRARY_SRC}/popx/common/POPStalledResourcesTest.cpp \
$${TOOLS_LIBRARY_SRC}/popx/common/POPWallTimeTest.cpp \
$${TOOLS_LIBRARY_SRC}/popx/hybrid_add/POPHybridAmdahlTestAdd.cpp \
$${TOOLS_LIBRARY_SRC}/popx/hybrid_add/POPHybridAuditAnalysisAdd.cpp \
$${TOOLS_LIBRARY_SRC}/popx/hybrid_add/POPHybridCommunicationEfficiencyTestAdd.cpp \
$${TOOLS_LIBRARY_SRC}/popx/hybrid_add/POPHybridImbalanceTestAdd.cpp \
$${TOOLS_LIBRARY_SRC}/popx/hybrid_add/POPHybridOMPRegionEfficiencyTestAdd.cpp \
$${TOOLS_LIBRARY_SRC}/popx/hybrid_add/POPHybridParallelEfficiencyTestAdd.cpp \
$${TOOLS_LIBRARY_SRC}/popx/hybrid_add/POPHybridProcessEfficiencyTestAdd.cpp \
$${TOOLS_LIBRARY_SRC}/popx/hybrid_add/POPHybridSerialisationTestAdd.cpp \
$${TOOLS_LIBRARY_SRC}/popx/hybrid_add/POPHybridThreadEfficiencyTestAdd.cpp \
$${TOOLS_LIBRARY_SRC}/popx/hybrid_add/POPHybridTransferTestAdd.cpp \
$${TOOLS_LIBRARY_SRC}/popx/hybrid_mult/POPHybridAmdahlTest.cpp \
$${TOOLS_LIBRARY_SRC}/popx/hybrid_mult/POPHybridAuditAnalysis.cpp \
$${TOOLS_LIBRARY_SRC}/popx/hybrid_mult/POPHybridCommunicationEfficiencyTest.cpp \
$${TOOLS_LIBRARY_SRC}/popx/hybrid_mult/POPHybridImbalanceTest.cpp \
$${TOOLS_LIBRARY_SRC}/popx/hybrid_mult/POPHybridOMPRegionEfficiencyTest.cpp \
$${TOOLS_LIBRARY_SRC}/popx/hybrid_mult/POPHybridParallelEfficiencyTest.cpp \
$${TOOLS_LIBRARY_SRC}/popx/hybrid_mult/POPHybridProcessEfficiencyTest.cpp \
$${TOOLS_LIBRARY_SRC}/popx/hybrid_mult/POPHybridSerialisationTest.cpp \
$${TOOLS_LIBRARY_SRC}/popx/hybrid_mult/POPHybridThreadEfficiencyTest.cpp \
$${TOOLS_LIBRARY_SRC}/popx/hybrid_mult/POPHybridTransferTest.cpp \
$${TOOLS_LIBRARY_SRC}/popx/mpi/POPAuditAnalysis.cpp \
$${TOOLS_LIBRARY_SRC}/popx/mpi/POPCommunicationEfficiencyTest.cpp \
$${TOOLS_LIBRARY_SRC}/popx/mpi/POPImbalanceTest.cpp \
$${TOOLS_LIBRARY_SRC}/popx/mpi/POPParallelEfficiencyTest.cpp \
$${TOOLS_LIBRARY_SRC}/popx/mpi/POPSerialisationTest.cpp \
$${TOOLS_LIBRARY_SRC}/popx/mpi/POPTransferTest.cpp

# Additional dependencies
# PRE_TARGETDEPS += $CUBE/lib/libcube4.a



# Hack for IBM AIX
aix-g++ {
  QMAKE_CXXFLAGS_RELEASE += -O0
}
aix-g++-64 {
  QMAKE_CXXFLAGS_RELEASE += -O0
}
