##*************************************************************************##
##  CUBE        http://www.scalasca.org/                                   ##
##*************************************************************************##
##  Copyright (c) 1998-2023                                                ##
##  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          ##
##                                                                         ##
##  Copyright (c) 2009-2015                                                ##
##  German Research School for Simulation Sciences GmbH,                   ##
##  Laboratory for Parallel Programming                                    ##
##                                                                         ##
##  This software may be modified and distributed under the terms of       ##
##  a BSD-style license.  See the COPYING file in the package base         ##
##  directory for details.                                                 ##
##*************************************************************************##


ANDROID_API_VERSION=24
ANDROID_MIN_SDK_VERSION=24
ANDROID_TARGET_SDK_VERSION=28

CONFIG	+=  exceptions console rtti warn_on release  c++11
TEMPLATE = app
CUBE +=
CUBE_SRC = ../../../../src/cube
TOOLS_LIBRARY_SRC = ../../../../src/tools/tools/0001.library
COMMON_SRC = ../../../../src/tools/
CSTR_SRC = ../../../common/utils/src/cstr
EXCEPTION_SRC = ../../../common/utils/src/exception
IO_SRC = ../../../common/utils/src/io
UTILS_INCLUDE = ../../../common/utils/include

CUBE_TOOL_SRC = ../../../../src/tools/tools/002e.Sanity
DEPENDPATH += $${COMMON_SRC} $${COMMON_SRC}/common_inc
INCLUDEPATH += $${CUBE_TOOL_SRC} \
    $${TOOLS_LIBRARY_SRC} \
    $${COMMON_SRC}/common_inc \
    $${CUBE_SRC}/../ \
    ../../src \
    ../../include \
    $${CUBE_SRC}/include/service\
    $${CUBE_SRC}/include/service/cubelayout \
    $${CUBE_SRC}/include/service/cubelayout/layout \
    $${CUBE_SRC}/include/service/cubelayout/readers \
    $${CUBE_SRC}/include/dimensions/metric \
    $${CUBE_SRC}/include/dimensions/metric/strategies \
    $${CUBE_SRC}/include/dimensions/metric/data \
    $${CUBE_SRC}/include/dimensions/metric/cache \
    $${CUBE_SRC}/include/dimensions/metric/data/rows \
    $${CUBE_SRC}/include/dimensions/metric/matrix \
    $${CUBE_SRC}/include/dimensions/metric/index \
    $${CUBE_SRC}/include/dimensions/metric/value \
    $${CUBE_SRC}/include/dimensions/metric/value/trafo \
    $${CUBE_SRC}/include/dimensions/metric/value/trafo/single_value \
    $${CUBE_SRC}/include/dimensions/calltree \
    $${CUBE_SRC}/include/dimensions/system \
    $${CUBE_SRC}/include/dimensions \
    $${CUBE_SRC}/include/network \
    $${CUBE_SRC}/include/syntax \
    $${CUBE_SRC}/include/syntax/cubepl/evaluators \
    $${CUBE_SRC}/include/syntax/cubepl/evaluators/nullary \
    $${CUBE_SRC}/include/syntax/cubepl/evaluators/nullary/statements \
    $${CUBE_SRC}/include/syntax/cubepl/evaluators/unary \
    $${CUBE_SRC}/include/syntax/cubepl/evaluators/unary/functions/single_argument \
    $${CUBE_SRC}/include/syntax/cubepl/evaluators/unary/functions/two_arguments \
    $${CUBE_SRC}/include/syntax/cubepl/evaluators/unary/functions/lambda_calcul \
    $${CUBE_SRC}/include/syntax/cubepl/evaluators/binary \
    $${CUBE_SRC}/include/syntax/cubepl \
    $${CUBE_SRC}/include/derivated \
    $${CUBE_SRC}/include/topologies \
    $${CUBE_SRC}/include/ \
    ${MINGW}/opt/include

win32:INCLUDEPATH +="C:/Program Files (x86)/GnuWin32/include"
win32:LIBS += -L../../cube/release -lcube

armeabi-v7a:LIBS += -L../../cube/android-build/libs/armeabi-v7a -lcube_armeabi-v7a
arm64-v8a:LIBS += -L../../cube/android-build/libs/arm64-v8a -lcube_arm64-v8a
x86:LIBS += -L../../cube/android-build/libs/x86 -lcube_x86
x86_64:LIBS += -L../../cube/android-build/libs/x86_64 -lcube_x86_64

RESOURCES =


QMAKE_CXXFLAGS+=-fexceptions

QT -= gui core

# Input{
HEADERS += \
  $${CUBE_TOOL_SRC}/sanity_calls.h



SOURCES += \
   $${CUBE_TOOL_SRC}/cube4_sanity.cpp



# Hack for IBM AIX
aix-g++ {
  QMAKE_CXXFLAGS_RELEASE += -O0
}
aix-g++-64 {
  QMAKE_CXXFLAGS_RELEASE += -O0
}

android {
CONFIG+= android mobility
ANDROID_PACKAGE_SOURCE_DIR = $$PWD/android
DISTFILES += \
    android/AndroidManifest.xml \
    android/build.gradle \
    android/res/values/libs.xml
MOBILITY=
OTHER_FILES += \
    android/AndroidManifest.xml \
    android/build.gradle \
    android/res/values/libs.xml \
    android/res/drawable-hdpi/icon.png \
    android/res/drawable-ldpi/icon.png \
    android/res/drawable-mdpi/icon.png \
    android/res/values/libs.xml \
    android/res/values/strings.xml \
    android/src/eu/licentia/necessitas/industrius/QtActivity.java \
    android/src/eu/licentia/necessitas/industrius/QtApplication.java \
    android/src/eu/licentia/necessitas/industrius/QtLayout.java \
    android/src/eu/licentia/necessitas/industrius/QtSurface.java \
    android/src/eu/licentia/necessitas/ministro/IMinistro.aidl \
    android/src/eu/licentia/necessitas/ministro/IMinistroCallback.aidl \
    android/src/eu/licentia/necessitas/mobile/QtAndroidContacts.java \
    android/src/eu/licentia/necessitas/mobile/QtCamera.java \
    android/src/eu/licentia/necessitas/mobile/QtFeedback.java \
    android/src/eu/licentia/necessitas/mobile/QtLocation.java \
    android/src/eu/licentia/necessitas/mobile/QtMediaPlayer.java \
    android/src/eu/licentia/necessitas/mobile/QtSensors.java \
    android/src/eu/licentia/necessitas/mobile/QtSystemInfo.java
}
