##*************************************************************************##
##  CUBE        http://www.scalasca.org/                                   ##
##*************************************************************************##
##  Copyright (c) 1998-2023                                                ##
##  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          ##
##                                                                         ##
##  Copyright (c) 2009-2015                                                ##
##  German Research School for Simulation Sciences GmbH,                   ##
##  Laboratory for Parallel Programming                                    ##
##                                                                         ##
##  This software may be modified and distributed under the terms of       ##
##  a BSD-style license.  See the COPYING file in the package base         ##
##  directory for details.                                                 ##
##*************************************************************************##


CONFIG	+= thread rtti  exceptions warn_on release c++11
android {
ANDROID_PACKAGE_SOURCE_DIR=$$PWD/android
ANDROID_API_VERSION=31
#// 24
ANDROID_MIN_SDK_VERSION=31
#// 24
ANDROID_TARGET_SDK_VERSION=31
#// 28
CONFIG	+= android mobility
DEFINES+= __MINGW32__ ANDROID

LIBS += -llog

armeabi-v7a:LIBS += -L../../cube/android-build/libs/armeabi-v7a -lcube_armeabi-v7a
arm64-v8a:LIBS += -L../../cube/android-build/libs/arm64-v8a -lcube_arm64-v8a
x86:LIBS += -L../../cube/android-build/libs/x86 -lcube_x86
x86_64:LIBS += -L../../cube/android-build/libs/x86_64 -lcube_x86_64

}

TEMPLATE = lib
CUBE +=
CUBE_SRC = ../../../../src/cube
COMMON_SRC = ../../../../src/tools/
CSTR_SRC = ../../../../common/utils/src/cstr
EXCEPTION_SRC = ../../../../common/utils/src/exception
IO_SRC = ../../../../common/utils/src/io
UTILS_INCLUDE = ../../../../common/utils/include
DEPENDPATH += $${COMMON_SRC} $${COMMON_SRC}/common_inc  $${COMMON_SRC}/common_src ../../cube/
INCLUDEPATH += $${CUBE_TOOL_SRC} \
    $${TOOLS_LIBRARY_SRC} \
    $${COMMON_SRC}/common_inc \
    $${CUBE_SRC}/../ \
    ../../src \
    ../../include \
    $${CSTR_SRC} \
    $${EXCEPTION_SRC} \
    $${IO_SRC} \
    $${UTILS_INCLUDE} \
    $${CUBE_SRC}/include/service\
    $${CUBE_SRC}/include/service/cubelayout \
    $${CUBE_SRC}/include/service/cubelayout/layout \
    $${CUBE_SRC}/include/service/cubelayout/readers \
    $${CUBE_SRC}/include/dimensions/metric \
    $${CUBE_SRC}/include/dimensions/metric/strategies \
    $${CUBE_SRC}/include/dimensions/metric/data \
    $${CUBE_SRC}/include/dimensions/metric/cache \
    $${CUBE_SRC}/include/dimensions/metric/data/rows \
    $${CUBE_SRC}/include/dimensions/metric/matrix \
    $${CUBE_SRC}/include/dimensions/metric/index \
    $${CUBE_SRC}/include/dimensions/metric/value \
    $${CUBE_SRC}/include/dimensions/metric/value/trafo \
    $${CUBE_SRC}/include/dimensions/metric/value/trafo/single_value \
    $${CUBE_SRC}/include/dimensions/calltree \
    $${CUBE_SRC}/include/dimensions/system \
    $${CUBE_SRC}/include/dimensions \
    $${CUBE_SRC}/include/network \
    $${CUBE_SRC}/include/syntax \
    $${CUBE_SRC}/include/syntax/cubepl/evaluators \
    $${CUBE_SRC}/include/syntax/cubepl/evaluators/nullary \
    $${CUBE_SRC}/include/syntax/cubepl/evaluators/nullary/statements \
    $${CUBE_SRC}/include/syntax/cubepl/evaluators/unary \
    $${CUBE_SRC}/include/syntax/cubepl/evaluators/unary/functions/single_argument \
    $${CUBE_SRC}/include/syntax/cubepl/evaluators/unary/functions/two_arguments \
    $${CUBE_SRC}/include/syntax/cubepl/evaluators/unary/functions/lambda_calcul \
    $${CUBE_SRC}/include/syntax/cubepl/evaluators/binary \
    $${CUBE_SRC}/include/syntax/cubepl \
    $${CUBE_SRC}/include/derivated \
    $${CUBE_SRC}/include/topologies \
    $${CUBE_SRC}/include/ \
    ${MINGW}/opt/include

win32:INCLUDEPATH +="C:/Program Files (x86)/GnuWin32/include"
win32:LIBS += -L../../cube/release -lcube
win32:DEFINES+= __MINGW32__ _WINDOWS

RESOURCES =


QMAKE_CXXFLAGS+=-fexceptions

QT -= gui core

# Input{
HEADERS += \
$${COMMON_SRC}/common_inc/Filter.h \
$${COMMON_SRC}/common_inc/algebra4-internals.h \
$${COMMON_SRC}/common_inc/algebra4.h \
$${COMMON_SRC}/common_inc/enums.h \
$${COMMON_SRC}/common_inc/helper.h


SOURCES += \
$${COMMON_SRC}/common_src/Filter.cpp \
$${COMMON_SRC}/common_src/algebra4-internals.cpp \
$${COMMON_SRC}/common_src/algebra4.cpp \
$${COMMON_SRC}/common_src/helper.cpp




# Additional dependencies
# PRE_TARGETDEPS += $CUBE/lib/libcube4.a



# Hack for IBM AIX
aix-g++ {
  QMAKE_CXXFLAGS_RELEASE += -O0
}
aix-g++-64 {
  QMAKE_CXXFLAGS_RELEASE += -O0
}