#!/bin/sh
##*************************************************************************##
##  CUBE        http://www.scalasca.org/                                   ##
##*************************************************************************##
##  Copyright (c) 2020-2023                                                ##
##  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          ##
##                                                                         ##
##  This software may be modified and distributed under the terms of       ##
##  a BSD-style license.  See the COPYING file in the package base         ##
##  directory for details.                                                 ##
##*************************************************************************##


#QT=$HOME/Qt/5.15.2/
QT=$HOME/Qt/6.4.2/

arch=$1

if test "x$arch" == "xclean"; then
cmd="cmd_clean"
else
cmd=cmd_${2:-build}
fi


cmd_build()
{

echo "Read version and SHA in VERSION and REVISION files"

cat ../../build-config/VERSION | grep "package.major"  | sed -e "s/package\.major=//g"> package.major
cat ../../build-config/VERSION | grep "package.minor"  | sed -e "s/package\.minor=//g"> package.minor
cat ../../build-config/VERSION | grep "package.bugfix" | sed -e "s/package\.bugfix=//g"> package.bugfix
cat ../../build-config/VERSION | grep "package.suffix" | sed -e "s/package\.suffix=//g"> package.suffix

REVISION=$(cat ../../build-config/REVISION)

echo "Read Cube version"
PACKAGEMAJOR=$(cat package.major)
PACKAGEMINOR=$(cat package.minor)
PACKAGEBUGIX=$(cat package.bugfix)
PACKAGESUFFIX=$(cat package.suffix)

rm package.major
rm package.minor
rm package.bugfix
rm package.suffix

echo "Fix cibelib-version.h Backup"
cp ./include/cubelib-version.h ./cubelib-version.source
ls
echo "Fix version and SHA in version.h"
cat cubelib-version.source | sed -e "s/<REVISION SHA>/$REVISION/g" | sed -e "s/<PACKAGE MAJOR>/$PACKAGEMAJOR/g" |   sed -e "s/<PACKAGE MINOR>/$PACKAGEMINOR/g" |   sed -e "s/<PACKAGE BUGFIX>/$PACKAGEBUGIX/g" |   sed -e "s/<PACKAGE SUFFIX>/$PACKAGESUFFIX/g"  > ./include/cubelib-version.h
rm cubelib-version.source

QtVersion=`$QT/gcc_64/bin/qmake -query | grep "QT_VERSION" | grep "6."`

if test "x$QtVersion" = "x"; then
android_archs=''
else
android_archs='_arm64_v8a _armv7 _x86 _x86_64'
fi


ANDROID_QMAKE=$QT/android_$arch/bin/qmake
mkdir -p GUI-qt
curdir=`pwd`
for i in  cube \
        tools/common \
        tools/toolslibrary ;
        do
cd $i;
make clean
rm -f *.so
$ANDROID_QMAKE
echo ""
echo "=== Build library $i for $arch"
echo ""
make -j 14 apk_install_target
echo ""
echo " --- DONE"
echo ""
cd $curdir
done



}

cmd_clean()
{
curdir=`pwd`
for i in  cube \
        tools/common \
        tools/toolslibrary ;
        do
echo "=== Clean $i"
cd $i
make clean
rm -rf android-build
rm -f Makefile*
rm -f *.so
rm -f *.json
rm -rf arm64-v8a
rm -rf armeabi-v7a
rm -rf x86
rm -rf x86_64
cd $curdir
done
}

${cmd}
