/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2023                                                     **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


/**
 * \file cube4_pop_metrics_helper.cpp
 * \brief Provides definitions and some general routines
 *
 */

#include "config.h"
#include <algorithm>
#include <cstring>
#include <iostream>
#include <regex>
#include <vector>
#include "cube4_pop_metrics_helper.h"

void
popcalculation::parse_csint(   const std::string& str, std::vector<std::string>& result )
{
    typedef std::regex_iterator<std::string::const_iterator> re_iterator;
    typedef re_iterator::value_type                          re_iterated;

    std::regex re( "([^,]+)" );

    re_iterator rit( str.begin(), str.end(), re );
    re_iterator rend;

    std::transform( rit, rend, std::back_inserter( result ),
                    [ ]( const re_iterated& it ){
        return it[ 1 ];
    } );
}
