/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2023                                                     **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#include "config.h"

#include "POPServerPlugin.h"
#include "CubeProxy.h"
#include "CubeIoProxy.h"
#include "CubeTypes.h"
#include <algorithm>
#include <iostream>
#include <fstream>
#include <string>

#include "POPCalculation.h"

using namespace std;
using namespace cube;


const char*
popserver_plugin::POPServerPlugin::name() const
{
    return "POPAdvisorPlugin"; // this name is used by the client to identify the server plugin
}

std::vector<unsigned char>
popserver_plugin::POPServerPlugin::send( const std::vector<unsigned char>& dataFromClient,
                                         cube::CubeProxy*                  cube  )
{
    return popcalculation::POPCalculation::calculate( dataFromClient, dynamic_cast<cube::CubeIoProxy* > ( cube ) );
}
