/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2023-2025                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBELIB_POP_TRANSFER_TEST_H
#define CUBELIB_POP_TRANSFER_TEST_H

#include <string>
#include "PerformanceTest.h"


namespace mpianalysis
{
class POPTransferTest : public popcalculation::PerformanceTest
{
private:
    cube::Metric* max_total_time_ideal;
    cube::Metric* max_total_time;

    cube::list_of_metrics lmax_total_time_ideal;

    void
    add_max_total_time_ideal( cube::CubeProxy* ) const;

    void
    add_max_total_time( cube::CubeProxy* ) const;

protected:

    virtual
    const std::string&
    getCommentText() const;

    inline
    virtual
    std::string
    getHelpUrl() const
    {
        std::string active_text =
            "Transfer Efficiency (TE) measures inefficiencies due to time spent in data transfers:\n"
            "\tTE = (maximum total runtime across processes on an ideal network) / (maximum total measured runtime across processes)\n\n"
            "Here, the total runtime on an ideal network is defined as the runtime without the waiting time detected by Scalasca and MPI I/O time.";

        std::string not_active_text =
            "The Transfer Efficiency metric is only available when MPI wait states have been detected and measured.\n"
            "This means it is only applicable to trace analysis results from Scalasca, such as scout.cubex or trace.cubex files.";
        return isActive() ? active_text : not_active_text;
    }

    virtual
    void
    adjustForTest( cube::CubeProxy* cube ) const;

public:
    POPTransferTest( cube::CubeProxy* );

    virtual
    ~POPTransferTest()
    {
    };

    void
    applyCnode( const cube::list_of_cnodes& cnodes,
                const bool                  direct_calculation = false   );

    virtual
    double
    analyze( const cube::list_of_cnodes& cnodes,
             cube::LocationGroup*        _lg = nullptr ) const;

// ------ overview tests ---------

    bool
    isActive() const;

    bool
    isIssue() const;
};
};
#endif // POP_IMBALANCE_TEST_H
