/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2023-2025                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBELIB_PARALLEL_EFFICIENCY_TEST_H
#define CUBELIB_PARALLEL_EFFICIENCY_TEST_H

#include <string>
#include "PerformanceTest.h"
#include "POPImbalanceTest.h"
#include "POPCommunicationEfficiencyTest.h"

namespace mpianalysis
{
class POPParallelEfficiencyTest : public popcalculation::PerformanceTest
{
private:
    POPImbalanceTest*               pop_lb;
    POPCommunicationEfficiencyTest* pop_commeff;


    void
    calculate();


protected:



    virtual
    const std::string&
    getCommentText() const;

    inline
    virtual
    std::string
    getHelpUrl() const
    {
        std::string active_text =
            "Parallel Efficiency (PE) quantifies inefficiencies in parallel execution by evaluating two key factors:\n"
            "1. Load imbalance (how evenly work is distributed across processes)\n"
            "2. Communication overhead (time lost transferring data between processes)\n\n"
            "PE is calculated by combining these two components:\n"
            "\tPE = Load Balance Efficiency x Communication Efficiency";

        std::string not_active_text =
            "The Parallel Efficiency metric is a fundamental POP metric included in all\n"
            "Score-P/Scalasca measurements. If the Cube report originates from another tool instead of Score-P/Scalasca,\n"
            "it may lack the required 'Time' metric, making Parallel Efficiency analysis impossible.";

        return isActive() ? active_text : not_active_text;
    }

    virtual
    void
    adjustForTest( cube::CubeProxy* cube ) const;


public:
    POPParallelEfficiencyTest( POPImbalanceTest*               pop_lb,
                               POPCommunicationEfficiencyTest* pop_commeff );

    virtual
    ~POPParallelEfficiencyTest()
    {
    };

    void
    applyCnode( const cube::list_of_cnodes& cnodes,
                const bool                  direct_calculation = false   );

    bool
    isActive() const;

    bool
    isIssue() const;


    virtual
    std::list<PerformanceTest*>
    getPrereqs()
    {
        std::list<PerformanceTest*> prereqs;
        if ( pop_lb != nullptr && pop_commeff != nullptr )
        {
            prereqs.push_back( pop_lb );
            prereqs.push_back( pop_commeff );
        }
        return prereqs;
    }
};
};
#endif // ADVISER_RATING_WIDGET_H
