/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2015-2023                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#include <config.h>
#include <future>
#include <thread>

#include "POPParallelEfficiencyTest.h"

using namespace mpianalysis;

POPParallelEfficiencyTest::POPParallelEfficiencyTest( POPImbalanceTest*               _pop_lb,
                                                      POPCommunicationEfficiencyTest* _pop_commeff ) :
    popcalculation::PerformanceTest( nullptr ),
    pop_lb( _pop_lb ),
    pop_commeff( _pop_commeff )

{
    setName(  "Parallel Efficiency" );
    setWeight( 1 );   // need to be adjusted
    if ( pop_lb == nullptr || pop_commeff == nullptr )
    {
        setWeight( 0.2 );
        setValue( 0. );
        return;
    }
}

void
POPParallelEfficiencyTest::calculate()
{
    if ( pop_lb == nullptr || pop_commeff == nullptr )
    {
        return;
    }
    double lb_eff_value   = pop_lb->value();
    double comm_eff_value = pop_commeff->value();
    setValue( lb_eff_value *   comm_eff_value );
}

static
void
lb_task_full_( POPImbalanceTest*           _pop_lb,
               const cube::list_of_cnodes& cnodes )
{
    if ( _pop_lb )
    {
        _pop_lb->applyCnode( cnodes );
    }
}

static
void
comm_task_full_(
    POPCommunicationEfficiencyTest* _pop_commeff,
    const cube::list_of_cnodes&     cnodes )
{
    if ( _pop_commeff )
    {
        _pop_commeff->applyCnode( cnodes );
    }
}


void
POPParallelEfficiencyTest::applyCnode( const cube::list_of_cnodes& cnodes,
                                       const bool                  direct_calculation  )
{
    ( void )direct_calculation; // not used here

    auto lb_task_result   = std::async( std::launch::async, lb_task_full_, pop_lb, cnodes );
    auto comm_task_result = std::async( std::launch::async, comm_task_full_, pop_commeff, cnodes );

    lb_task_result.get();
    comm_task_result.get();



    calculate();
}


const std::string&
POPParallelEfficiencyTest::getCommentText() const
{
    return no_comment;
}


// ------ overview tests ---------

bool
POPParallelEfficiencyTest::isActive() const
{
    return pop_lb != nullptr &&
           pop_commeff != nullptr;
};

bool
POPParallelEfficiencyTest::isIssue() const
{
    return false;
};



void
POPParallelEfficiencyTest::adjustForTest( cube::CubeProxy* cube ) const
{
    ( void )cube;
}
