/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2023-2025                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBELIB_POP_IMBALANCE_TEST_H
#define CUBELIB_POP_IMBALANCE_TEST_H

#include <string>
#include "PerformanceTest.h"


namespace mpianalysis
{
class POPParallelEfficiencyTest;

class POPImbalanceTest : public popcalculation::PerformanceTest
{
    friend class POPParallelEfficiencyTest;


private:
    cube::Metric* pop_comp;


protected:


    virtual
    const std::string&
    getCommentText() const;

    inline
    virtual
    std::string
    getHelpUrl() const
    {
        std::string active_text =
            "Load Balance Efficiency measures the evenness of workload distribution across processes. It is calculated as:\n"
            "\tLoad Balance Efficiency = average computation time / maximum computation time among all processes\n"
            "\n"
            "This metric highlights workload imbalance. A value close to 1.0 indicates nearly ideal load balancing,\n"
            "whereas a significantly lower value shows underutilized processes causing inefficiency.";

        std::string not_active_text =
            "The Load Balance Efficiency metric is a core POP metric, automatically included\n"
            "in all Score-P/Scalasca measurements. However, if the Cube report originates from a different tracing tool,\n"
            "the required 'Time' metric may be absent, which would prevent POP analysis from being performed.";
        return isActive() ? active_text : not_active_text;
    }

    virtual
    void
    adjustForTest( cube::CubeProxy* cube ) const;

public:
    POPImbalanceTest( cube::CubeProxy* );

    virtual
    ~POPImbalanceTest()
    {
    };

    void
    applyCnode( const cube::list_of_cnodes& cnodes,
                const bool                  direct_calculation = false  );

    virtual
    double
    analyze( const cube::list_of_cnodes& cnodes,
             cube::LocationGroup*        _lg = nullptr ) const;

// ------ overview tests ---------

    bool
    isActive() const;

    bool
    isIssue() const;
};
};
#endif // POP_IMBALANCE_TEST_H
