/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2015-2024                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBELIB_POP_AUDIT_PERFORMANCE_ANALYSIS_H
#define CUBELIB_POP_AUDIT_PERFORMANCE_ANALYSIS_H

#include <string>
#include "Cube.h"


#include "PerformanceAnalysis.h"
#include "PerformanceTest.h"

#include "POPCommunicationEfficiencyTest.h"
#include "POPComputationTimeTest.h"
#include "POPGPUComputationTimeTest.h"
#include "POPIPCTest.h"
#include "POPImbalanceTest.h"
#include "POPIOEfficiencyTest.h"
#include "POPMpiIOTimeTest.h"
#include "POPNoWaitINSTest.h"
#include "POPParallelEfficiencyTest.h"
#include "POPSerialisationTest.h"
#include "POPStalledResourcesTest.h"
#include "POPTransferTest.h"
#include "POPWallTimeTest.h"
#include "POPPosixIOTimeTest.h"

#include "POPGPUParallelTest.h"
#include "POPGPUCommunicationEfficiencyTest.h"
#include "POPGPUImbalanceTest.h"


namespace mpianalysis
{
class POPAuditPerformanceAnalysis : public popcalculation::PerformanceAnalysis
{
private:
    std::string COMM_EFF_ISSUE;
    std::string LB_EFF_ISSUE;
    std::string SER_EFF_ISSUE;
    std::string TRANSFER_EFF_ISSUE;
    std::string STL_ISSUE;
    std::string IPC_ISSUE;


protected:
    POPCommunicationEfficiencyTest*          comm_eff;
    POPImbalanceTest*                        lb_eff;
    POPParallelEfficiencyTest*               par_eff;
    popcalculation::POPStalledResourcesTest* stalled_resources;
    popcalculation::POPNoWaitINSTest*        no_wait_ins;
    popcalculation::POPIPCTest*              ipc;
    popcalculation::POPWallTimeTest*         wall;
    popcalculation::POPComputationTime*      comp;
    popcalculation::POPGPUComputationTime*   gpu_comp;
    popcalculation::POPPosixIOTime*          posix_io;
    popcalculation::POPMpiIOTime*            mpi_io;
    popcalculation::POPIOEfficiencyTest*     io_eff;
    POPSerialisationTest*                    pop_ser_eff;
    POPTransferTest*                         pop_transfer_eff;

    popcalculation::POPGPUCommunicationEfficiencyTest* gpu_comm_eff;
    popcalculation::POPGPUImbalanceTest*               gpu_lb_eff;
    popcalculation::POPGPUParallelEfficiencyTest*      gpu_par_eff;

    double max_ipc;

public:
    POPAuditPerformanceAnalysis( cube::CubeProxy* _cube );

    virtual
    ~POPAuditPerformanceAnalysis();


    virtual
    inline
    std::string
    name() const
    {
        return "Only-MPI Assessment";
    }


    // returns list of tests, which can be calculated independentely in sepaate tasks
    virtual
    std::list<popcalculation::PerformanceTest*>
    getAllTestsForCalculation();

    virtual
    std::list<popcalculation::PerformanceTest*>
    getPOPTests();

    virtual
    std::list<popcalculation::PerformanceTest*>
    getGPUTests();

    virtual
    std::list<popcalculation::PerformanceTest*>
    getIOTests();

    virtual
    std::list<popcalculation::PerformanceTest*>
    getAdditionalTests();

    virtual
    std::list<popcalculation::PerformanceTest*>
    getControlTests();

    virtual
    std::string
    getAnchorHowToMeasure();

// ------ overview tests ---------

    virtual
    bool
    isActive() const;
};
};

#endif // ADVISER_RATING_WIDGET_H
