/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2023-2025                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBELIB_POP_HYBRID_THREAD_EFFICIENCY_TEST_H
#define CUBELIB_POP_HYBRID_THREAD_EFFICIENCY_TEST_H

#include <string>
#include "PerformanceTest.h"
#include "POPHybridOMPRegionEfficiencyTest.h"
#include "POPHybridAmdahlTest.h"

namespace hybanalysis
{
class POPHybridParallelEfficiencyTest;
class POPHybridThreadEfficiencyTest : public popcalculation::PerformanceTest
{
    friend  class POPHybridParallelEfficiencyTest;
private:
    POPHybridAmdahlTest*              amdahl_eff;
    POPHybridOmpRegionEfficiencyTest* omp_region_eff;

    cube::Metric* pop_avg_comp;
    cube::Metric* pop_max_omp_comp;
    cube::Metric* pop_avg_ser_comp;

    cube::list_of_metrics lavg_omp_metrics;
    cube::list_of_metrics lavg_ser_metrics;

    void
    calculate();

    void
    calculate( const cube::list_of_cnodes& );

protected:

    virtual
    const std::string&
    getCommentText() const;

    inline
    virtual
    std::string
    getHelpUrl() const
    {
        std::string active_text =
            "Thread Efficiency evaluates parallelization quality by analyzing two inefficiency sources:\n"
            "1. Serial work outside OpenMP regions (Amdahl's law)\n"
            "2. Intra-thread inefficiencies (e.g., thread synchronization)\n"
            "Calculated directly as:\n"
            "Thread_Efficiency = avg(computation_time) / (avg(OpenMP_time) + avg(serial_computation))\n"
            "or as the product:\n"
            "Thread_Efficiency = Amdahl's_Efficiency x OpenMP_Region_Efficiency\n"
            "Note: Averages default to weighted arithmetic means, switching to ordinary means when threads are evenly distributed.";

        std::string not_active_text =
            "Thread Efficiency requires precise timing metrics from Score-P/Scalasca measurements.\n"
            "Alternative tools may omit the essential 'Time' metric, making accurate Thread Efficiency analysis impossible.";
        return isActive() ? active_text : not_active_text;
    }

    virtual
    void
    adjustForTest( cube::CubeProxy* cube ) const;


public:
    POPHybridThreadEfficiencyTest(     cube::CubeProxy*,
                                       POPHybridAmdahlTest*              amdahl_eff,
                                       POPHybridOmpRegionEfficiencyTest* omp_region_eff
                                       );

    virtual
    ~POPHybridThreadEfficiencyTest()
    {
    };
// ------ overview tests ---------

    void
    applyCnode( const cube::list_of_cnodes& cnodes,
                const bool                  direct_calculation = false   );


    bool
    isActive() const;

    bool
    isIssue() const;

    virtual
    std::list<PerformanceTest*>
    getPrereqs()
    {
        std::list<PerformanceTest*> prereqs;
        if ( amdahl_eff != nullptr && omp_region_eff != nullptr )
        {
            prereqs.push_back( amdahl_eff );
            prereqs.push_back( omp_region_eff );
        }
        return prereqs;
    }
};
};
#endif // ADVISER_RATING_WIDGET_H
