/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2023-2025                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBEGUIPLUGIN_POP_HYBRID_PARALLEL_EFFICIENCY_TEST_H
#define CUBEGUIPLUGIN_POP_HYBRID_PARALLEL_EFFICIENCY_TEST_H

#include <string>
#include "PerformanceTest.h"
#include "POPHybridProcessEfficiencyTest.h"
#include "POPHybridThreadEfficiencyTest.h"

namespace hybanalysis
{
class POPHybridParallelEfficiencyTest : public popcalculation::PerformanceTest
{
private:
    cube::Metric* pop_avg_comp;
    cube::Metric* max_runtime;

    cube::list_of_metrics max_runtime_metrics;


    POPHybridProcessEfficiencyTest* proc_eff;
    POPHybridThreadEfficiencyTest*  thread_eff;

    void
    calculate();

    void
    calculate( const cube::list_of_cnodes& );

protected:

    void
    applyCnode( const cube::list_of_cnodes& cnodes,
                const bool                  direct_calculation = false  );


    virtual
    const std::string&
    getCommentText() const;

    inline
    virtual
    std::string
    getHelpUrl() const
    {
        std::string active_text =
            "Parallel Efficiency (PE) quantifies the effectiveness of workload distribution across processes and threads\n"
            "by combining Process Efficiency and Thread Efficiency. It can be calculated directly using:\n"
            "PE = avg(computation_time) / max(process_runtime)\n"
            "or through these sub-metrics:\n"
            "PE = Process_Efficiency x Thread_Efficiency";

        std::string not_active_text =
            "The Parallel Efficiency metric requires Score-P/Scalasca measurements as it depends on the essential 'Time' metric.\n"
            "Reports generated by other tools may lack this metric, making accurate Parallel Efficiency analysis impossible.";

        return isActive() ? active_text : not_active_text;
    }

    virtual
    void
    adjustForTest( cube::CubeProxy* cube ) const;


public:
    POPHybridParallelEfficiencyTest(  cube::CubeProxy*,
                                      POPHybridProcessEfficiencyTest* proc_eff,
                                      POPHybridThreadEfficiencyTest*  thread_eff );

    virtual
    ~POPHybridParallelEfficiencyTest()
    {
    };
// ------ overview tests ---------

    bool
    isActive() const;

    bool
    isIssue() const;


    virtual
    std::list<PerformanceTest*>
    getPrereqs()
    {
        std::list<PerformanceTest*> prereqs;
        if ( proc_eff != nullptr && thread_eff != nullptr )
        {
            prereqs.push_back( proc_eff );
            prereqs.push_back( thread_eff );
        }
        return prereqs;
    }
};
};
#endif // ADVISER_RATING_WIDGET_H
