/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2023-2025                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBELIB_POP_HYBRID_OMP_REGION_TEST_H
#define CUBELIB_POP_HYBRID_OMP_REGION_TEST_H

#include <string>
#include "PerformanceTest.h"


namespace hybanalysis
{
class POPHybridThreadEfficiencyTest;
class POPHybridOmpRegionEfficiencyTest : public popcalculation::PerformanceTest
{
    friend class POPHybridThreadEfficiencyTest;

private:
    cube::Metric* pop_max_omp_comp;
    cube::Metric* pop_avg_omp_comp;
    cube::Metric* pop_avg_ser_comp;

    cube::list_of_metrics lavg_omp_metrics;
    cube::list_of_metrics lavg_ser_metrics;

protected:

    virtual
    const std::string&
    getCommentText() const;

    inline
    virtual
    std::string
    getHelpUrl() const
    {
        std::string active_text =
            "OpenMP Region Efficiency measures parallel region performance using this formula:\n"
            "OpenMP_Region_Efficiency = (avg(useful_OpenMP_computation) + avg(serial_computation)) / "
            "(avg(total_OpenMP_time) + avg(serial_computation)).\n"
            "Averages are computed as weighted arithmetic means by default. When threads are equally distributed "
            "across processes, these averages simplify to ordinary arithmetic means.";

        std::string not_active_text =
            "The OpenMP Region Efficiency metric requires Score-P/Scalasca measurements. If generated by other tools, "
            "the essential Time metric may be missing, which would prevent accurate POP analysis of OpenMP regions.";

        return isActive() ? active_text : not_active_text;
    }

    virtual
    void
    adjustForTest( cube::CubeProxy* cube ) const;

public:
    POPHybridOmpRegionEfficiencyTest( cube::CubeProxy* );

    virtual
    ~POPHybridOmpRegionEfficiencyTest()
    {
    };

    virtual
    double
    analyze( const cube::list_of_cnodes& cnodes,
             cube::LocationGroup*        _lg = nullptr ) const;

// ------ overview tests ---------

    void
    applyCnode( const cube::list_of_cnodes& cnodes,
                const bool                  direct_calculation = false  );


    bool
    isActive() const;

    bool
    isIssue() const;
};
};
#endif // POPHybrid_IMBALANCE_TEST_H
