/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2023-2025                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBELIB_POP_HYBRID_IMBALANCE_TEST_H
#define CUBELIB_POP_HYBRID_IMBALANCE_TEST_H

#include <string>
#include "PerformanceTest.h"


namespace hybanalysis
{
class POPHybridProcessEfficiencyTest;
class POPHybridImbalanceTest : public popcalculation::PerformanceTest
{
    friend class POPHybridProcessEfficiencyTest;
private:
    cube::Metric* pop_avg_omp;
    cube::Metric* pop_avg_ser_comp;
    cube::Metric* max_omp_serial_comp_time;

    cube::list_of_metrics lavg_omp_metrics;
    cube::list_of_metrics lavg_ser_metrics;


protected:



    virtual
    const std::string&
    getCommentText() const;

    inline
    virtual
    std::string
    getHelpUrl() const
    {
        std::string active_text =
            "Computation Load Balance can be evaluated using this formula: "
            "Computation_Load_Balance = (avg(OpenMP_time) + avg(serial_computation)) / max(OpenMP_time + serial_computation).\n"
            "Note: Both averages are computed as weighted arithmetic means by default.\n"
            "When thread counts are equal across processes, these averages simplify to ordinary arithmetic means.";

        std::string not_active_text =
            "The Computation Load Balance metric requires Score-P/Scalasca measurements to be available.\n"
            "If the Cube Report was generated by a tool other than Score-P/Scalasca, it may lack the required Time metric,\n"
            "making POP analysis of load balance impossible.";

        return isActive() ? active_text : not_active_text;
    }

    virtual
    void
    adjustForTest( cube::CubeProxy* cube ) const;

public:
    POPHybridImbalanceTest( cube::CubeProxy* );

    virtual
    ~POPHybridImbalanceTest()
    {
    };

    virtual
    double
    analyze( const cube::list_of_cnodes& cnodes,
             cube::LocationGroup*        _lg = nullptr ) const;




// ------ overview tests ---------
    void
    applyCnode( const cube::list_of_cnodes& cnodes,
                const bool                  direct_calculation = false );


    bool
    isActive() const;

    bool
    isIssue() const;
};
};
#endif // POPHybrid_IMBALANCE_TEST_H
