/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2015-2024                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBELIB_POP_HYBRID_AUDIT_PERFORMANCE_ANALYSIS_H
#define CUBELIB_POP_HYBRID_AUDIT_PERFORMANCE_ANALYSIS_H

#include <string>
#include "Cube.h"


#include "PerformanceAnalysis.h"
#include "PerformanceTest.h"


#include "POPComputationTimeTest.h"
#include "POPGPUComputationTimeTest.h"
#include "POPHybridAmdahlTest.h"
#include "POPHybridCommunicationEfficiencyTest.h"
#include "POPHybridImbalanceTest.h"
#include "POPHybridOMPRegionEfficiencyTest.h"
#include "POPHybridParallelEfficiencyTest.h"
#include "POPHybridProcessEfficiencyTest.h"
#include "POPHybridSerialisationTest.h"
#include "POPHybridThreadEfficiencyTest.h"
#include "POPHybridTransferTest.h"
#include "POPIPCTest.h"
#include "POPNoWaitINSTest.h"
#include "POPStalledResourcesTest.h"
#include "POPWallTimeTest.h"
#include "POPIOEfficiencyTest.h"
#include "POPMpiIOTimeTest.h"
#include "POPPosixIOTimeTest.h"

#include "POPGPUParallelTest.h"
#include "POPGPUCommunicationEfficiencyTest.h"
#include "POPGPUImbalanceTest.h"


namespace hybanalysis
{
class POPHybridAuditPerformanceAnalysis : public popcalculation::PerformanceAnalysis
{
protected:

    popcalculation::POPStalledResourcesTest* stalled_resources;
    popcalculation::POPNoWaitINSTest*        no_wait_ins;
    popcalculation::POPIPCTest*              ipc;
    popcalculation::POPWallTimeTest*         wall;
    popcalculation::POPComputationTime*      comp;
    popcalculation::POPGPUComputationTime*   gpu_comp;

    popcalculation::POPPosixIOTime*      posix_io;
    popcalculation::POPMpiIOTime*        mpi_io;
    popcalculation::POPIOEfficiencyTest* io_eff;

    POPHybridTransferTest*                pop_transfer_eff;
    POPHybridSerialisationTest*           pop_ser_eff;
    POPHybridCommunicationEfficiencyTest* comm_eff;
    POPHybridImbalanceTest*               lb_eff;
    POPHybridProcessEfficiencyTest*       proc_eff;

    POPHybridOmpRegionEfficiencyTest* omp_region_eff;
    POPHybridAmdahlTest*              pop_amdahl_eff;

    POPHybridThreadEfficiencyTest* thread_eff;

    POPHybridParallelEfficiencyTest* par_eff;

    popcalculation::POPGPUCommunicationEfficiencyTest* gpu_comm_eff;
    popcalculation::POPGPUImbalanceTest*               gpu_lb_eff;
    popcalculation::POPGPUParallelEfficiencyTest*      gpu_par_eff;


    double max_ipc;

public:
    POPHybridAuditPerformanceAnalysis( cube::CubeProxy* _cube );

    virtual
    ~POPHybridAuditPerformanceAnalysis();


    virtual
    inline
    std::string
    name() const
    {
        return "Multiplicative Hybrid Assessment";
    }

    // returns list of tests, which can be calculated independentely in sepaate tasks
    virtual
    std::list<popcalculation::PerformanceTest*>
    getAllTestsForCalculation();

    virtual
    std::list<popcalculation::PerformanceTest*>
    getPOPTests();

    virtual
    std::list<popcalculation::PerformanceTest*>
    getGPUTests();

    virtual
    std::list<popcalculation::PerformanceTest*>
    getIOTests();

    virtual
    std::list<popcalculation::PerformanceTest*>
    getAdditionalTests();

    virtual
    std::list<popcalculation::PerformanceTest*>
    getControlTests();


    virtual
    std::string
    getAnchorHowToMeasure();

// ------ overview tests ---------

    virtual
    bool
    isActive() const;
};
};

#endif // ADVISER_RATING_WIDGET_H
