/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2023-2025                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBELIB_POP_HYBRID_AMDAHL_TEST_H
#define CUBELIB_POP_HYBRID_AMDAHL_TEST_H

#include <string>
#include "PerformanceTest.h"


namespace hybanalysis
{
class POPHybridThreadEfficiencyTest;

class POPHybridAmdahlTest : public popcalculation::PerformanceTest
{
    friend class POPHybridThreadEfficiencyTest;
private:
    cube::Metric* pop_avg_comp;
    cube::Metric* pop_avg_omp_comp;
    cube::Metric* pop_avg_ser_comp;

    cube::list_of_metrics lavg_omp_metrics;
    cube::list_of_metrics lavg_ser_metrics;

    void
    add_amdahl( cube::CubeProxy* ) const;

    void
    add_avg_comp( cube::CubeProxy* ) const;

protected:


    virtual
    const std::string&
    getCommentText() const;

    inline
    virtual
    std::string
    getHelpUrl() const
    {
        const std::string active_text =
            "Amdahl's Efficiency is computed using the formula: "
            "avg(computation_time) / (avg(useful_OpenMP_time) + avg(serial_computation)). "
            "The serial computation is calculated as a weighted arithmetic mean when thread counts vary "
            "across processes, or as an ordinary arithmetic mean if thread counts are equal.";

        const std::string not_active_text =
            "Amdahl's Efficiency metric might be missing when the Cube Report was generated by tools other "
            "than Score-P/Scalasca, as it requires the Time metric that's only available from Score-P/Scalasca "
            "measurements for proper POP analysis.";

        return isActive() ? active_text : not_active_text;
    }

    virtual
    void
    adjustForTest( cube::CubeProxy* cube ) const;

public:
    POPHybridAmdahlTest( cube::CubeProxy* );

    virtual
    ~POPHybridAmdahlTest()
    {
    };
// ------ overview tests ---------

    void
    applyCnode( const cube::list_of_cnodes& cnodes,
                const bool                  direct_calculation = false   );


    bool
    isActive() const;

    bool
    isIssue() const;
};
};
#endif // POPHybrid_IMBALANCE_TEST_H
