/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2023-2025                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBELIB_POP_HYBRID_PROCESS_EFFICIENCY_TEST_ADD_H
#define CUBELIB_POP_HYBRID_PROCESS_EFFICIENCY_TEST_ADD_H

#include <string>
#include "PerformanceTest.h"
#include "POPHybridImbalanceTestAdd.h"
#include "POPHybridCommunicationEfficiencyTestAdd.h"

namespace hybaddanalysis
{
class POPHybridParallelEfficiencyTestAdd;
class POPHybridProcessEfficiencyTestAdd : public popcalculation::PerformanceTest
{
    friend class POPHybridParallelEfficiencyTestAdd;
private:


    POPHybridImbalanceTestAdd*               pop_lb;
    POPHybridCommunicationEfficiencyTestAdd* pop_commeff;


    cube::Metric* max_runtime;
    cube::Metric* pop_avg_omp;
    cube::Metric* pop_avg_ser_comp;

    cube::list_of_metrics max_runtime_metrics;
    cube::list_of_metrics lavg_omp_metrics;
    cube::list_of_metrics lavg_ser_metrics;

    void
    calculate();

    void
    calculate( const cube::list_of_cnodes& );


protected:

    virtual
    const std::string&
    getCommentText() const;

    inline
    virtual
    std::string
    getHelpUrl() const
    {
        std::string active_text =
            "Process Efficiency evaluates process utilization while completely ignoring thread-level behavior.\n"
            "It assesses two key components:\n"
            "- Workload distribution across processes (Computation Load Balance)\n"
            "- Communication between processes (MPI Communication Efficiency)\n"
            "\n"
            "Process Efficiency can be calculated using either of these equivalent formulas:\n"
            "\tProcess Efficiency = (avg(time in OpenMP region) + avg(serial computation time)) / max(runtime)\n"
            "\n\tOR\n"
            "\tProcess Efficiency = Computation Load Balance + MPI Communication Efficiency - 1\n"
            "\n"
            "Note: The averages are computed as weighted arithmetic means. \n"
            "If thread counts are identical across processes, these averages simplify to ordinary arithmetic means.";

        std::string not_active_text =
            "The Process Efficiency metric is a fundamental POP metric available in all Score-P/Scalasca measurements.\n"
            "\n"
            "When a Cube Report originates from tools other than Score-P/Scalasca, it may lack the essential 'Time' metric.\n"
            "Without this metric, POP analysis cannot be performed.";

        return isActive() ? active_text : not_active_text;
    }

    virtual
    void
    adjustForTest( cube::CubeProxy* cube ) const;


public:
    POPHybridProcessEfficiencyTestAdd(      cube::CubeProxy*,
                                            POPHybridImbalanceTestAdd*               pop_lb,
                                            POPHybridCommunicationEfficiencyTestAdd* pop_commeff );

    virtual
    ~POPHybridProcessEfficiencyTestAdd()
    {
    };
// ------ overview tests ---------

    void
    applyCnode( const cube::list_of_cnodes& cnodes,
                const bool                  direct_calculation = false   );



    bool
    isActive() const;

    bool
    isIssue() const;

    virtual
    std::list<PerformanceTest*>
    getPrereqs()
    {
        std::list<PerformanceTest*> prereqs;
        if ( pop_lb != nullptr && pop_commeff != nullptr )
        {
            prereqs.push_back( pop_lb );
            prereqs.push_back( pop_commeff );
        }
        return prereqs;
    }
};
};
#endif // ADVISER_RATING_WIDGET_H
