/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2023-2025                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBELIB_POP_HYBRID_PARALLEL_EFFICIENCY_TEST_ADD_H
#define CUBELIB_POP_HYBRID_PARALLEL_EFFICIENCY_TEST_ADD_H

#include <string>
#include "PerformanceTest.h"
#include "POPHybridProcessEfficiencyTestAdd.h"
#include "POPHybridThreadEfficiencyTestAdd.h"

namespace hybaddanalysis
{
class POPHybridParallelEfficiencyTestAdd : public popcalculation::PerformanceTest
{
private:
    cube::Metric* pop_avg_comp;
    cube::Metric* max_runtime;

    cube::list_of_metrics max_runtime_metrics;


    POPHybridProcessEfficiencyTestAdd* proc_eff;
    POPHybridThreadEfficiencyTestAdd*  thread_eff;

    void
    calculate();

    void
    calculate( const cube::list_of_cnodes& );


protected:

    void
    applyCnode( const cube::list_of_cnodes& cnodes,
                const bool                  direct_calculation = false   );


    virtual
    const std::string&
    getCommentText() const;

    inline
    virtual
    std::string
    getHelpUrl() const
    {
        std::string active_text =
            "Parallel Efficiency (PE) reveals inefficiencies in process and thread utilization. It is measured through two sub-metrics:\n"
            "- Process Efficiency\n"
            "- Thread Efficiency\n"
            "\n"
            "PE can be calculated using either of these formulas:\n"
            "\tPE = avg(computation time) / max(runtime)\n"
            "\tPE = Process Efficiency + Thread Efficiency - 1";

        std::string not_active_text =
            "Parallel Efficiency is a basic POP metric available in all Score-P/Scalasca measurements.\n"
            "\n"
            "If the Cube Report was generated by a tool other than Score-P/Scalasca, it may lack the required 'Time' metric.\n"
            "In this case, POP analysis cannot be performed.";

        return isActive() ? active_text : not_active_text;
    }

    virtual
    void
    adjustForTest( cube::CubeProxy* cube ) const;


public:
    POPHybridParallelEfficiencyTestAdd( cube::CubeProxy*,
                                        POPHybridProcessEfficiencyTestAdd* proc_eff,
                                        POPHybridThreadEfficiencyTestAdd*  thread_eff );

    virtual
    ~POPHybridParallelEfficiencyTestAdd()
    {
    };
// ------ overview tests ---------

    bool
    isActive() const;

    bool
    isIssue() const;


    virtual
    std::list<PerformanceTest*>
    getPrereqs()
    {
        std::list<PerformanceTest*> prereqs;
        if ( proc_eff != nullptr && thread_eff != nullptr )
        {
            prereqs.push_back( proc_eff );
            prereqs.push_back( thread_eff );
        }
        return prereqs;
    }
};
};
#endif // ADVISER_RATING_WIDGET_H
