/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2023-2025                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBELIB_POP_HYBRID_OMP_REGION_TEST_ADD_H
#define CUBELIB_POP_HYBRID_OMP_REGION_TEST_ADD_H

#include <string>
#include "PerformanceTest.h"


namespace hybaddanalysis
{
class POPHybridParallelEfficiencyTest;
class POPHybridOmpRegionEfficiencyTestAdd : public popcalculation::PerformanceTest
{
    friend class POPHybridParallelEfficiencyTest;
private:
    cube::Metric* pop_avg_omp;
    cube::Metric* pop_avg_omp_comp;
    cube::Metric* max_runtime;

    cube::list_of_metrics lavg_omp_metrics;
    cube::list_of_metrics lmax_runtime_metrics;

    void
    add_omp_lb_eff( cube::CubeProxy* ) const;

    void
    add_avg_omp_comp_time( cube::CubeProxy* ) const;

    void
    add_max_omp_comp_time( cube::CubeProxy* ) const;

protected:

    virtual
    const std::string&
    getCommentText() const;

    inline
    virtual
    std::string
    getHelpUrl() const
    {
        std::string active_text =
            "OpenMP Region Efficiency indicates inefficiencies within parallelized threads and can be computed as follows:\n"
            "\tOpenMP Region Efficiency = (max(runtime) - avg(time in OpenMP region)\n"
            "\t                               + avg(time in useful computation within OpenMP region) ) / max(runtime)\n"
            "Where the average time in OpenMP is computed as a weighted arithmetic mean.\n"
            "If the number of threads is equal across processes, this average can be computed as an ordinary arithmetic mean.";

        std::string not_active_text =
            "The OpenMP Region Efficiency metric is a basic POP (Performance on Paper) metric and is available in every Score-P/Scalasca measurement.\n"
            "\n"
            "If the Cube Report was produced by a tool other than Score-P/Scalasca, it might lack the 'Time' metric.\n"
            "In this case, POP analysis is not possible.";

        return isActive() ? active_text : not_active_text;
    }

    virtual
    void
    adjustForTest( cube::CubeProxy* cube ) const;

public:
    POPHybridOmpRegionEfficiencyTestAdd( cube::CubeProxy* );

    virtual
    ~POPHybridOmpRegionEfficiencyTestAdd()
    {
    };

    virtual
    double
    analyze( const cube::list_of_cnodes& cnodes,
             cube::LocationGroup*        _lg = nullptr ) const;

// ------ overview tests ---------

    void
    applyCnode( const cube::list_of_cnodes& cnodes,
                const bool                  direct_calculation = false    );


    bool
    isActive() const;

    bool
    isIssue() const;
};
};
#endif // POPHybrid_IMBALANCE_TEST_H
