/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2023-2025                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBELIB_POP_GPU_PARALLEL_TIME_H
#define CUBELIB_POP_GPU_PARALLEL_TIME_H

#include <string>
#include "PerformanceTest.h"
#include "POPGPUImbalanceTest.h"
#include "POPGPUCommunicationEfficiencyTest.h"


namespace popcalculation
{
class POPGPUParallelEfficiencyTest : public PerformanceTest
{
private:
    POPGPUImbalanceTest*               pop_gpu_lb;
    POPGPUCommunicationEfficiencyTest* pop_gpu_commeff;

    void
    calculate();

protected:


    virtual
    const std::string&
    getCommentText() const;

    inline
    virtual
    std::string
    getHelpUrl() const
    {
        std::string active_text =
            "GPU Parallel Efficiency evaluates the proportion of useful GPU computation time relative to the overall \n"
            "execution duration. It is calculated as:\n"
            "\tGPU Parallel Efficiency = GPU Load Balance Efficiency  * GPU Communication Efficiency \n\n"
            "This metric provides insight into how effectively the GPU resources are utilized throughout the application's \n"
            "execution, highlighting potential bottlenecks where GPU operations do not fully leverage available parallel \n"
            "processing capabilities.";

        std::string not_active_text =
            "GPU Parallel Efficiency analysis requires specialized instrumentation that captures both GPU-specific \n"
            "and overall timing information.\n"
            "This metric is fully supported exclusively in Score-P/Scalasca measurements that include:\n"
            "\t- Comprehensive timing metrics for both GPU operations and overall execution\n"
            "\t- Proper GPU device instrumentation and profiling data\n"
            "When utilizing Cube Reports from alternative profiling tools or when:\n"
            "\t- The essential Time metric or GPU timing information is missing\n"
            "\t- There is insufficient GPU instrumentation\n"
            "the GPU Parallel Efficiency calculation cannot be performed accurately.\n"
            "In such cases, the metric will be reported as undefined (NAN), \n"
            "preventing complete POP analysis of GPU parallel efficiency.";

        return active_text;
    }

    virtual
    void
    adjustForTest( cube::CubeProxy* cube ) const;

public:
    POPGPUParallelEfficiencyTest( POPGPUImbalanceTest*               pop_gpu_lb,
                                  POPGPUCommunicationEfficiencyTest* pop_gpu_commeff  );

    virtual
    ~POPGPUParallelEfficiencyTest()
    {
    };
// ------ overview tests ---------


    void
    applyCnode( const cube::list_of_cnodes& cnodes,
                const bool                  direct_calculation = false   );

    virtual
    inline
    bool
    isPercent() const
    {
        return false;
    }

    bool
    isActive() const;

    bool
    isIssue() const;

    virtual
    inline
    bool
    isNormalized() const // returns true, if range goes from 0 to 1. false -> otherwise
    {
        return false;
    }

    inline
    virtual
    std::string
    units() const
    {
        return "%";
    }

    virtual
    std::list<PerformanceTest*>
    getPrereqs()
    {
        std::list<PerformanceTest*> prereqs;
        if ( pop_gpu_lb != nullptr && pop_gpu_commeff != nullptr )
        {
            prereqs.push_back( pop_gpu_lb );
            prereqs.push_back( pop_gpu_commeff );
        }
        return prereqs;
    }
};
};
#endif // POP_ipc_TEST_H
