/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2023                                                     **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#include <config.h>
#include <future>
#include <thread>

#include "POPGPUParallelTest.h"


using namespace popcalculation;

POPGPUParallelEfficiencyTest::POPGPUParallelEfficiencyTest( POPGPUImbalanceTest*               _pop_gpu_lb,
                                                            POPGPUCommunicationEfficiencyTest* _pop_gpu_commeff ) :
    popcalculation::PerformanceTest( nullptr ),
    pop_gpu_lb( _pop_gpu_lb ),
    pop_gpu_commeff( _pop_gpu_commeff )
{
    setName(  "GPU Parallel Efficiency" );
    setWeight( 1 );   // need to be adjusted
    if ( pop_gpu_lb == nullptr || pop_gpu_commeff == nullptr )
    {
        setWeight( 0.2 );
        setValue( 0. );
        return;
    }
}


void
POPGPUParallelEfficiencyTest::calculate()
{
    if ( pop_gpu_lb == nullptr || pop_gpu_commeff == nullptr )
    {
        return;
    }
    double gpu_lb_eff_value   = pop_gpu_lb->value();
    double gpu_comm_eff_value = pop_gpu_commeff->value();
    setValue( gpu_lb_eff_value *   gpu_comm_eff_value );
}

static
void
gpu_lb_task_full_( POPGPUImbalanceTest*        _pop_gpu_lb,
                   const cube::list_of_cnodes& cnodes )
{
    if ( _pop_gpu_lb )
    {
        _pop_gpu_lb->applyCnode( cnodes );
    }
}

static
void
gpu_comm_task_full_(
    POPGPUCommunicationEfficiencyTest* _pop_gpu_commeff,
    const cube::list_of_cnodes&        cnodes )
{
    if ( _pop_gpu_commeff )
    {
        _pop_gpu_commeff->applyCnode( cnodes );
    }
}


void
POPGPUParallelEfficiencyTest::applyCnode( const cube::list_of_cnodes& cnodes,
                                          const bool                  direct_calculation  )
{
    ( void )direct_calculation; // not used here

    auto gpu_lb_task_result   = std::async( std::launch::async, gpu_lb_task_full_, pop_gpu_lb, cnodes );
    auto gpu_comm_task_result = std::async( std::launch::async, gpu_comm_task_full_, pop_gpu_commeff, cnodes );

    gpu_lb_task_result.get();
    gpu_comm_task_result.get();



    calculate();
}


const std::string&
POPGPUParallelEfficiencyTest::getCommentText() const
{
    return no_comment;
}


// ------ overview tests ---------

bool
POPGPUParallelEfficiencyTest::isActive() const
{
    return pop_gpu_lb != nullptr &&
           pop_gpu_commeff != nullptr &&
           pop_gpu_lb->isActive() &&
           pop_gpu_commeff->isActive()
    ;
};

bool
POPGPUParallelEfficiencyTest::isIssue() const
{
    return false;
};



void
POPGPUParallelEfficiencyTest::adjustForTest( cube::CubeProxy* cube ) const
{
    ( void )cube;
}
