/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2023-2025                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBELIB_POP_GPU_COMMUNICATION_EFFICENCY_TEST_H
#define CUBELIB_POP_GPU_COMMUNICATION_EFFICENCY_TEST_H

#include <string>
#include "PerformanceTest.h"

namespace popcalculation
{
class POPGPUParallelEfficiencyTest;

class POPGPUCommunicationEfficiencyTest : public popcalculation::PerformanceTest
{
    friend class POPGPUParallelEfficiencyTest;

private:
    cube::Metric* max_all_kernels_executions;
    cube::Metric* max_runtime;

    cube::list_of_metrics lmax_all_kernels_executions;

protected:

    const std::string&
    getCommentText() const;

    inline
    virtual
    std::string
    getHelpUrl() const
    {
        std::string active_text =
            "GPU Communication Efficiency (GPUCommE) measures the proportion of useful computation time\n"
            "relative to total execution time across all GPU streams.\n"
            "It is calculated as the maximum value across all GPU streams of:\n"
            "\tGPUCommE = maximum across gpu streams(computation time / wallclock runtime)\n\n"
            "This metric helps identify performance bottlenecks caused by excessive data transfer operations\n"
            "rather than productive GPU computations, highlighting potential inefficiencies in CUDA\n"
            "or OpenCL stream utilization patterns.";

        std::string not_active_text =
            "GPU Communication Efficiency analysis requires actual GPU utilization in the application.\n"
            "This metric is only available when the Score-P/Scalasca measurement includes GPU-specific\n"
            "regions and timing metrics. If the Cube Report:\n"
            "\t- Was generated by tools other than Score-P/Scalasca, or\n"
            "\t- Contains no GPU-related timing information or stream data,\n"
            "then the GPU Communication Efficiency calculation cannot be performed.";

        return active_text;
    }

    virtual
    void
    adjustForTest( cube::CubeProxy* cube ) const;


public:
    POPGPUCommunicationEfficiencyTest(
        cube::CubeProxy* );

    virtual
    ~POPGPUCommunicationEfficiencyTest()
    {
    };

    void
    applyCnode( const cube::list_of_cnodes& cnodes,
                const bool                  direct_calculation = false   );


    virtual
    double
    analyze( const cube::list_of_cnodes& cnodes,
             cube::LocationGroup*        _lg = nullptr ) const;

// ------ overview tests ---------

    bool
    isActive() const;

    bool
    isIssue() const;
};
};
#endif // ADVISER_RATING_WIDGET_H
