/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2023-2025                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBELIB_POP_STALLED_RESOURCES_TEST_H
#define CUBELIB_POP_STALLED_RESOURCES_TEST_H

#include <string>
#include "PerformanceTest.h"


namespace popcalculation
{
class POPStalledResourcesTest : public PerformanceTest
{
private:
    cube::Metric* pop_stalled_resources;


protected:

    void
    applyCnode( const cube::list_of_cnodes& cnodes,
                const bool                  direct_calculation = false   );

    virtual
    const std::string&
    getCommentText() const;

    inline
    virtual
    std::string
    getHelpUrl() const
    {
        std::string active_text =
            "Stalled Resources indicates what fraction of computational cycles in user code \n"
            "the processor spent waiting for hardware resources. When PAPI counters are available,\n"
            "this is calculated as PAPI_RES_STL / PAPI_TOT_CYC.\n"
            "With Perf counters, you can use one of these alternatives based on availability:\n"
            "\t(stalled-cycles-frontend + stalled-cycles-backend) / total-cycles\n"
            "\tstalled-cycles-frontend / total-cycles\n"
            "\tstalled-cycles-backend / total-cycles\n";

        std::string not_active_text =
            "The Stalled Resources metric requires either:\n"
            "- PAPI counters including PAPI_RES_STL (resource stalls) and PAPI_TOT_CYC (total cycles), or\n"
            "- Perf counters for stalls (frontend/backend) and total cycles.\n"
            "Please refer to the Score-P manual for guidance on configuring PERF counters for \n"
            "stalls measurement in the PERF COUNTERS section.";

        return isActive() ? active_text : not_active_text;
    }

    virtual
    void
    adjustForTest( cube::CubeProxy* cube ) const;

public:
    POPStalledResourcesTest( cube::CubeProxy* );

    virtual
    ~POPStalledResourcesTest()
    {
    };
// ------ overview tests ---------

    bool
    isActive() const;

    bool
    isIssue() const;

    virtual
    inline
    bool
    isRegular() const // returns true, if 0 to 1 indicates improvement, false - otherwise
    {
        return false;
    }
};
};
#endif // POP_stalled_resources_TEST_H
