/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2015-2023                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#include <config.h>

#include "POPStalledResourcesTest.h"


using namespace popcalculation;

POPStalledResourcesTest::POPStalledResourcesTest( cube::CubeProxy* cube ) : PerformanceTest( cube )
{
    setName( "Resource stall cycles" );
    setWeight( 1 );   // need to be adjusted
    pop_stalled_resources = cube->getMetric( "stalled_resources" );
    if ( pop_stalled_resources == nullptr )
    {
        adjustForTest( cube );
    }
    pop_stalled_resources = cube->getMetric( "stalled_resources" );
    if ( pop_stalled_resources == nullptr )
    {
        setWeight( 0.1 );
        setValue( 0. );
        return;
    }

    cube::list_of_sysresources lsysres = getRootsOfSystemTree();
    cube::metric_pair          metric;
    metric.first  = pop_stalled_resources;
    metric.second = cube::CUBE_CALCULATE_INCLUSIVE;
    lmetrics.push_back( metric );
}


void
POPStalledResourcesTest::applyCnode( const cube::list_of_cnodes& lcnodes,
                                     const bool                  direct_calculation  )
{
    ( void )direct_calculation; // not used here
    if ( pop_stalled_resources == nullptr )
    {
        return;
    }

    cube::list_of_sysresources lsysres;
    cube::Value*               v = cube->calculateValue( lmetrics,
                                                         lcnodes,
                                                         lsysres );
    double pop_stalled_resources_value = v->getDouble();
    delete v;
    setValue( pop_stalled_resources_value  );
}



const std::string&
POPStalledResourcesTest::getCommentText() const
{
    return no_comment;
}


// ------ overview tests ---------

bool
POPStalledResourcesTest::isActive() const
{
    return pop_stalled_resources != nullptr;
};

bool
POPStalledResourcesTest::isIssue() const
{
    return false;
};


void
POPStalledResourcesTest::adjustForTest( cube::CubeProxy* cube ) const
{
    add_res_stl_without_wait( cube );
    add_tot_cyc_without_wait( cube );
    add_stalled_resources( cube );
}
