/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2023-2025                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBELIB_POP_NO_WAIT_INS_TEST_H
#define CUBELIB_POP_NO_WAIT_INS_TEST_H

#include <string>
#include "PerformanceTest.h"


namespace popcalculation
{
class POPNoWaitINSTest : public PerformanceTest
{
private:
    cube::Metric* no_wait_ins;
    double        maxValue;

protected:

    void
    applyCnode( const cube::list_of_cnodes& cnodes,
                const bool                  direct_calculation = false   );

    virtual
    const std::string&
    getCommentText() const;

    inline
    virtual
    std::string
    getHelpUrl() const
    {
        std::string active_text =
            "Instruction Efficiency compares the number of useful instructions executed for a \n"
            "reference computation (e.g., single-processor baseline) against the number of \n"
            "instructions required when using additional processes. A decline in this metric \n"
            "indicates that more instructions are needed to solve the same problem, \n"
            "potentially revealing inefficiencies in parallelization.\n";

        std::string not_active_text =
            "The Instruction Efficiency metric requires measurement of total instructions executed.\n"
            "This data must come from either:\n"
            "- PAPI counter PAPI_TOT_INS (total instructions), or\n"
            "- Linux Perf counters for instructions (and optionally cycles).\n"
            "Please consult the Score-P manual, section on PERF counters, for implementation details.";
        return isActive() ? active_text : not_active_text;
    }

    virtual
    void
    adjustForTest( cube::CubeProxy* cube ) const;

public:
    POPNoWaitINSTest( cube::CubeProxy* );

    virtual
    ~POPNoWaitINSTest()
    {
    };
// ------ overview tests ---------

    virtual
    inline
    double
    getMaximum() const
    {
        return maxValue;
    }

    virtual
    inline
    bool
    isPercent() const
    {
        return false;
    }

    bool
    isActive() const;

    bool
    isIssue() const;

    virtual
    inline
    bool
    isNormalized() const // returns true, if range goes from 0 to 1. false -> otherwise
    {
        return false;
    }

    inline
    virtual
    std::string
    units() const
    {
        return "#";
    }
};
};
#endif // POP_ipc_TEST_H
