/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2023-2024                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef POPSERVER_REQUEST_H
#define POPSERVER_REQUEST_H

#include <vector>
#include <utility>
#include <stdint.h>
#include "json.hpp"
using json = nlohmann::json;
namespace popserver_request
{
enum REQUEST_OP { TEST = 0, CALCULATE = 1, NOPS };
enum REQUEST_AC { OK = 0, NOOP = 1, NACS };


/**
 * @brief The POPServerPlugin class  is working on server side plugins. It is called by the
 * corresponding client side plugin POP Advisor .
 */
struct POPServerRequest
{
    int32_t                 pop_analysis;
    REQUEST_OP              operation;
    std::vector< uint64_t > cnodes;
    std::vector< uint64_t > state;
};


void
to_json( json&                   j,
         const POPServerRequest& p );

void
from_json( const json&       j,
           POPServerRequest& p );


struct POPServerAnswer
{
    REQUEST_AC                 analysis_active;
    std::string                analysis_message;
    std::vector< uint64_t >    cnodes;
    std::vector< uint64_t >    state;
    std::vector< std::string > pop_metric_names;
    std::vector< std::string > gpu_metric_names;
    std::vector< std::string > io_metric_names;
    std::vector< std::string > additional_metric_names;
    std::vector< std::string > control_metric_names;
    std::vector< double >      pop_values;
    std::vector< double >      gpu_values;
    std::vector< double >      io_values;
    std::vector< double >      additional_values;
    std::vector< double >      control_values;

    std::string                pop_analysis_help;
    std::vector<std::string>   pop_metrics_helps;
    std::vector<std::string>   gpu_metrics_helps;
    std::vector<std::string>   io_metrics_helps;
    std::vector<std::string>   additional_metrics_helps;
    std::vector<std::string>   control_metrics_helps;
};

void
to_json( json&                  j,
         const POPServerAnswer& p );

void
from_json( const json&      j,
           POPServerAnswer& p );
};

#endif
