/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2024                                                     **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#include "POPServerRequest.h"
using json = nlohmann::json;

void
popserver_request::to_json( json& j, const POPServerRequest& p )
{
    j = json
    {
        { "pop_analysis", p.pop_analysis },
        { "operation", p.operation },
        { "cnodes", p.cnodes },
        { "state", p.state }
    };
}

void
popserver_request::from_json( const json& j, POPServerRequest& p )
{
    j.at( "pop_analysis" ).get_to( p.pop_analysis );
    j.at( "operation" ).get_to( p.operation );
    j.at( "cnodes" ).get_to( p.cnodes );
    j.at( "state" ).get_to( p.state );
}

void
popserver_request::to_json( json& j, const POPServerAnswer& p )
{
    j = json
    {
        { "cnodes", p.cnodes },
        { "state", p.state },
        { "analysis_active", p.analysis_active },
        { "analysis_message", p.analysis_message },
        { "pop_metric_names", p.pop_metric_names },
        { "gpu_metric_names", p.gpu_metric_names },
        { "io_metric_names", p.io_metric_names },
        { "additional_metric_names", p.additional_metric_names },
        { "control_metric_names", p.control_metric_names },
        { "pop_values", p.pop_values },
        { "gpu_values", p.gpu_values },
        { "io_values", p.io_values },
        { "additional_values", p.additional_values },
        { "control_values", p.control_values },
        { "pop_analysis_help", p.pop_analysis_help },
        { "pop_metrics_helps", p.pop_metrics_helps },
        { "gpu_metrics_helps", p.gpu_metrics_helps },
        { "io_metrics_helps", p.io_metrics_helps },
        { "additional_metrics_helps", p.additional_metrics_helps },
        { "control_metrics_helps", p.control_metrics_helps }
    };
}

void
popserver_request::from_json( const json& j, POPServerAnswer& p )
{
    j.at( "cnodes" ).get_to( p.cnodes );
    j.at( "state" ).get_to( p.state );
    j.at( "analysis_active" ).get_to( p.analysis_active );
    j.at( "analysis_message" ).get_to( p.analysis_message );
    j.at( "pop_metric_names" ).get_to( p.pop_metric_names );
    j.at( "gpu_metric_names" ).get_to( p.gpu_metric_names );
    j.at( "io_metric_names" ).get_to( p.io_metric_names );
    j.at( "additional_metric_names" ).get_to( p.additional_metric_names );
    j.at( "control_metric_names" ).get_to( p.control_metric_names );
    j.at( "pop_values" ).get_to( p.pop_values );
    j.at( "gpu_values" ).get_to( p.gpu_values );
    j.at( "io_values" ).get_to( p.io_values );
    j.at( "additional_values" ).get_to( p.additional_values );
    j.at( "control_values" ).get_to( p.control_values );
    j.at( "pop_analysis_help" ).get_to( p.pop_analysis_help );
    j.at( "pop_metrics_helps" ).get_to( p.pop_metrics_helps );
    j.at( "gpu_metrics_helps" ).get_to( p.gpu_metrics_helps );
    j.at( "io_metrics_helps" ).get_to( p.io_metrics_helps );
    j.at( "additional_metrics_helps" ).get_to( p.additional_metrics_helps );
    j.at( "control_metrics_helps" ).get_to( p.control_metrics_helps );
}
