/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2015-2025                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBELIB_BSPOP_HYBRID_OMP_PARALLEL_EFFICIENCY_TEST_H
#define CUBELIB_BSPOP_HYBRID_OMP_PARALLEL_EFFICIENCY_TEST_H

#include <string>
#include "PerformanceTest.h"
#include "BSPOPHybridMPIParallelEfficiencyTest.h"
#include "BSPOPHybridParallelEfficiencyTest.h"

namespace bscanalysis
{
class BSPOPHybridOMPParallelEfficiencyTest : public popcalculation::PerformanceTest
{
private:

    BSPOPHybridParallelEfficiencyTest*    par_eff;
    BSPOPHybridMPIParallelEfficiencyTest* mpi_eff;

    void
    calculate();

    void
    calculate( const cube::list_of_cnodes& );

protected:

    void
    applyCnode( const cube::list_of_cnodes& cnodes,
                const bool                  direct_calculation = false  );


    virtual
    const std::string&
    getCommentText() const;

    inline
    virtual
    std::string
    getHelpUrl() const
    {
        std::string active_text =
            "OpenMP Parallel Efficiency (OMPE) quantifies how effectively OpenMP threads utilize available computational resources.\n"
            "This metric can be calculated directly or through the relationship between hybrid and MPI efficiencies:\n"
            "\tOMPE = average(computation time across all threads) / average( time outside MPI calls)\n"
            "\nAlternative calculation approach:\n"
            "\tOMPE = Hybrid Parallel Efficiency / MPI Parallel Efficiency\n\n"
            "OMPE provides insight into the parallelization performance of OpenMP threads\n"
            "when working in conjunction with MPI processes.";

        std::string not_active_text =
            "For accurate OpenMP Parallel Efficiency analysis, precise timing information is mandatory.\n"
            "This metric is fully supported only in Score-P/Scalasca instrumentation setups.\n"
            "When utilizing Cube Reports from tools other than Score-P/Scalasca,\n"
            "critical timing metrics may be incomplete or absent, particularly the essential Time metric.\n"
            "Such deficiencies render comprehensive POP analysis impossible.";

        return isActive() ? active_text : not_active_text;
    }

    virtual
    void
    adjustForTest( cube::CubeProxy* cube ) const;


public:
    BSPOPHybridOMPParallelEfficiencyTest(  cube::CubeProxy*,
                                           BSPOPHybridParallelEfficiencyTest*,
                                           BSPOPHybridMPIParallelEfficiencyTest* );

    virtual
    ~BSPOPHybridOMPParallelEfficiencyTest()
    {
    };
// ------ overview tests ---------

    bool
    isActive() const;

    bool
    isIssue() const;


    virtual
    std::list<PerformanceTest*>
    getPrereqs()
    {
        std::list<PerformanceTest*> prereqs;
        if ( par_eff != nullptr && mpi_eff != nullptr )
        {
            prereqs.push_back( par_eff );
            prereqs.push_back( mpi_eff );
        }
        return prereqs;
    }
};
};
#endif // ADVISER_RATING_WIDGET_H
