/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2015-2025                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBELIB_BSPOP_HYBRID_MPI_PARALLEL_EFFICIENCY_TEST_H
#define CUBELIB_BSPOP_HYBRID_MPI_PARALLEL_EFFICIENCY_TEST_H

#include <string>
#include "PerformanceTest.h"
#include "BSPOPHybridMPICommunicationEfficiencyTest.h"
#include "BSPOPHybridMPILoadBalanceTest.h"

namespace bscanalysis
{
class BSPOPHybridOMPParallelEfficiencyTest;
class BSPOPHybridMPIParallelEfficiencyTest : public popcalculation::PerformanceTest
{
    friend class BSPOPHybridOMPParallelEfficiencyTest;
private:

    cube::Metric* non_mpi_time;
    cube::Metric* max_runtime;

    cube::list_of_metrics max_runtime_metrics;

    void
    calculate( const cube::list_of_cnodes& );

protected:

    virtual
    const std::string&
    getCommentText() const;

    inline
    virtual
    std::string
    getHelpUrl() const
    {
        std::string active_text =
            "MPI Parallel Efficiency quantifies the effectiveness of parallel execution in MPI applications.\n"
            "It can be calculated either directly or through the combination of two fundamental metrics:\n"
            "\tMPE = average(non-MPI execution time) / maximum(total runtime across processes)\n"
            "\t   = MPI Load Balance Efficiency x MPI Communication Efficiency\n\n"
            "This metric provides insights into scalability and identifies bottlenecks in parallel performance.";

        std::string not_active_text =
            "For accurate MPI Parallel Efficiency analysis, precise timing data is essential.\n"
            "This metric is only fully available when using standard Score-P/Scalasca measurements.\n"
            "Cube Reports generated by alternative tools may lack the necessary Time metric,\n"
            "which would render comprehensive POP analysis impossible.";

        return isActive() ? active_text : not_active_text;
    }

    virtual
    void
    adjustForTest( cube::CubeProxy* cube ) const;


public:
    BSPOPHybridMPIParallelEfficiencyTest(   cube::CubeProxy*  );

    virtual
    ~BSPOPHybridMPIParallelEfficiencyTest()
    {
    };
// ------ overview tests ---------

    void
    applyCnode( const cube::list_of_cnodes& cnodes,
                const bool                  direct_calculation = false  );


    bool
    isActive() const;

    bool
    isIssue() const;
};
};
#endif // ADVISER_RATING_WIDGET_H
