/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2015-2025                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBELIB_BSPOP_HYBRID_MPI_LOAD_BALANCE_TEST_H
#define CUBELIB_BSPOP_HYBRID_MPI_LOAD_BALANCE_TEST_H

#include <string>
#include "PerformanceTest.h"
#include "BSPOPHybridMPICommunicationEfficiencyTest.h"


namespace bscanalysis
{
class BSPOPHybridOMPLoadBalanceEfficiencyTest;
class BSPOPHybridMPILoadBalanceTest : public popcalculation::PerformanceTest
{
    friend class BSPOPHybridOMPLoadBalanceEfficiencyTest;
private:

    cube::Metric* non_mpi_time;
    cube::Metric* max_non_mpi_time;

    cube::list_of_metrics                      max_non_mpi_metrics;
    BSPOPHybridMPICommunicationEfficiencyTest* mpi_comm_eff;



protected:


    virtual
    const std::string&
    getCommentText() const;

    inline
    virtual
    std::string
    getHelpUrl() const
    {
        std::string active_text =
            "MPI Load Balance Efficiency evaluates the balance of computational workload across processes.\n"
            "It uses the following formula:\n"
            "\tMPI Load Balance Efficiency = average(time outside MPI) / maximum(time outside MPI across processes)\n\n"
            "A value close to 1.0 indicates excellent load balance, while values significantly below 1.0\n"
            "suggest uneven workload distribution.";

        std::string not_active_text =
            "The MPI Load Balance Efficiency metric depends on complete timing information from Score-P/Scalasca.\n"
            "When Cube Reports are generated by tools other than Score-P/Scalasca,\n"
            "they may lack the detailed Time metric required for accurate POP analysis.\n"
            "In such cases, proper POP efficiency assessment is not possible.";

        return isActive() ? active_text : not_active_text;
    }

    virtual
    void
    adjustForTest( cube::CubeProxy* cube ) const;

public:
    BSPOPHybridMPILoadBalanceTest( cube::CubeProxy*,
                                   BSPOPHybridMPICommunicationEfficiencyTest* );

    virtual
    ~BSPOPHybridMPILoadBalanceTest()
    {
    };

    virtual
    double
    analyze( const cube::list_of_cnodes& cnodes,
             cube::LocationGroup*        _lg = nullptr ) const;




// ------ overview tests ---------

    void
    applyCnode( const cube::list_of_cnodes& cnodes,
                const bool                  direct_calculation = false );



    bool
    isActive() const;

    bool
    isIssue() const;

    virtual
    std::list<PerformanceTest*>
    getPrereqs()
    {
        std::list<PerformanceTest*> prereqs;
        if ( mpi_comm_eff != nullptr )
        {
            prereqs.push_back( mpi_comm_eff );
        }
        return prereqs;
    }
};
};
#endif // BSPOPHybrid_IMBALANCE_TEST_H
