/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2015-2025                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBELIB_BSPOP_HYBRID_MPI_COMMUNICATION_EFFICIENCY_TEST_H
#define CUBELIB_BSPOP_HYBRID_MPI_COMMUNICATION_EFFICIENCY_TEST_H

#include <string>
#include "PerformanceTest.h"

namespace bscanalysis
{
class BSPOPHybridOMPCommunicationEfficiencyTest;
class BSPOPHybridMPICommunicationEfficiencyTest : public popcalculation::PerformanceTest
{
    friend class BSPOPHybridOMPCommunicationEfficiencyTest;
private:

    cube::Metric* max_runtime;
    cube::Metric* max_non_mpi_time;

    cube::list_of_metrics max_non_mpi_metrics;

    void
    calculate();

    void
    calculate( const cube::list_of_cnodes& );

protected:


    virtual
    const std::string&
    getCommentText() const;

    inline
    virtual
    std::string
    getHelpUrl() const
    {
        std::string active_text =
            "MPI Communication Efficiency measures the portion of runtime spent in productive work rather than communication.\n"
            "It is calculated as:\n"
            "\tMPI Communication Efficiency = (time spent outside MPI) / (total runtime)\n\n"
            "This metric highlights inefficiencies when significant runtime is consumed by MPI operations\n"
            "instead of useful computational work across all processes.";

        std::string not_active_text =
            "MPI Communication Efficiency requires precise timing data from Score-P/Scalasca measurements.\n"
            "When a Cube Report is generated using tools other than Score-P/Scalasca,\n"
            "the essential 'Time' metric may be incomplete, making POP analysis unfeasible.";

        return isActive() ? active_text : not_active_text;
    }

    virtual
    void
    adjustForTest( cube::CubeProxy* cube ) const;


public:
    BSPOPHybridMPICommunicationEfficiencyTest(      cube::CubeProxy* );

    virtual
    ~BSPOPHybridMPICommunicationEfficiencyTest()
    {
    };
// ------ overview tests ---------

    void
    applyCnode( const cube::list_of_cnodes& cnodes,
                const bool                  direct_calculation = false  );


    bool
    isActive() const;

    bool
    isIssue() const;
};
};
#endif // ADVISER_RATING_WIDGET_H
