/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2015-2025                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBELIB_BSPOP_HYBRID_LOAD_BALANCE_TEST_H
#define CUBELIB_BSPOP_HYBRID_LOAD_BALANCE_TEST_H

#include <string>
#include "PerformanceTest.h"
#include "BSPOPHybridCommunicationEfficiencyTest.h"


namespace bscanalysis
{
class BSPOPHybridOMPLoadBalanceEfficiencyTest;
class BSPOPHybridLoadBalanceTest : public popcalculation::PerformanceTest
{
    friend class BSPOPHybridOMPLoadBalanceEfficiencyTest;
private:
    cube::Metric* pop_avg_comp;
    cube::Metric* max_comp;

    cube::list_of_metrics max_comp_metrics;

    BSPOPHybridCommunicationEfficiencyTest* hyb_comm_eff;
protected:

    virtual
    const std::string&
    getCommentText() const;

    inline
    virtual
    std::string
    getHelpUrl() const
    {
        std::string active_text =
            "Hybrid Load Balance Efficiency is defined as:\n"
            "\tHybrid Load Balance Efficiency = computation time / maximum computation time across processes\n\n"
            "This metric assesses how evenly computational workload is distributed across all processes.";

        std::string not_active_text =
            "The Hybrid Load Balance Efficiency metric requires complete Score-P/Scalasca measurement data.\n"
            "If the Cube Report originates from a tool other than Score-P/Scalasca,\n"
            "the necessary 'Time' metric may be missing, preventing POP analysis from being performed.";

        return isActive() ? active_text : not_active_text;
    }

    virtual
    void
    adjustForTest( cube::CubeProxy* cube ) const;

    void
    add_avg_comp( cube::CubeProxy* ) const;


public:
    BSPOPHybridLoadBalanceTest( cube::CubeProxy*,
                                BSPOPHybridCommunicationEfficiencyTest* _hyb_comm_eff );

    virtual
    ~BSPOPHybridLoadBalanceTest()
    {
    };
// ------ overview tests ---------

    void
    applyCnode( const cube::list_of_cnodes& cnodes,
                const bool                  direct_calculation = false   );


    bool
    isActive() const;

    bool
    isIssue() const;


    virtual
    std::list<PerformanceTest*>
    getPrereqs()
    {
        std::list<PerformanceTest*> prereqs;
        if ( hyb_comm_eff != nullptr )
        {
            prereqs.push_back( hyb_comm_eff );
        }
        return prereqs;
    }
};
};
#endif // BSPOPHybrid_IMBALANCE_TEST_H
