/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2015-2025                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBELIB_BSPOP_HYBRID_COMMUNICATION_EFFICENCY_TEST_H
#define CUBELIB_BSPOP_HYBRID_COMMUNICATION_EFFICENCY_TEST_H

#include <string>
#include "PerformanceTest.h"

namespace bscanalysis
{
class BSPOPHybridOMPCommunicationEfficiencyTest;
class BSPOPHybridCommunicationEfficiencyTest : public popcalculation::PerformanceTest
{
    friend class BSPOPHybridOMPCommunicationEfficiencyTest;
private:

    cube::Metric* max_runtime;
    cube::Metric* max_comp;

    cube::list_of_metrics max_comp_metrics;
protected:

    const std::string&
    getCommentText() const;

    inline
    virtual
    std::string
    getHelpUrl() const
    {
        std::string active_text =
            "Hybrid Communication Efficiency quantifies the proportion of time spent in useful computation versus communication.\n"
            "It is calculated using the formula:\n"
            "\tHybrid Communication Efficiency = max(computation time) / max(total runtime)\n\n"
            "A low efficiency value indicates that the application spends excessive time\n"
            "handling communication rather than performing meaningful computations.";

        std::string not_active_text =
            "The Hybrid Load Balance Efficiency metric is a fundamental POP metric\n"
            "and is available in all Score-P/Scalasca measurement results.\n\n"
            "If a Cube Report was generated without Score-P/Scalasca (e.g., by a third-party tool),\n"
            "it may lack the 'Time' metric, making POP analysis unavailable.";

        return isActive() ? active_text : not_active_text;
    }

    virtual
    void
    adjustForTest( cube::CubeProxy* cube ) const;


public:
    BSPOPHybridCommunicationEfficiencyTest(
        cube::CubeProxy* );

    virtual
    ~BSPOPHybridCommunicationEfficiencyTest()
    {
    };

    virtual
    double
    analyze( const cube::list_of_cnodes& cnodes,
             cube::LocationGroup*        _lg = nullptr ) const;

// ------ overview tests ---------

    void
    applyCnode( const cube::list_of_cnodes& cnodes,
                const bool                  direct_calculation = false  );


    bool
    isActive() const;

    bool
    isIssue() const;
};
};
#endif // ADVISER_RATING_WIDGET_H
