/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2025                                                     **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/



#include "config.h"

#include "CubeSysresGetEvaluation.h"
#include "CubeServices.h"
using namespace cube;
using namespace std;

SysresGetEvaluation::SysresGetEvaluation( cube::Cube*        _cube,
                                          GeneralEvaluation* _id,
                                          GeneralEvaluation* _val_get,
                                          GeneralEvaluation* _val_id )
{
    cube = _cube;
    arguments.push_back( _id );
    arguments.push_back( _val_get );
    arguments.push_back( _val_id );
};

SysresGetEvaluation::~SysresGetEvaluation()
{
};

string
SysresGetEvaluation::strEval() const
{
    if ( arguments.size() == 3 )
    {
        StringEvaluation* _id   = dynamic_cast<StringEvaluation*>( arguments[ 0 ] );
        StringEvaluation* _val  = dynamic_cast<StringEvaluation*>( arguments[ 1 ] );
        StringEvaluation* _attr = dynamic_cast<StringEvaluation*>( arguments[ 2 ] );

        size_t id = static_cast<size_t>( _id->eval() );
        if ( id <  cube->get_sysv().size() )
        {
            cube::Sysres* _sysres = cube->get_sysv()[ id ];
            std::string   _str    = _val->strEval();
            if ( _str == "attribute" )
            {
                std::string _attr_key = _attr->strEval();
                return _sysres->get_attr( _attr_key );
            }
        }
    }
    return "";
}
