/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2025                                                     **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/



#include "config.h"

#include "CubeRegionGetEvaluation.h"
#include "CubeServices.h"
using namespace cube;
using namespace std;


RegionGetEvaluation::RegionGetEvaluation( cube::Cube*        _cube,
                                          GeneralEvaluation* _id,
                                          GeneralEvaluation* _val_get,
                                          GeneralEvaluation* _val_id )
{
    cube = _cube;
    arguments.push_back( _id );
    arguments.push_back( _val_get );
    arguments.push_back( _val_id );
};

RegionGetEvaluation::~RegionGetEvaluation()
{
};

string
RegionGetEvaluation::strEval() const
{
    if ( arguments.size() == 3 )
    {
        StringEvaluation* _id   = dynamic_cast<StringEvaluation*>( arguments[ 0 ] );
        StringEvaluation* _val  = dynamic_cast<StringEvaluation*>( arguments[ 1 ] );
        StringEvaluation* _attr = dynamic_cast<StringEvaluation*>( arguments[ 2 ] );

        size_t id = static_cast<size_t>( _id->eval() );
        if ( id <  cube->get_regv().size() )
        {
            cube::Region* _region = cube->get_regv()[ id ];
            std::string   _str    = _val->strEval();
            if ( _str == "attribute" )
            {
                std::string _attr_key = _attr->strEval();
                return _region->get_attr( _attr_key );
            }
        }
    }
    return "";
}
