// A Bison parser, made by GNU Bison 3.7.4.

// Skeleton implementation for Bison LALR(1) parsers in C++

// Copyright (C) 2002-2015, 2018-2020 Free Software Foundation, Inc.

// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

// As a special exception, you may create a larger work that contains
// part or all of the Bison parser skeleton and distribute that work
// under terms of your choice, so long as that work isn't itself a
// parser generator using the skeleton or a modified version thereof
// as a parser skeleton.  Alternatively, if you modify or redistribute
// the parser skeleton itself, you may (at your option) remove this
// special exception, which will cause the skeleton and the resulting
// Bison output files to be licensed under the GNU General Public
// License without this special exception.

// This special exception was added by the Free Software Foundation in
// version 2.2 of Bison.

// DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
// especially those whose name start with YY_ or yy_.  They are
// private implementation details that can be changed or removed.


// Take the name prefix into account.
#define yylex   cubeplparserlex



#include "CubePL1Parser.h"

// Second part of user prologue.
#line 287 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"

#include "CubeTypes.h"
#include "CubeSysres.h"
#include "CubeLocation.h"
#include "CubeLocationGroup.h"
#include "CubeSystemTreeNode.h"
#include "CubePL1Scanner.h"
#include <cassert>
#include <cstdlib>
#include <cstring>
#include <stdlib.h>

using namespace std;
using namespace cube;

#include <cmath>
#include <cstdio>
#include <cstdlib>
#include <utility>
#include <string>
#include <vector>
#include "CubePL1ParseContext.h"

/* this "connects" the bison parser in the driver to the flex scanner class
 * object. it defines the yylex() function call to pull the next token from the
 * current lexer object of the driver context. */
#undef yylex
#define yylex CubePL1Lexer.lex

// Workaround for Sun Studio C++ compilers on Solaris
#if defined(__SVR4) &&  defined(__SUNPRO_CC)
  #include <ieeefp.h>

  #define isinf(x)  (fpclass(x) == FP_NINF || fpclass(x) == FP_PINF)
  #define isnan(x)  isnand(x)
#endif


#line 86 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"



#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> // FIXME: INFRINGES ON USER NAME SPACE.
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif


// Whether we are compiled with exception support.
#ifndef YY_EXCEPTIONS
# if defined __GNUC__ && !defined __EXCEPTIONS
#  define YY_EXCEPTIONS 0
# else
#  define YY_EXCEPTIONS 1
# endif
#endif

#define YYRHSLOC(Rhs, K) ((Rhs)[K].location)
/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

# ifndef YYLLOC_DEFAULT
#  define YYLLOC_DEFAULT(Current, Rhs, N)                               \
    do                                                                  \
      if (N)                                                            \
        {                                                               \
          (Current).begin  = YYRHSLOC (Rhs, 1).begin;                   \
          (Current).end    = YYRHSLOC (Rhs, N).end;                     \
        }                                                               \
      else                                                              \
        {                                                               \
          (Current).begin = (Current).end = YYRHSLOC (Rhs, 0).end;      \
        }                                                               \
    while (false)
# endif


// Enable debugging if requested.
#if CUBEPLPARSERDEBUG

// A pseudo ostream that takes yydebug_ into account.
# define YYCDEBUG if (yydebug_) (*yycdebug_)

# define YY_SYMBOL_PRINT(Title, Symbol)         \
  do {                                          \
    if (yydebug_)                               \
    {                                           \
      *yycdebug_ << Title << ' ';               \
      yy_print_ (*yycdebug_, Symbol);           \
      *yycdebug_ << '\n';                       \
    }                                           \
  } while (false)

# define YY_REDUCE_PRINT(Rule)          \
  do {                                  \
    if (yydebug_)                       \
      yy_reduce_print_ (Rule);          \
  } while (false)

# define YY_STACK_PRINT()               \
  do {                                  \
    if (yydebug_)                       \
      yy_stack_print_ ();                \
  } while (false)

#else // !CUBEPLPARSERDEBUG

# define YYCDEBUG if (false) std::cerr
# define YY_SYMBOL_PRINT(Title, Symbol)  YYUSE (Symbol)
# define YY_REDUCE_PRINT(Rule)           static_cast<void> (0)
# define YY_STACK_PRINT()                static_cast<void> (0)

#endif // !CUBEPLPARSERDEBUG

#define yyerrok         (yyerrstatus_ = 0)
#define yyclearin       (yyla.clear ())

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYRECOVERING()  (!!yyerrstatus_)

namespace cubeplparser {
#line 179 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"

  /// Build a parser object.
  CubePL1Parser::CubePL1Parser (class CubePL1ParseContext& parseContext_yyarg, class CubePL1Scanner& CubePL1Lexer_yyarg)
#if CUBEPLPARSERDEBUG
    : yydebug_ (false),
      yycdebug_ (&std::cerr),
#else
    :
#endif
      parseContext (parseContext_yyarg),
      CubePL1Lexer (CubePL1Lexer_yyarg)
  {}

  CubePL1Parser::~CubePL1Parser ()
  {}

  CubePL1Parser::syntax_error::~syntax_error () YY_NOEXCEPT YY_NOTHROW
  {}

  /*---------------.
  | symbol kinds.  |
  `---------------*/

  // basic_symbol.
  template <typename Base>
  CubePL1Parser::basic_symbol<Base>::basic_symbol (const basic_symbol& that)
    : Base (that)
    , value (that.value)
    , location (that.location)
  {}


  /// Constructor for valueless symbols.
  template <typename Base>
  CubePL1Parser::basic_symbol<Base>::basic_symbol (typename Base::kind_type t, YY_MOVE_REF (location_type) l)
    : Base (t)
    , value ()
    , location (l)
  {}

  template <typename Base>
  CubePL1Parser::basic_symbol<Base>::basic_symbol (typename Base::kind_type t, YY_RVREF (semantic_type) v, YY_RVREF (location_type) l)
    : Base (t)
    , value (YY_MOVE (v))
    , location (YY_MOVE (l))
  {}

  template <typename Base>
  CubePL1Parser::symbol_kind_type
  CubePL1Parser::basic_symbol<Base>::type_get () const YY_NOEXCEPT
  {
    return this->kind ();
  }

  template <typename Base>
  bool
  CubePL1Parser::basic_symbol<Base>::empty () const YY_NOEXCEPT
  {
    return this->kind () == symbol_kind::S_YYEMPTY;
  }

  template <typename Base>
  void
  CubePL1Parser::basic_symbol<Base>::move (basic_symbol& s)
  {
    super_type::move (s);
    value = YY_MOVE (s.value);
    location = YY_MOVE (s.location);
  }

  // by_kind.
  CubePL1Parser::by_kind::by_kind ()
    : kind_ (symbol_kind::S_YYEMPTY)
  {}

#if 201103L <= YY_CPLUSPLUS
  CubePL1Parser::by_kind::by_kind (by_kind&& that)
    : kind_ (that.kind_)
  {
    that.clear ();
  }
#endif

  CubePL1Parser::by_kind::by_kind (const by_kind& that)
    : kind_ (that.kind_)
  {}

  CubePL1Parser::by_kind::by_kind (token_kind_type t)
    : kind_ (yytranslate_ (t))
  {}

  void
  CubePL1Parser::by_kind::clear ()
  {
    kind_ = symbol_kind::S_YYEMPTY;
  }

  void
  CubePL1Parser::by_kind::move (by_kind& that)
  {
    kind_ = that.kind_;
    that.clear ();
  }

  CubePL1Parser::symbol_kind_type
  CubePL1Parser::by_kind::kind () const YY_NOEXCEPT
  {
    return kind_;
  }

  CubePL1Parser::symbol_kind_type
  CubePL1Parser::by_kind::type_get () const YY_NOEXCEPT
  {
    return this->kind ();
  }


  // by_state.
  CubePL1Parser::by_state::by_state () YY_NOEXCEPT
    : state (empty_state)
  {}

  CubePL1Parser::by_state::by_state (const by_state& that) YY_NOEXCEPT
    : state (that.state)
  {}

  void
  CubePL1Parser::by_state::clear () YY_NOEXCEPT
  {
    state = empty_state;
  }

  void
  CubePL1Parser::by_state::move (by_state& that)
  {
    state = that.state;
    that.clear ();
  }

  CubePL1Parser::by_state::by_state (state_type s) YY_NOEXCEPT
    : state (s)
  {}

  CubePL1Parser::symbol_kind_type
  CubePL1Parser::by_state::kind () const YY_NOEXCEPT
  {
    if (state == empty_state)
      return symbol_kind::S_YYEMPTY;
    else
      return YY_CAST (symbol_kind_type, yystos_[+state]);
  }

  CubePL1Parser::stack_symbol_type::stack_symbol_type ()
  {}

  CubePL1Parser::stack_symbol_type::stack_symbol_type (YY_RVREF (stack_symbol_type) that)
    : super_type (YY_MOVE (that.state), YY_MOVE (that.value), YY_MOVE (that.location))
  {
#if 201103L <= YY_CPLUSPLUS
    // that is emptied.
    that.state = empty_state;
#endif
  }

  CubePL1Parser::stack_symbol_type::stack_symbol_type (state_type s, YY_MOVE_REF (symbol_type) that)
    : super_type (s, YY_MOVE (that.value), YY_MOVE (that.location))
  {
    // that is emptied.
    that.kind_ = symbol_kind::S_YYEMPTY;
  }

#if YY_CPLUSPLUS < 201103L
  CubePL1Parser::stack_symbol_type&
  CubePL1Parser::stack_symbol_type::operator= (const stack_symbol_type& that)
  {
    state = that.state;
    value = that.value;
    location = that.location;
    return *this;
  }

  CubePL1Parser::stack_symbol_type&
  CubePL1Parser::stack_symbol_type::operator= (stack_symbol_type& that)
  {
    state = that.state;
    value = that.value;
    location = that.location;
    // that is emptied.
    that.state = empty_state;
    return *this;
  }
#endif

  template <typename Base>
  void
  CubePL1Parser::yy_destroy_ (const char* yymsg, basic_symbol<Base>& yysym) const
  {
    if (yymsg)
      YY_SYMBOL_PRINT (yymsg, yysym);

    // User destructor.
    YYUSE (yysym.kind ());
  }

#if CUBEPLPARSERDEBUG
  template <typename Base>
  void
  CubePL1Parser::yy_print_ (std::ostream& yyo, const basic_symbol<Base>& yysym) const
  {
    std::ostream& yyoutput = yyo;
    YYUSE (yyoutput);
    if (yysym.empty ())
      yyo << "empty symbol";
    else
      {
        symbol_kind_type yykind = yysym.kind ();
        yyo << (yykind < YYNTOKENS ? "token" : "nterm")
            << ' ' << yysym.name () << " ("
            << yysym.location << ": ";
        YYUSE (yykind);
        yyo << ')';
      }
  }
#endif

  void
  CubePL1Parser::yypush_ (const char* m, YY_MOVE_REF (stack_symbol_type) sym)
  {
    if (m)
      YY_SYMBOL_PRINT (m, sym);
    yystack_.push (YY_MOVE (sym));
  }

  void
  CubePL1Parser::yypush_ (const char* m, state_type s, YY_MOVE_REF (symbol_type) sym)
  {
#if 201103L <= YY_CPLUSPLUS
    yypush_ (m, stack_symbol_type (s, std::move (sym)));
#else
    stack_symbol_type ss (s, sym);
    yypush_ (m, ss);
#endif
  }

  void
  CubePL1Parser::yypop_ (int n)
  {
    yystack_.pop (n);
  }

#if CUBEPLPARSERDEBUG
  std::ostream&
  CubePL1Parser::debug_stream () const
  {
    return *yycdebug_;
  }

  void
  CubePL1Parser::set_debug_stream (std::ostream& o)
  {
    yycdebug_ = &o;
  }


  CubePL1Parser::debug_level_type
  CubePL1Parser::debug_level () const
  {
    return yydebug_;
  }

  void
  CubePL1Parser::set_debug_level (debug_level_type l)
  {
    yydebug_ = l;
  }
#endif // CUBEPLPARSERDEBUG

  CubePL1Parser::state_type
  CubePL1Parser::yy_lr_goto_state_ (state_type yystate, int yysym)
  {
    int yyr = yypgoto_[yysym - YYNTOKENS] + yystate;
    if (0 <= yyr && yyr <= yylast_ && yycheck_[yyr] == yystate)
      return yytable_[yyr];
    else
      return yydefgoto_[yysym - YYNTOKENS];
  }

  bool
  CubePL1Parser::yy_pact_value_is_default_ (int yyvalue)
  {
    return yyvalue == yypact_ninf_;
  }

  bool
  CubePL1Parser::yy_table_value_is_error_ (int yyvalue)
  {
    return yyvalue == yytable_ninf_;
  }

  int
  CubePL1Parser::operator() ()
  {
    return parse ();
  }

  int
  CubePL1Parser::parse ()
  {
    int yyn;
    /// Length of the RHS of the rule being reduced.
    int yylen = 0;

    // Error handling.
    int yynerrs_ = 0;
    int yyerrstatus_ = 0;

    /// The lookahead symbol.
    symbol_type yyla;

    /// The locations where the error started and ended.
    stack_symbol_type yyerror_range[3];

    /// The return value of parse ().
    int yyresult;

#if YY_EXCEPTIONS
    try
#endif // YY_EXCEPTIONS
      {
    YYCDEBUG << "Starting parse\n";


    // User initialization code.
#line 155 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
{
    // initialize the initial location object
}

#line 518 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"


    /* Initialize the stack.  The initial state will be set in
       yynewstate, since the latter expects the semantical and the
       location values to have been already stored, initialize these
       stacks with a primary value.  */
    yystack_.clear ();
    yypush_ (YY_NULLPTR, 0, YY_MOVE (yyla));

  /*-----------------------------------------------.
  | yynewstate -- push a new symbol on the stack.  |
  `-----------------------------------------------*/
  yynewstate:
    YYCDEBUG << "Entering state " << int (yystack_[0].state) << '\n';
    YY_STACK_PRINT ();

    // Accept?
    if (yystack_[0].state == yyfinal_)
      YYACCEPT;

    goto yybackup;


  /*-----------.
  | yybackup.  |
  `-----------*/
  yybackup:
    // Try to take a decision without lookahead.
    yyn = yypact_[+yystack_[0].state];
    if (yy_pact_value_is_default_ (yyn))
      goto yydefault;

    // Read a lookahead token.
    if (yyla.empty ())
      {
        YYCDEBUG << "Reading a token\n";
#if YY_EXCEPTIONS
        try
#endif // YY_EXCEPTIONS
          {
            yyla.kind_ = yytranslate_ (yylex (&yyla.value, &yyla.location));
          }
#if YY_EXCEPTIONS
        catch (const syntax_error& yyexc)
          {
            YYCDEBUG << "Caught exception: " << yyexc.what() << '\n';
            error (yyexc);
            goto yyerrlab1;
          }
#endif // YY_EXCEPTIONS
      }
    YY_SYMBOL_PRINT ("Next token is", yyla);

    if (yyla.kind () == symbol_kind::S_YYerror)
    {
      // The scanner already issued an error message, process directly
      // to error recovery.  But do not keep the error token as
      // lookahead, it is too special and may lead us to an endless
      // loop in error recovery. */
      yyla.kind_ = symbol_kind::S_YYUNDEF;
      goto yyerrlab1;
    }

    /* If the proper action on seeing token YYLA.TYPE is to reduce or
       to detect an error, take that action.  */
    yyn += yyla.kind ();
    if (yyn < 0 || yylast_ < yyn || yycheck_[yyn] != yyla.kind ())
      {
        goto yydefault;
      }

    // Reduce or error.
    yyn = yytable_[yyn];
    if (yyn <= 0)
      {
        if (yy_table_value_is_error_ (yyn))
          goto yyerrlab;
        yyn = -yyn;
        goto yyreduce;
      }

    // Count tokens shifted since error; after three, turn off error status.
    if (yyerrstatus_)
      --yyerrstatus_;

    // Shift the lookahead token.
    yypush_ ("Shifting", state_type (yyn), YY_MOVE (yyla));
    goto yynewstate;


  /*-----------------------------------------------------------.
  | yydefault -- do the default action for the current state.  |
  `-----------------------------------------------------------*/
  yydefault:
    yyn = yydefact_[+yystack_[0].state];
    if (yyn == 0)
      goto yyerrlab;
    goto yyreduce;


  /*-----------------------------.
  | yyreduce -- do a reduction.  |
  `-----------------------------*/
  yyreduce:
    yylen = yyr2_[yyn];
    {
      stack_symbol_type yylhs;
      yylhs.state = yy_lr_goto_state_ (yystack_[yylen].state, yyr1_[yyn]);
      /* If YYLEN is nonzero, implement the default value of the
         action: '$$ = $1'.  Otherwise, use the top of the stack.

         Otherwise, the following line sets YYLHS.VALUE to garbage.
         This behavior is undocumented and Bison users should not rely
         upon it.  */
      if (yylen)
        yylhs.value = yystack_[yylen - 1].value;
      else
        yylhs.value = yystack_[0].value;

      // Default location.
      {
        stack_type::slice range (yystack_, yylen);
        YYLLOC_DEFAULT (yylhs.location, range, yylen);
        yyerror_range[1].location = yylhs.location;
      }

      // Perform the reduction.
      YY_REDUCE_PRINT (yyn);
#if YY_EXCEPTIONS
      try
#endif // YY_EXCEPTIONS
        {
          switch (yyn)
            {
  case 2: // document: "<cubepl>" expression "</cubepl>"
#line 336 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
        {
            if (!parseContext.test_modus)
            {
                parseContext.result = parseContext._stack.top();
                parseContext._stack.pop();
                }
                parseContext.syntax_ok &= true;
        }
#line 663 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 3: // document: "<cubepl>" "</cubepl>"
#line 345 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
        {
                parseContext.syntax_ok &= true;
        }
#line 671 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 27: // enclosed_expression: "(" expression ")"
#line 378 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
            {
                if (!parseContext.test_modus)
                {
                    GeneralEvaluation * _arg1 = parseContext._stack.top();
                    parseContext._stack.pop();
                    parseContext._stack.push( new EncapsulationEvaluation(_arg1) );
                }
                parseContext.syntax_ok &= true;
            }
#line 685 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 28: // absolute_value: "|" expression "|"
#line 388 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
            {
                if (!parseContext.test_modus)
                {
                    GeneralEvaluation * _arg1 = parseContext._stack.top();
                    parseContext._stack.pop();
                    GeneralEvaluation * _abs = new AbsEvaluation();
                    _abs->addArgument(_arg1);
                    parseContext._stack.push( _abs );
                }
                parseContext.syntax_ok &= true;
            }
#line 701 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 29: // sum: expression "+" expression
#line 401 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
            {
                if (!parseContext.test_modus)
                {
                    GeneralEvaluation * _arg1 = parseContext._stack.top();
                    parseContext._stack.pop();
                    GeneralEvaluation * _arg2 = parseContext._stack.top();
                    parseContext._stack.pop();
                    parseContext._stack.push( new PlusEvaluation(_arg1, _arg2) );
                }
                parseContext.syntax_ok &= true;
            }
#line 717 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 30: // subtract: expression "-" expression
#line 414 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
            {
                if (!parseContext.test_modus)
                {
                    GeneralEvaluation * _arg2 = parseContext._stack.top();
                    parseContext._stack.pop();
                    GeneralEvaluation * _arg1 = parseContext._stack.top();
                    parseContext._stack.pop();
                    parseContext._stack.push( new MinusEvaluation(_arg1, _arg2) );
                }
                parseContext.syntax_ok &= true;
            }
#line 733 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 31: // division: expression "/" expression
#line 428 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
            {
                if (!parseContext.test_modus)
                {
                    GeneralEvaluation * _arg2 = parseContext._stack.top();
                    parseContext._stack.pop();
                    GeneralEvaluation * _arg1 = parseContext._stack.top();
                    parseContext._stack.pop();
                    parseContext._stack.push( new DivideEvaluation(_arg1, _arg2) );
                }
                parseContext.syntax_ok &= true;
            }
#line 749 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 32: // multiplication: expression "*" expression
#line 441 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
            {
                if (!parseContext.test_modus)
                {
                    GeneralEvaluation * _arg1 = parseContext._stack.top();
                    parseContext._stack.pop();
                    GeneralEvaluation * _arg2 = parseContext._stack.top();
                    parseContext._stack.pop();
                    parseContext._stack.push( new MultEvaluation(_arg1, _arg2) );
                }
                parseContext.syntax_ok &= true;
            }
#line 765 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 33: // power: expression "^" expression
#line 457 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
            {
                if (!parseContext.test_modus)
                {
                    GeneralEvaluation * power = parseContext._stack.top();
                    parseContext._stack.pop();
                    GeneralEvaluation * base = parseContext._stack.top();
                    parseContext._stack.pop();
                    parseContext._stack.push( new PowerEvaluation(base, power) );
                }
                parseContext.syntax_ok &= true;
            }
#line 781 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 34: // negation: "-" expression
#line 469 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
            {
                if (!parseContext.test_modus)
                {
                    GeneralEvaluation * arg = parseContext._stack.top();
                    parseContext._stack.pop();
                    parseContext._stack.push( new NegativeEvaluation(arg) );
                }
                parseContext.syntax_ok &= true;
            }
#line 795 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 37: // argument1: "arg1"
#line 483 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
            {
                if (!parseContext.test_modus)
                {
                        parseContext._stack.push(new ArgumentEvaluation(cube::FIRST_ARGUMENT) );
                }
                parseContext.syntax_ok &= true;
            }
#line 807 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 38: // argument2: "arg2"
#line 492 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
            {
                if (!parseContext.test_modus)
                {
                        parseContext._stack.push(new ArgumentEvaluation(cube::SECOND_ARGUMENT) );
                }
                parseContext.syntax_ok &= true;
            }
#line 819 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 52: // enclosed_boolean_expression: "(" boolean_expression ")"
#line 520 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
                    {
                        if (!parseContext.test_modus)
                        {
                            GeneralEvaluation * _arg1 = parseContext._stack.top();
                            parseContext._stack.pop();
                            parseContext._stack.push( new EncapsulationEvaluation(_arg1) );
                        }
                        parseContext.syntax_ok &= true;
                    }
#line 833 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 53: // enclosed_boolean_expression: "not" "(" boolean_expression ")"
#line 530 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
                    {
                        if (!parseContext.test_modus)
                        {
                            GeneralEvaluation * _arg1 = parseContext._stack.top();
                            parseContext._stack.pop();
                            parseContext._stack.push( new NotEvaluation(_arg1) );
                        }
                        parseContext.syntax_ok &= true;
                    }
#line 847 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 54: // and_expression: boolean_expression "and" boolean_expression
#line 541 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
            {
                if (!parseContext.test_modus)
                {
                    GeneralEvaluation * _arg2 = parseContext._stack.top();
                    parseContext._stack.pop();
                    GeneralEvaluation * _arg1 = parseContext._stack.top();
                    parseContext._stack.pop();
                    parseContext._stack.push( new AndEvaluation(_arg1, _arg2) );

                }
                parseContext.syntax_ok &= true;
            }
#line 864 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 55: // or_expression: boolean_expression "or" boolean_expression
#line 554 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
            {
                if (!parseContext.test_modus)
                {
                    GeneralEvaluation * _arg2 = parseContext._stack.top();
                    parseContext._stack.pop();
                    GeneralEvaluation * _arg1 = parseContext._stack.top();
                    parseContext._stack.pop();
                    parseContext._stack.push( new OrEvaluation(_arg1, _arg2) );

                }
                parseContext.syntax_ok &= true;
            }
#line 881 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 56: // xor_expression: boolean_expression "xor" boolean_expression
#line 568 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
            {
                if (!parseContext.test_modus)
                {
                    GeneralEvaluation * _arg2 = parseContext._stack.top();
                    parseContext._stack.pop();
                    GeneralEvaluation * _arg1 = parseContext._stack.top();
                    parseContext._stack.pop();
                    parseContext._stack.push( new XorEvaluation(_arg1, _arg2) );

                }
                parseContext.syntax_ok &= true;
            }
#line 898 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 57: // true_expression: "true"
#line 581 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
            {
                if (!parseContext.test_modus)
                {
                    parseContext._stack.push( new ConstantEvaluation(1) );
                }
                parseContext.syntax_ok &= true;
            }
#line 910 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 58: // false_expression: "false"
#line 589 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
            {
                if (!parseContext.test_modus)
                {
                    parseContext._stack.push( new ConstantEvaluation(0) );
                }
                parseContext.syntax_ok &= true;
            }
#line 922 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 59: // equality: expression "==" expression
#line 598 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
            {
                if (!parseContext.test_modus)
                {
                    GeneralEvaluation * _arg2 = parseContext._stack.top();
                    parseContext._stack.pop();
                    GeneralEvaluation * _arg1 = parseContext._stack.top();
                    parseContext._stack.pop();
                    parseContext._stack.push( new EqualEvaluation(_arg1, _arg2) );

                }
                parseContext.syntax_ok &= true;
            }
#line 939 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 60: // not_equality: expression "!=" expression
#line 612 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
            {
                if (!parseContext.test_modus)
                {
                    GeneralEvaluation * _arg2 = parseContext._stack.top();
                    parseContext._stack.pop();
                    GeneralEvaluation * _arg1 = parseContext._stack.top();
                    parseContext._stack.pop();
                    parseContext._stack.push( new NotEqualEvaluation(_arg1, _arg2) );
                }
                parseContext.syntax_ok &= true;
            }
#line 955 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 61: // bigger: expression ">" expression
#line 626 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
            {
                if (!parseContext.test_modus)
                {
                    GeneralEvaluation * _arg2 = parseContext._stack.top();
                    parseContext._stack.pop();
                    GeneralEvaluation * _arg1 = parseContext._stack.top();
                    parseContext._stack.pop();
                    parseContext._stack.push( new BiggerEvaluation(_arg1, _arg2) );
                }
                parseContext.syntax_ok &= true;
            }
#line 971 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 62: // smaller: expression "<" expression
#line 639 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
            {
                if (!parseContext.test_modus)
                {
                    GeneralEvaluation * _arg2 = parseContext._stack.top();
                    parseContext._stack.pop();
                    GeneralEvaluation * _arg1 = parseContext._stack.top();
                    parseContext._stack.pop();
                    parseContext._stack.push( new SmallerEvaluation(_arg1, _arg2) );
                }
                parseContext.syntax_ok &= true;
            }
#line 987 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 63: // halfbigger: expression ">=" expression
#line 653 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
            {
                if (!parseContext.test_modus)
                {
                    GeneralEvaluation * _arg2 = parseContext._stack.top();
                    parseContext._stack.pop();
                    GeneralEvaluation * _arg1 = parseContext._stack.top();
                    parseContext._stack.pop();
                    parseContext._stack.push( new HalfBiggerEvaluation(_arg1, _arg2) );
                }
                parseContext.syntax_ok &= true;
            }
#line 1003 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 64: // halfsmaller: expression "<=" expression
#line 667 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
            {
                if (!parseContext.test_modus)
                {
                    GeneralEvaluation * _arg2 = parseContext._stack.top();
                    parseContext._stack.pop();
                    GeneralEvaluation * _arg1 = parseContext._stack.top();
                    parseContext._stack.pop();
                    parseContext._stack.push( new HalfSmallerEvaluation(_arg1, _arg2) );
                }
                parseContext.syntax_ok &= true;
            }
#line 1019 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 68: // string_equality: expression "eq" expression
#line 690 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
                {
                    if (!parseContext.test_modus)
                    {
                        GeneralEvaluation * _value2 =   parseContext._stack.top();
                        parseContext._stack.pop();
                        GeneralEvaluation * _value1 =   parseContext._stack.top();
                        parseContext._stack.pop();
                        parseContext._stack.push( new StringEqualityEvaluation(_value1, _value2 ) );
                    }
                    parseContext.syntax_ok &= true;
                }
#line 1035 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 69: // string_semi_equality: expression "seq" expression
#line 703 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
                {
                    if (!parseContext.test_modus)
                    {
                        GeneralEvaluation * _value2 =   parseContext._stack.top();
                        parseContext._stack.pop();
                        GeneralEvaluation * _value1 =   parseContext._stack.top();
                        parseContext._stack.pop();
                        parseContext._stack.push( new StringSemiEqualityEvaluation(_value1, _value2 ) );
                    }
                    parseContext.syntax_ok &= true;
                }
#line 1051 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 70: // regexp: expression "=~" regexp_expression
#line 715 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
                {
                    if (!parseContext.test_modus)
                    {
                        string _regexp =  parseContext.strings_stack.top();
                        parseContext.strings_stack.pop();
                        GeneralEvaluation * _value =   parseContext._stack.top();
                        parseContext._stack.pop();
                        parseContext._stack.push( new RegexEvaluation(_value, new StringConstantEvaluation(_regexp) ) );
                    }
                    parseContext.syntax_ok &= true;
                }
#line 1067 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 71: // regexp_expression: REGEXP_STRING
#line 730 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
                {
                    string _tmp = parseContext.str.str();
                    int _result = 0;
            try
            {
                std::regex self_regex( _tmp );
            }
            catch ( const std::regex_error& e )
            {
                _result=-1;
            }
                    if (_result != 0 )
                    {
                parseContext.syntax_ok &= false;
                    }
                    if (_result==0 && !parseContext.test_modus)
                    {
                parseContext.strings_stack.push( _tmp );
                parseContext.str.str("");
                    }
                    parseContext.syntax_ok &= true;
                }
#line 1094 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 72: // quoted_string: QUOTED_STRING
#line 758 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
                {
                    if (!parseContext.test_modus)
                    {
                    parseContext._stack.push( new StringConstantEvaluation( parseContext.str.str() ));
                    parseContext.str.str("");
                    }
                    parseContext.syntax_ok &= true;
                }
#line 1107 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 76: // lowercase: "lowercase" "(" expression ")"
#line 774 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
                    {
                        if (!parseContext.test_modus)
                        {
                            GeneralEvaluation * _arg1 = parseContext._stack.top();
                            parseContext._stack.pop();
                            parseContext._stack.push( new LowerCaseEvaluation(_arg1) );
                        }
                        parseContext.syntax_ok &= true;
                    }
#line 1121 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 77: // uppercase: "uppercase" "(" expression ")"
#line 785 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
                    {
                        if (!parseContext.test_modus)
                        {
                            GeneralEvaluation * _arg1 = parseContext._stack.top();
                            parseContext._stack.pop();
                            parseContext._stack.push( new UpperCaseEvaluation(_arg1) );
                        }
                        parseContext.syntax_ok &= true;
                    }
#line 1135 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 78: // getenv: "env" "(" expression ")"
#line 797 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
                    {
                        if (!parseContext.test_modus)
                        {
                            GeneralEvaluation * _arg1 = parseContext._stack.top();
                            parseContext._stack.pop();
                            parseContext._stack.push( new EnvEvaluation(_arg1) );
                        }
                        parseContext.syntax_ok &= true;
                    }
#line 1149 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 79: // metric_get: "cube::metric::get::" METRIC_NAME "(" quoted_string ")"
#line 811 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
                {
                    if (!parseContext.test_modus)
                    {
                        std::string uniq_name = parseContext.name_of_metric;
                        Metric * _met = parseContext.cube->get_met(uniq_name);
                        if (_met != NULL)
                        {
                            GeneralEvaluation * _property = parseContext._stack.top();
                            parseContext._stack.pop();
                            MetricGetEvaluation * _metric_get_eval = new MetricGetEvaluation( _met, _property );
                            parseContext._stack.push( _metric_get_eval );
                        }else
                        {
#ifdef HAVE_CUBELIB_DEBUG
                    UTILS_DEBUG_PRINTF
                    (
                        ( CUBELIB_DEBUG_CUBEPL_PARSER | CUBELIB_DEBUG_CUBEPL_EXECUTION ),
                        " Metric with uniq name  %s.  doesn't exists in cube. metric::get has no action.",
                        uniq_name.c_str()
                    );
#endif
                        }
                    }
                    parseContext.syntax_ok &= true;
                }
#line 1179 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 80: // metric_get_ext: "cube::metric::get::" METRIC_NAME "(" quoted_string "," expression ")"
#line 838 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
                {
                    if (!parseContext.test_modus)
                    {
                        std::string uniq_name = parseContext.name_of_metric;
                        Metric * _met = parseContext.cube->get_met(uniq_name);
                        if (_met != NULL)
                        {
                            GeneralEvaluation * _number_of_attribute = parseContext._stack.top();
                            parseContext._stack.pop();
                            GeneralEvaluation * _property = parseContext._stack.top();
                            parseContext._stack.pop();

                            MetricGetEvaluation * _metric_get_eval = new MetricGetEvaluation( _met, _property, _number_of_attribute );
                            parseContext._stack.push( _metric_get_eval );
                        }else
                        {
#ifdef HAVE_CUBELIB_DEBUG
                    UTILS_DEBUG_PRINTF
                    (
                        ( CUBELIB_DEBUG_CUBEPL_PARSER | CUBELIB_DEBUG_CUBEPL_EXECUTION ),
                        " Metric with uniq name  %s.  doesn't exists in cube. metric::get has no action.",
                        uniq_name.c_str()
                    );
#endif
                        }
                    }
                    parseContext.syntax_ok &= true;
                }
#line 1212 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 81: // callpath_get: "cube::callpath::get" "(" expression "," quoted_string "," expression ")"
#line 868 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
                {
                    if (!parseContext.test_modus)
                    {
                        GeneralEvaluation * _attribute_id = parseContext._stack.top();
                        parseContext._stack.pop();
                        GeneralEvaluation * _property = parseContext._stack.top();
                        parseContext._stack.pop();
                        GeneralEvaluation * _callpath_id = parseContext._stack.top();
                        parseContext._stack.pop();
                        CallpathGetEvaluation * _callpath_get_eval = new CallpathGetEvaluation(parseContext.cube, _callpath_id, _property, _attribute_id );
                        parseContext._stack.push( _callpath_get_eval );
                    }
                    parseContext.syntax_ok &= true;
                }
#line 1231 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 82: // region_get: "cube::region::get" "(" expression "," quoted_string "," expression ")"
#line 884 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
                {
                    if (!parseContext.test_modus)
                    {
                        GeneralEvaluation * _attribute_id = parseContext._stack.top();
                        parseContext._stack.pop();
                        GeneralEvaluation * _property = parseContext._stack.top();
                        parseContext._stack.pop();
                        GeneralEvaluation * _region_id = parseContext._stack.top();
                        parseContext._stack.pop();
                        RegionGetEvaluation * _region_get_eval = new RegionGetEvaluation(parseContext.cube, _region_id, _property, _attribute_id );
                        parseContext._stack.push( _region_get_eval );
                    }
                    parseContext.syntax_ok &= true;
                }
#line 1250 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 85: // sysres_get: "cube::location::get" "(" expression "," quoted_string "," expression ")"
#line 904 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
                {
                    if (!parseContext.test_modus)
                    {
                        GeneralEvaluation * _attribute_id = parseContext._stack.top();
                        parseContext._stack.pop();
                        GeneralEvaluation * _property = parseContext._stack.top();
                        parseContext._stack.pop();
                        GeneralEvaluation * _sysres_id = parseContext._stack.top();
                        parseContext._stack.pop();
                        SysresGetEvaluation * _stn_get_eval = new SysresGetEvaluation(parseContext.cube, _sysres_id, _property, _attribute_id );
                        parseContext._stack.push( _stn_get_eval );
                    }
                    parseContext.syntax_ok &= true;
                }
#line 1269 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 88: // one_variable_function: function_name "(" expression ")"
#line 922 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
                    {
                        if (!parseContext.test_modus)
                        {
                                    GeneralEvaluation * _arg1 = parseContext._stack.top();
                                    parseContext._stack.pop();
                                    parseContext.function_call.top()->addArgument( _arg1 );
                                    parseContext._stack.push( parseContext.function_call.top() );
                                    parseContext.function_call.pop();
                        }
                        parseContext.syntax_ok &= true;
                }
#line 1285 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 89: // function_name: "sqrt"
#line 937 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
                {
                    if (!parseContext.test_modus)
                    {
                            parseContext.function_call.push( new SqrtEvaluation());
                    }
                    parseContext.syntax_ok &= true;
                }
#line 1297 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 90: // function_name: "sin"
#line 945 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
                {
                    if (!parseContext.test_modus)
                    {
                            parseContext.function_call.push( new SinEvaluation());
                    }
                    parseContext.syntax_ok &= true;
                }
#line 1309 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 91: // function_name: "asin"
#line 953 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
                {
                    if (!parseContext.test_modus)
                    {
                            parseContext.function_call.push( new ASinEvaluation());
                    }
                    parseContext.syntax_ok &= true;
                }
#line 1321 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 92: // function_name: "cos"
#line 961 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
                {
                    if (!parseContext.test_modus)
                    {
                            parseContext.function_call.push( new CosEvaluation());
                    }
                    parseContext.syntax_ok &= true;
                }
#line 1333 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 93: // function_name: "acos"
#line 969 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
                {
                    if (!parseContext.test_modus)
                    {
                            parseContext.function_call.push( new ACosEvaluation());
                    }
                    parseContext.syntax_ok &= true;
                }
#line 1345 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 94: // function_name: "exp"
#line 977 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
                {
                    if (!parseContext.test_modus)
                    {
                            parseContext.function_call.push( new ExpEvaluation());
                    }
                    parseContext.syntax_ok &= true;
                }
#line 1357 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 95: // function_name: "log"
#line 985 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
                {
                    if (!parseContext.test_modus)
                    {
                            parseContext.function_call.push( new LnEvaluation());
                    }
                    parseContext.syntax_ok &= true;
                }
#line 1369 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 96: // function_name: "tan"
#line 993 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
                {
                    if (!parseContext.test_modus)
                    {
                            parseContext.function_call.push( new TanEvaluation());
                    }
                    parseContext.syntax_ok &= true;
                }
#line 1381 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 97: // function_name: "atan"
#line 1001 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
                {
                    if (!parseContext.test_modus)
                    {
                            parseContext.function_call.push( new ATanEvaluation());
                    }
                    parseContext.syntax_ok &= true;
                }
#line 1393 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 98: // function_name: "random"
#line 1009 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
                {
                    if (!parseContext.test_modus)
                    {
                            parseContext.function_call.push( new RandomEvaluation());
                    }
                    parseContext.syntax_ok &= true;
                }
#line 1405 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 99: // function_name: "abs"
#line 1017 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
                {
                    if (!parseContext.test_modus)
                    {
                            parseContext.function_call.push( new AbsEvaluation());
                    }
                    parseContext.syntax_ok &= true;
                }
#line 1417 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 100: // function_name: "sgn"
#line 1025 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
                {
                    if (!parseContext.test_modus)
                    {
                            parseContext.function_call.push( new SgnEvaluation());
                    }
                    parseContext.syntax_ok &= true;
                }
#line 1429 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 101: // function_name: "pos"
#line 1033 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
                {
                    if (!parseContext.test_modus)
                    {
                            parseContext.function_call.push( new PosEvaluation());
                    }
                    parseContext.syntax_ok &= true;
                }
#line 1441 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 102: // function_name: "neg"
#line 1041 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
                {
                    if (!parseContext.test_modus)
                    {
                            parseContext.function_call.push( new NegEvaluation());
                    }
                    parseContext.syntax_ok &= true;
                }
#line 1453 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 103: // function_name: "floor"
#line 1049 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
                {
                    if (!parseContext.test_modus)
                    {
                            parseContext.function_call.push( new FloorEvaluation());
                    }
                    parseContext.syntax_ok &= true;
                }
#line 1465 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 104: // function_name: "ceil"
#line 1057 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
                {
                    if (!parseContext.test_modus)
                    {
                            parseContext.function_call.push( new CeilEvaluation());
                    }
                    parseContext.syntax_ok &= true;
                }
#line 1477 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 105: // two_variables_function: function2_name "(" expression "," expression ")"
#line 1068 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
                {
                        if (!parseContext.test_modus)
                        {
                                    GeneralEvaluation * _arg2 = parseContext._stack.top();
                                    parseContext._stack.pop();
                                    GeneralEvaluation * _arg1 = parseContext._stack.top();
                                    parseContext._stack.pop();
                                    parseContext.function_call.top()->addArgument( _arg1 );
                                    parseContext.function_call.top()->addArgument( _arg2 );
                                    parseContext._stack.push( parseContext.function_call.top() );
                                    parseContext.function_call.pop();
                        }
                        parseContext.syntax_ok &= true;
                }
#line 1496 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 106: // function2_name: "min"
#line 1084 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
                {
                    if (!parseContext.test_modus)
                    {
                            parseContext.function_call.push( new MinEvaluation());
                    }
                    parseContext.syntax_ok &= true;
                }
#line 1508 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 107: // function2_name: "max"
#line 1092 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
                {
                    if (!parseContext.test_modus)
                    {
                            parseContext.function_call.push( new MaxEvaluation());
                    }
                    parseContext.syntax_ok &= true;
                }
#line 1520 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 108: // constant: CONSTANT
#line 1103 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
            {
               if (!parseContext.test_modus)
               {
                double _value = atof( parseContext.value.c_str());
                parseContext._stack.push( new ConstantEvaluation(_value));
                parseContext.value = "";
                }
                parseContext.syntax_ok &= true;
            }
#line 1534 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 112: // context_metric: "metric::" METRIC_NAME "(" ")"
#line 1119 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
        {
            if (!parseContext.test_modus)
            {
                Metric * _met = parseContext.cube->get_met(parseContext.name_of_metric);
                if (_met != NULL)
                {
                    parseContext._stack.push( new DirectMetricEvaluation(cube::CONTEXT_METRIC,  parseContext.cube, _met ));
                    _met->isUsedByOthers( true );
                }
                else
                {
#ifdef HAVE_CUBELIB_DEBUG
                    UTILS_DEBUG_PRINTF
                    (
                        ( CUBELIB_DEBUG_CUBEPL_PARSER | CUBELIB_DEBUG_CUBEPL_EXECUTION ),
                        "Cannot connect to the metric %s. Seems that this metric is not created yet. Value of metric::%s() will be always 0",
                        parseContext.name_of_metric.c_str(),
                        parseContext.name_of_metric.c_str()
                    );
#endif
                    parseContext._stack.push( new ConstantEvaluation( 0 ));

                }
                parseContext.value = "";
                }
                parseContext.syntax_ok &= true;
        }
#line 1566 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 113: // context_metric: "metric::" METRIC_NAME "(" calculationFlavourModificator ")"
#line 1147 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
        {
            if (!parseContext.test_modus)
            {
                Metric * _met = parseContext.cube->get_met(parseContext.name_of_metric);
                if (_met != NULL)
                {
                    cube::CalcFlavorModificator * mod = parseContext.calcFlavorModificators.top();
                    parseContext.calcFlavorModificators.pop();
                    parseContext._stack.push( new DirectMetricEvaluation(cube::CONTEXT_METRIC,  parseContext.cube, _met, mod ));
                    _met->isUsedByOthers( true );
                }
                else
                {
                    cube::CalcFlavorModificator * mod = parseContext.calcFlavorModificators.top();
                    parseContext.calcFlavorModificators.pop();
#ifdef HAVE_CUBELIB_DEBUG
                    UTILS_DEBUG_PRINTF
                    (
                        ( CUBELIB_DEBUG_CUBEPL_PARSER | CUBELIB_DEBUG_CUBEPL_EXECUTION ),
                        "Cannot connect to the metric %s. Seems that this metric is not created yet. Value of metric::%s() will be always 0",
                        parseContext.name_of_metric.c_str(),
                        parseContext.name_of_metric.c_str()
                    );
#endif
                delete mod;
                parseContext._stack.push( new ConstantEvaluation( 0 ));

                }
                parseContext.value = "";
                }
                parseContext.syntax_ok &= true;
        }
#line 1603 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 114: // context_metric: "metric::" METRIC_NAME "(" calculationFlavourModificator "," calculationFlavourModificator ")"
#line 1180 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
        {
            if (!parseContext.test_modus)
            {
                Metric * _met = parseContext.cube->get_met(parseContext.name_of_metric);
                if (_met != NULL)
                {
                    cube::CalcFlavorModificator * mod2 = parseContext.calcFlavorModificators.top();
                    parseContext.calcFlavorModificators.pop();
                    cube::CalcFlavorModificator * mod1 = parseContext.calcFlavorModificators.top();
                    parseContext.calcFlavorModificators.pop();

                    parseContext._stack.push( new DirectMetricEvaluation(cube::CONTEXT_METRIC,  parseContext.cube, _met, mod1, mod2));
                    _met->isUsedByOthers( true );
                }
                else
                {
#ifdef HAVE_CUBELIB_DEBUG
                    UTILS_DEBUG_PRINTF
                    (
                        ( CUBELIB_DEBUG_CUBEPL_PARSER | CUBELIB_DEBUG_CUBEPL_EXECUTION ),
                        "Cannot connect to the metric %s. Seems that this metric is not created yet. Value of metric::%s() will be always 0",
                        parseContext.name_of_metric.c_str(),
                        parseContext.name_of_metric.c_str()
                    );
#endif
                cube::CalcFlavorModificator * mod2 = parseContext.calcFlavorModificators.top();
                parseContext.calcFlavorModificators.pop();
                cube::CalcFlavorModificator * mod1 = parseContext.calcFlavorModificators.top();
                parseContext.calcFlavorModificators.pop();
                parseContext._stack.push( new ConstantEvaluation( 0 ));

                delete mod1;
                delete mod2;

                }
                parseContext.value = "";
                }
                parseContext.syntax_ok &= true;
        }
#line 1647 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 115: // fixed_metric: "metric::fixed::" METRIC_NAME "(" ")"
#line 1223 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
        {
            if (!parseContext.test_modus)
            {
                Metric * _met = parseContext.cube->get_met(parseContext.name_of_metric);
                if (_met != NULL)
                {
                    parseContext._stack.push( new DirectMetricEvaluation(cube::FIXED_METRIC_FULL_AGGR,  parseContext.cube, _met ));
                    _met->isUsedByOthers( true );
                }
                else
                {
#ifdef HAVE_CUBELIB_DEBUG
                    UTILS_DEBUG_PRINTF
                    (
                        ( CUBELIB_DEBUG_CUBEPL_PARSER | CUBELIB_DEBUG_CUBEPL_EXECUTION ),
                        "Cannot connect to the metric %s. Seems that this metric is not created yet. Value of metric::fixed::%s() will be always 0",
                        parseContext.name_of_metric.c_str(),
                        parseContext.name_of_metric.c_str()
                    );
#endif
                parseContext._stack.push( new ConstantEvaluation( 0 ));

                }
                parseContext.value = "";
                }
                parseContext.syntax_ok &= true;
        }
#line 1679 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 116: // fixed_metric: "metric::fixed::" METRIC_NAME "(" calculationFlavourModificator ")"
#line 1251 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
        {
            if (!parseContext.test_modus)
            {
                Metric * _met = parseContext.cube->get_met(parseContext.name_of_metric);
                if (_met != NULL)
                {
                    cube::CalcFlavorModificator * mod = parseContext.calcFlavorModificators.top();
                    parseContext.calcFlavorModificators.pop();
                    parseContext._stack.push( new DirectMetricEvaluation(cube::FIXED_METRIC_AGGR_SYS,  parseContext.cube, _met, mod ));
                    _met->isUsedByOthers( true );

                }
                else
                {
                    cube::CalcFlavorModificator * mod = parseContext.calcFlavorModificators.top();
                    parseContext.calcFlavorModificators.pop();
#ifdef HAVE_CUBELIB_DEBUG
                    UTILS_DEBUG_PRINTF
                    (
                        ( CUBELIB_DEBUG_CUBEPL_PARSER | CUBELIB_DEBUG_CUBEPL_EXECUTION ),
                        "Cannot connect to the metric %s. Seems that this metric is not created yet. Value of metric::fixed::%s(",
                        parseContext.name_of_metric.c_str(),
                        parseContext.name_of_metric.c_str()
                    );
                    mod->print();
                    UTILS_DEBUG_PRINTF
                    (
                        ( CUBELIB_DEBUG_CUBEPL_PARSER | CUBELIB_DEBUG_CUBEPL_EXECUTION ),
                        ") will be always 0"
                    );
#endif
                    delete mod;

                    parseContext._stack.push( new ConstantEvaluation( 0 ));

                }
                parseContext.value = "";
                }
                parseContext.syntax_ok &= true;
        }
#line 1724 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 117: // fixed_metric: "metric::fixed::" METRIC_NAME "(" calculationFlavourModificator "," calculationFlavourModificator ")"
#line 1292 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
        {
            if (!parseContext.test_modus)
            {
                Metric * _met = parseContext.cube->get_met(parseContext.name_of_metric);
                if (_met != NULL)
                {
                    cube::CalcFlavorModificator * mod2 = parseContext.calcFlavorModificators.top();
                    parseContext.calcFlavorModificators.pop();
                    cube::CalcFlavorModificator * mod1 = parseContext.calcFlavorModificators.top();
                    parseContext.calcFlavorModificators.pop();

                    parseContext._stack.push( new DirectMetricEvaluation(cube::FIXED_METRIC_NO_AGGR,  parseContext.cube, _met, mod1, mod2));
                    _met->isUsedByOthers( true );
                }
                else
                {
                    cube::CalcFlavorModificator * mod2 = parseContext.calcFlavorModificators.top();
                    parseContext.calcFlavorModificators.pop();
                    cube::CalcFlavorModificator * mod1 = parseContext.calcFlavorModificators.top();
                    parseContext.calcFlavorModificators.pop();
#ifdef HAVE_CUBELIB_DEBUG
                    UTILS_DEBUG_PRINTF
                    (
                        ( CUBELIB_DEBUG_CUBEPL_PARSER | CUBELIB_DEBUG_CUBEPL_EXECUTION ),
                        "Cannot connect to the metric %s. Seems that this metric is not created yet. Value of metric::fixed::%s(",
                        parseContext.name_of_metric.c_str(),
                        parseContext.name_of_metric.c_str()
                    );
                    mod1->print();
                    UTILS_DEBUG_PRINTF
                    (
                        ( CUBELIB_DEBUG_CUBEPL_PARSER | CUBELIB_DEBUG_CUBEPL_EXECUTION ),
                        ","
                    );
                    mod2->print();
                    UTILS_DEBUG_PRINTF
                    (
                        ( CUBELIB_DEBUG_CUBEPL_PARSER | CUBELIB_DEBUG_CUBEPL_EXECUTION ),
                        ") will be always 0"
                    );
#endif
                    delete mod2;
                    delete mod1;

                    parseContext._stack.push( new ConstantEvaluation( 0 ));

                }
                parseContext.value = "";
                }
                parseContext.syntax_ok &= true;
        }
#line 1780 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 118: // metric_call: "metric::call::" METRIC_NAME "(" expression "," calculationFlavourModificator ")"
#line 1347 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
        {
            if (!parseContext.test_modus)
            {
                Metric * _met = parseContext.cube->get_met(parseContext.name_of_metric);
                if (_met != NULL)
                {
                    cube::CalcFlavorModificator * mod = parseContext.calcFlavorModificators.top();
                    parseContext.calcFlavorModificators.pop();
                    GeneralEvaluation * _cnode_id = parseContext._stack.top();
                    parseContext._stack.pop();

                    parseContext._stack.push( new DirectMetricEvaluation(cube::METRIC_CALL_CALLPATH,  parseContext.cube, _met, _cnode_id, mod ));
                    _met->isUsedByOthers( true );

                }
                else
                {
                    cube::CalcFlavorModificator * mod = parseContext.calcFlavorModificators.top();
                    parseContext.calcFlavorModificators.pop();

                    GeneralEvaluation * _cnode_id = parseContext._stack.top();
                    parseContext._stack.pop();
#ifdef HAVE_CUBELIB_DEBUG
                    UTILS_DEBUG_PRINTF
                    (
                        ( CUBELIB_DEBUG_CUBEPL_PARSER | CUBELIB_DEBUG_CUBEPL_EXECUTION ),
                        "Cannot connect to the metric %s. Seems that this metric is not created yet. Value of metric::fixed::%s(",
                        parseContext.name_of_metric.c_str(),
                        parseContext.name_of_metric.c_str()
                    );
                    _cnode_id->print();
                    UTILS_DEBUG_PRINTF
                    (
                        ( CUBELIB_DEBUG_CUBEPL_PARSER | CUBELIB_DEBUG_CUBEPL_EXECUTION ),
                        ","
                    );
                    mod->print();
                    UTILS_DEBUG_PRINTF
                    (
                        ( CUBELIB_DEBUG_CUBEPL_PARSER | CUBELIB_DEBUG_CUBEPL_EXECUTION ),
                        ") will be always 0"
                    );
#endif
                    delete mod;
                    delete _cnode_id;

                    parseContext._stack.push( new ConstantEvaluation( 0 ));

                }
                parseContext.value = "";
                }
                parseContext.syntax_ok &= true;
        }
#line 1838 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 119: // metric_call: "metric::call::" METRIC_NAME "(" expression "," calculationFlavourModificator "," expression "," calculationFlavourModificator ")"
#line 1401 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
        {
            if (!parseContext.test_modus)
            {
                Metric * _met = parseContext.cube->get_met(parseContext.name_of_metric);
                if (_met != NULL)
                {
                    cube::CalcFlavorModificator * mod2 = parseContext.calcFlavorModificators.top();
                    parseContext.calcFlavorModificators.pop();
                    cube::CalcFlavorModificator * mod1 = parseContext.calcFlavorModificators.top();
                    parseContext.calcFlavorModificators.pop();
                    GeneralEvaluation * _sysres_id = parseContext._stack.top();
                    parseContext._stack.pop();
                    GeneralEvaluation * _cnode_id = parseContext._stack.top();
                    parseContext._stack.pop();
                    parseContext._stack.push( new DirectMetricEvaluation(cube::METRIC_CALL_FULL,  parseContext.cube, _met, _cnode_id, mod1, _sysres_id,  mod2));
                    _met->isUsedByOthers( true );
                }
                else
                {
                    cube::CalcFlavorModificator * mod2 = parseContext.calcFlavorModificators.top();
                    parseContext.calcFlavorModificators.pop();
                    cube::CalcFlavorModificator * mod1 = parseContext.calcFlavorModificators.top();
                    parseContext.calcFlavorModificators.pop();
                    GeneralEvaluation * _sysres_id = parseContext._stack.top();
                    parseContext._stack.pop();
                    GeneralEvaluation * _cnode_id = parseContext._stack.top();
                    parseContext._stack.pop();
#ifdef HAVE_CUBELIB_DEBUG
                    UTILS_DEBUG_PRINTF
                    (
                        ( CUBELIB_DEBUG_CUBEPL_PARSER | CUBELIB_DEBUG_CUBEPL_EXECUTION ),
                        "Cannot connect to the metric %s. Seems that this metric is not created yet. Value of metric::fixed::%s(",
                        parseContext.name_of_metric.c_str(),
                        parseContext.name_of_metric.c_str()
                    );
                    _cnode_id->print();
                    UTILS_DEBUG_PRINTF
                    (
                        ( CUBELIB_DEBUG_CUBEPL_PARSER | CUBELIB_DEBUG_CUBEPL_EXECUTION ),
                        ","
                    );
                    mod1->print();
                    UTILS_DEBUG_PRINTF
                    (
                        ( CUBELIB_DEBUG_CUBEPL_PARSER | CUBELIB_DEBUG_CUBEPL_EXECUTION ),
                        ","
                    );
                    _sysres_id->print();
                    UTILS_DEBUG_PRINTF
                    (
                        ( CUBELIB_DEBUG_CUBEPL_PARSER | CUBELIB_DEBUG_CUBEPL_EXECUTION ),
                        ","
                    );
                    mod2->print();
                    UTILS_DEBUG_PRINTF
                    (
                        ( CUBELIB_DEBUG_CUBEPL_PARSER | CUBELIB_DEBUG_CUBEPL_EXECUTION ),
                        ") will be always 0"
                    );
#endif
                    delete mod2;
                    delete mod1;
                    delete _cnode_id;
                    delete _sysres_id;

                    parseContext._stack.push( new ConstantEvaluation( 0 ));

                }
                parseContext.value = "";
                }
                parseContext.syntax_ok &= true;
        }
#line 1915 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 120: // calculationFlavourModificator: "i"
#line 1478 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
                                {
                                    if (!parseContext.test_modus)
                                    {
                                        parseContext.calcFlavorModificators.push(new CalcFlavorModificatorIncl());
                                    }
                                    parseContext.syntax_ok &= true;
                                }
#line 1927 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 121: // calculationFlavourModificator: "e"
#line 1486 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
                                {
                                    if (!parseContext.test_modus)
                                    {
                                        parseContext.calcFlavorModificators.push(new CalcFlavorModificatorExcl());
                                    }
                                    parseContext.syntax_ok &= true;
                                }
#line 1939 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 122: // calculationFlavourModificator: SAME_MODIFICATOR
#line 1494 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
                                {
                                    if (!parseContext.test_modus)
                                    {
                                        parseContext.calcFlavorModificators.push(new CalcFlavorModificatorSame());
                                    }
                                    parseContext.syntax_ok &= true;
                                }
#line 1951 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 123: // lambda_calcul: lambda_start list_of_statements return_expression "}"
#line 1505 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
            {
                if (!parseContext.test_modus)
                {

                    LambdaCalculEvaluation * _l_calc = new LambdaCalculEvaluation();

                    GeneralEvaluation * return_expr = parseContext._stack.top();
                    parseContext._stack.pop();

                    int _num_of_statements = parseContext._number_of_statements.top();
                    parseContext._number_of_statements.pop();

                    vector<GeneralEvaluation*> _tmp_statements;
                    for (int i=0; i<_num_of_statements; i++)
                    {
                        _tmp_statements.push_back( parseContext._statements.top());
                        parseContext._statements.pop();
                    }
                    for (int i=_num_of_statements-1; i>=0; i--)
                    {
                        _l_calc->addArgument( _tmp_statements[i]);
                    }
                    _l_calc->addArgument( return_expr);
                    parseContext._stack.push(_l_calc);
                    // create lambda calculation using number_of_statements.
                }
                parseContext.syntax_ok &= true;
            }
#line 1984 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 125: // lambda_start: "{"
#line 1537 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
            {
                if (!parseContext.test_modus)
                {
                    parseContext._number_of_statements.push(0);
                }
                parseContext.syntax_ok &= true;
            }
#line 1996 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 128: // statement: if_statement
#line 1554 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
           {
                if (!parseContext.test_modus)
                {
                    int _tmp = parseContext._number_of_statements.top();
                    parseContext._number_of_statements.pop();
                    _tmp++;
                    parseContext._number_of_statements.push(_tmp);
                }
                parseContext.syntax_ok &= true;
            }
#line 2011 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 129: // statement: while_statement
#line 1565 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
           {
                if (!parseContext.test_modus)
                {
                    int _tmp = parseContext._number_of_statements.top();
                    parseContext._number_of_statements.pop();
                    _tmp++;
                    parseContext._number_of_statements.push(_tmp);
                }
                parseContext.syntax_ok &= true;
            }
#line 2026 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 130: // statement: assignment
#line 1576 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
           {
            if (!parseContext.test_modus)
            {
                int _tmp = parseContext._number_of_statements.top();
                parseContext._number_of_statements.pop();
                _tmp++;
                parseContext._number_of_statements.push(_tmp);
            }
                parseContext.syntax_ok &= true;
            }
#line 2041 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 131: // statement: local_variable
#line 1587 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
            {
                parseContext.syntax_ok &= true;
            }
#line 2049 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 132: // statement: global_variable
#line 1591 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
            {
                parseContext.syntax_ok &= true;
            }
#line 2057 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 133: // statement: print_statement
#line 1595 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
            {
                if (!parseContext.test_modus)
                {
                    int _tmp = parseContext._number_of_statements.top();
                    parseContext._number_of_statements.pop();
                    _tmp++;
                    parseContext._number_of_statements.push(_tmp);
                }
                parseContext.syntax_ok &= true;
            }
#line 2072 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 134: // statement: metric_set
#line 1606 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
            {
            if (!parseContext.test_modus)
            {
                int _tmp = parseContext._number_of_statements.top();
                parseContext._number_of_statements.pop();
                _tmp++;
                parseContext._number_of_statements.push(_tmp);
            }
                parseContext.syntax_ok &= true;
            }
#line 2087 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 135: // statement: metric_set_ext
#line 1617 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
            {
            if (!parseContext.test_modus)
            {
                int _tmp = parseContext._number_of_statements.top();
                parseContext._number_of_statements.pop();
                _tmp++;
                parseContext._number_of_statements.push(_tmp);
            }
                parseContext.syntax_ok &= true;
            }
#line 2102 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 136: // statement: callpath_set
#line 1629 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
            {
            if (!parseContext.test_modus)
            {
                int _tmp = parseContext._number_of_statements.top();
                parseContext._number_of_statements.pop();
                _tmp++;
                parseContext._number_of_statements.push(_tmp);
            }
                parseContext.syntax_ok &= true;
            }
#line 2117 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 137: // statement: region_set
#line 1640 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
            {
            if (!parseContext.test_modus)
            {
                int _tmp = parseContext._number_of_statements.top();
                parseContext._number_of_statements.pop();
                _tmp++;
                parseContext._number_of_statements.push(_tmp);
            }
                parseContext.syntax_ok &= true;
            }
#line 2132 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 138: // statement: sysres_set
#line 1652 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
            {
            if (!parseContext.test_modus)
            {
                int _tmp = parseContext._number_of_statements.top();
                parseContext._number_of_statements.pop();
                _tmp++;
                parseContext._number_of_statements.push(_tmp);
            }
                parseContext.syntax_ok &= true;
            }
#line 2147 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 139: // statement: create_ghost_metric
#line 1664 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
            {
                parseContext.syntax_ok &= true;
            }
#line 2155 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 140: // statement: init_metric
#line 1668 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
            {
                parseContext.syntax_ok &= true;
            }
#line 2163 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 141: // statement: flex_aggr_plus
#line 1672 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
            {
                parseContext.syntax_ok &= true;
            }
#line 2171 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 142: // statement: flex_aggr_minus
#line 1676 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
            {
                parseContext.syntax_ok &= true;
            }
#line 2179 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 147: // simple_if_statement: if_condition enclosed_list_of_statements
#line 1695 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
            {
                if (!parseContext.test_modus)
                {
                    int _num_of_statements = parseContext._number_of_statements.top();
                    parseContext._number_of_statements.pop();

                    vector<GeneralEvaluation*> _tmp_statements;
                    for (int i=0; i<_num_of_statements; i++)
                    {
                        _tmp_statements.push_back( parseContext._statements.top());
                        parseContext._statements.pop();
                    }
                    GeneralEvaluation * _condition = parseContext._stack.top();
                    parseContext._stack.pop();

                    ShortIfEvaluation * _s_if_calc = new ShortIfEvaluation(_condition);

                    for (int i=_num_of_statements-1; i>=0; i--)
                    {
                        _s_if_calc->addArgument( _tmp_statements[i]);
                    }
                    parseContext._statements.push(_s_if_calc);
                }
                parseContext.syntax_ok &= true;
            }
#line 2209 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 148: // full_if_statement: if_condition enclosed_list_of_statements else_enclosed_list_of_statements
#line 1722 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
            {
                if (!parseContext.test_modus)
                {
                    int _num_of_false_statements = parseContext._number_of_statements.top();
                    parseContext._number_of_statements.pop();
                    int _num_of_true_statements = parseContext._number_of_statements.top();
                    parseContext._number_of_statements.pop();

                    vector<GeneralEvaluation*> _tmp_false_statements;
                    for (int i=0; i<_num_of_false_statements; i++)
                    {
                        _tmp_false_statements.push_back( parseContext._statements.top());
                        parseContext._statements.pop();
                    }
                    vector<GeneralEvaluation*> _tmp_true_statements;
                    for (int i=0; i<_num_of_true_statements; i++)
                    {
                        _tmp_true_statements.push_back( parseContext._statements.top());
                        parseContext._statements.pop();
                    }
                    GeneralEvaluation * _condition = parseContext._stack.top();
                    parseContext._stack.pop();

                    FullIfEvaluation * _f_if_calc = new FullIfEvaluation(_condition, _num_of_true_statements, _num_of_false_statements);

                    for (int i=_num_of_true_statements-1; i>=0; i--)
                    {
                        _f_if_calc->addArgument( _tmp_true_statements[i]);
                    }
                    for (int i=_num_of_false_statements-1; i>=0; i--)
                    {
                        _f_if_calc->addArgument( _tmp_false_statements[i]);
                    }
                    parseContext._statements.push(_f_if_calc);
                }
                parseContext.syntax_ok &= true;
            }
#line 2251 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 149: // elseif_full_if_statement: if_condition enclosed_list_of_statements elseifs else_enclosed_list_of_statements
#line 1761 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
            {
                if (!parseContext.test_modus)
                {
                    std::stack<std::stack<GeneralEvaluation*> > statement_blocks;
                    std::stack<GeneralEvaluation*>  statement_conditions;

                    int _num_of_false_statements = parseContext._number_of_statements.top();
                    parseContext._number_of_statements.pop();
                    std::stack<GeneralEvaluation*> _tmp_false_statements;
                    for (int i=0; i<_num_of_false_statements; i++)
                    {
                        _tmp_false_statements.push( parseContext._statements.top());
                        parseContext._statements.pop();
                    }
                    statement_blocks.push( _tmp_false_statements);

                    for (unsigned i=0; i<parseContext.number_elseif + 1 /* +1 is for the initial condition*/; ++i)
                    {
                        int _num_of_statements = parseContext._number_of_statements.top();
                        parseContext._number_of_statements.pop();
                        std::stack<GeneralEvaluation*> _tmp_statements;
                        for (int j=0; j<_num_of_statements; j++)
                        {
                            _tmp_statements.push( parseContext._statements.top());
                            parseContext._statements.pop();
                        }

                        GeneralEvaluation * _condition = parseContext._stack.top();
                        parseContext._stack.pop();
                        statement_blocks.push( _tmp_statements);
                        statement_conditions.push( _condition );
                    }
                    ExtendedIfEvaluation * _ext_if_calc = new ExtendedIfEvaluation(statement_conditions, statement_blocks);
                    parseContext._statements.push(_ext_if_calc);

                    parseContext.number_elseif= 0;
                }
                parseContext.syntax_ok &= true;
            }
#line 2295 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 150: // elseif_if_statement: if_condition enclosed_list_of_statements elseifs
#line 1804 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
            {
                if (!parseContext.test_modus)
                {
                    std::stack<std::stack<GeneralEvaluation*> > statement_blocks;
                    std::stack<GeneralEvaluation*>  statement_conditions;

                    for (unsigned i=0; i<parseContext.number_elseif + 1 /* +1 is for the initial condition*/; ++i)
                    {
                        int _num_of_statements = parseContext._number_of_statements.top();
                        parseContext._number_of_statements.pop();
                        std::stack<GeneralEvaluation*> _tmp_statements;
                        for (int j=0; j<_num_of_statements; j++)
                        {
                            _tmp_statements.push( parseContext._statements.top());
                            parseContext._statements.pop();
                        }

                        GeneralEvaluation * _condition = parseContext._stack.top();
                        parseContext._stack.pop();
                        statement_blocks.push( _tmp_statements);
                        statement_conditions.push( _condition );
                    }
                    ExtendedIfEvaluation * _ext_if_calc = new ExtendedIfEvaluation(statement_conditions, statement_blocks);
                    parseContext._statements.push(_ext_if_calc);

                    parseContext.number_elseif= 0;
                }
                parseContext.syntax_ok &= true;
            }
#line 2329 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 153: // elseif_enclosed_list_of_statements: "elseif" "(" boolean_expression ")" enclosed_list_of_statements
#line 1841 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
            {
                if (!parseContext.test_modus)
                {
                    parseContext.number_elseif++;
                }
                parseContext.syntax_ok &= true;
            }
#line 2341 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 157: // enclosed_list_of_statements_start: "{"
#line 1860 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
            {
                if (!parseContext.test_modus)
                {
                    parseContext._number_of_statements.push(0);
                }
                parseContext.syntax_ok &= true;
            }
#line 2353 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 158: // while_statement: "while" "(" boolean_expression ")" enclosed_list_of_statements
#line 1870 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
            {
                if (!parseContext.test_modus)
                {
                    int _num_of_statements = parseContext._number_of_statements.top();
                    parseContext._number_of_statements.pop();

                    vector<GeneralEvaluation*> _tmp_statements;
                    for (int i=0; i<_num_of_statements; i++)
                    {
                        _tmp_statements.push_back( parseContext._statements.top());
                        parseContext._statements.pop();
                    }
                    GeneralEvaluation * _condition = parseContext._stack.top();
                    parseContext._stack.pop();

                    WhileEvaluation * _while_calc = new WhileEvaluation(_condition);

                    for (int i=_num_of_statements-1; i>=0; i--)
                    {
                        _while_calc->addArgument( _tmp_statements[i]);
                    }
                    parseContext._statements.push(_while_calc);

                }
                parseContext.syntax_ok &= true;
            }
#line 2384 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 159: // assignment: assignment_target "=" expression
#line 1899 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
            {
                if (!parseContext.test_modus)
                {
                        GeneralEvaluation * _value = parseContext._stack.top();
                        parseContext._stack.pop();
                        GeneralEvaluation * _index = parseContext._stack.top();
                        parseContext._stack.pop();
                        std::string _string = parseContext.string_constants.top();
                        parseContext.string_constants.pop();
                        AssignmentEvaluation * _assign_eval = new AssignmentEvaluation( _string , _index, _value, parseContext.cube->get_cubepl_memory_manager()  );
                        parseContext._statements.push( _assign_eval );
                }
                parseContext.syntax_ok &= true;
            }
#line 2403 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 162: // put_variable: "$" "{" string_constant "}"
#line 1919 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
              {
                if (!parseContext.test_modus)
                {
                    parseContext._stack.push( new ConstantEvaluation(0) ); // pushed index 0 if array index is not specified
                }
                parseContext.syntax_ok &= true;
              }
#line 2415 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 167: // create_postderived_ghost_metric: "cube::metric::postderived::" METRIC_NAME GhostMetricDefinition
#line 1939 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
                    {
                            if (!parseContext.test_modus)
                            {
                              std::string expression = parseContext.str.str();
                              parseContext.str.str("");
                              std::string uniq_name = parseContext.name_of_metric;
                              Metric * _met = parseContext.cube->get_met(uniq_name);
                              if (_met == NULL)
                              {
                                _met = parseContext.cube->def_met("",
                                                                      uniq_name,
                                                                     "DOUBLE",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      NULL,
                                                                      cube::CUBE_METRIC_POSTDERIVED,
                                                                      expression,
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      true,
                                                                      cube::CUBE_METRIC_GHOST
                                                                  );
                              }else
                              {
#ifdef HAVE_CUBELIB_DEBUG
                                UTILS_DEBUG_PRINTF
                                (
                                    ( CUBELIB_DEBUG_CUBEPL_PARSER | CUBELIB_DEBUG_CUBEPL_EXECUTION ),
                                    " Metric with uniq name  %s. already exists in cube",
                                    uniq_name.c_str()
                                );
#endif
                              }
                           }else
                          {
                              std::string expression = parseContext.str.str();
                              std::string                  cubepl_program = string( "<cubepl>" ) + expression + string( "</cubepl>" );
                              cubeplparser::CubePL1Driver* driver         = new cubeplparser::CubePL1Driver( parseContext.cube ); // create driver for this cube
                              std::string nested_error;
                              if (! driver->test( cubepl_program, nested_error ))
                              {
                                parseContext.syntax_ok &= false;
                              }
                              delete driver;
                            }
                            parseContext.syntax_ok &= true;

                    }
#line 2472 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 168: // create_prederived_inclusive_ghost_metric: "cube::metric::prederived::" METRIC_NAME "(" "i" ")" GhostMetricDefinition
#line 1993 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
                            {
                              if (!parseContext.test_modus)
                              {
                                std::string expression = parseContext.str.str();
                                parseContext.str.str("");
                                std::string uniq_name = parseContext.name_of_metric;
                                Metric * _met = parseContext.cube->get_met(uniq_name);
                                if (_met == NULL)
                                {
                                  _met = parseContext.cube->def_met("",
                                                                      uniq_name,
                                                                     "DOUBLE",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      NULL,
                                                                      cube::CUBE_METRIC_PREDERIVED_INCLUSIVE,
                                                                      expression,
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      true,
                                                                      cube::CUBE_METRIC_GHOST
                                                                    );
                                }else
                                {
#ifdef HAVE_CUBELIB_DEBUG
                                UTILS_DEBUG_PRINTF
                                (
                                    ( CUBELIB_DEBUG_CUBEPL_PARSER | CUBELIB_DEBUG_CUBEPL_EXECUTION ),
                                    " Metric with uniq name  %s. already exists in cube",
                                    uniq_name.c_str()
                                );
#endif
                                }
                            }else
                            {
                                std::string expression = parseContext.str.str();
                                std::string                  cubepl_program = string( "<cubepl>" ) + expression + string( "</cubepl>" );
                                cubeplparser::CubePL1Driver* driver         = new cubeplparser::CubePL1Driver( parseContext.cube ); // create driver for this cube
                                std::string nested_error;
                                if (! driver->test( cubepl_program, nested_error ))
                                {
                                  parseContext.syntax_ok = false;
                                }
                                delete driver;
                              }
                              parseContext.syntax_ok &= true;
                            }
#line 2528 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 169: // create_prederived_exclusive_ghost_metric: "cube::metric::prederived::" METRIC_NAME "(" "e" ")" GhostMetricDefinition
#line 2046 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
                            {
                                if (!parseContext.test_modus)
                                {
                                  std::string expression = parseContext.str.str();
                                  parseContext.str.str("");
                                  std::string uniq_name = parseContext.name_of_metric;
                                  Metric * _met = parseContext.cube->get_met(uniq_name);

                                  if (_met == NULL)
                                  {
                                    _met = parseContext.cube->def_met("",
                                                                        uniq_name,
                                                                      "DOUBLE",
                                                                        "",
                                                                        "",
                                                                        "",
                                                                        "",
                                                                        NULL,
                                                                        cube::CUBE_METRIC_PREDERIVED_EXCLUSIVE,
                                                                        expression,
                                                                        "",
                                                                        "",
                                                                        "",
                                                                      "",
                                                                        true,
                                                                        cube::CUBE_METRIC_GHOST
                                                                      );
                                  }else
                                  {
#ifdef HAVE_CUBELIB_DEBUG
                                UTILS_DEBUG_PRINTF
                                (
                                    ( CUBELIB_DEBUG_CUBEPL_PARSER | CUBELIB_DEBUG_CUBEPL_EXECUTION ),
                                    " Metric with uniq name  %s. already exists in cube",
                                    uniq_name.c_str()
                                );
#endif
                                }
                              }else
                              {
                                  std::string expression = parseContext.str.str();
                                  std::string                  cubepl_program = string( "<cubepl>" ) + expression + string( "</cubepl>" );
                                  cubeplparser::CubePL1Driver* driver         = new cubeplparser::CubePL1Driver( parseContext.cube ); // create driver for this cube
                                  std::string nested_error;
                                  if (! driver->test( cubepl_program, nested_error ))
                                  {
                                    parseContext.syntax_ok = false;
                                  }
                                  delete driver;
                              }
                              parseContext.syntax_ok &= true;
                            }
#line 2585 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 171: // metric_set: "cube::metric::set::" METRIC_NAME "(" quoted_string "," quoted_string ")"
#line 2107 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
{
            if (!parseContext.test_modus)
            {
                std::string uniq_name = parseContext.name_of_metric;
                Metric * _met = parseContext.cube->get_met(uniq_name);
                GeneralEvaluation * _value = parseContext._stack.top();
                parseContext._stack.pop();
                GeneralEvaluation * _property = parseContext._stack.top();
                parseContext._stack.pop();
                MetricSetEvaluation * _metric_set_eval = new MetricSetEvaluation( _met, _property , _value);
                parseContext._statements.push( _metric_set_eval );
                if (_met == NULL)
                {
#ifdef HAVE_CUBELIB_DEBUG
                    UTILS_DEBUG_PRINTF
                    (
                        ( CUBELIB_DEBUG_CUBEPL_PARSER | CUBELIB_DEBUG_CUBEPL_EXECUTION ),
                        " Metric with uniq name  %s.  doesn't exists in cube. metric::set has no action.",
                        uniq_name.c_str()
                    );
#endif
                }
            }
            parseContext.syntax_ok &= true;
}
#line 2615 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 172: // metric_set_ext: "cube::metric::set::" METRIC_NAME "(" quoted_string "," quoted_string "," expression ")"
#line 2134 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
{
            if (!parseContext.test_modus)
            {
                std::string uniq_name = parseContext.name_of_metric;
                Metric * _met = parseContext.cube->get_met(uniq_name);
                GeneralEvaluation * _value = parseContext._stack.top();
                parseContext._stack.pop();
                GeneralEvaluation * _number_of_attribute = parseContext._stack.top();
                parseContext._stack.pop();
                GeneralEvaluation * _property = parseContext._stack.top();
                parseContext._stack.pop();
                MetricSetEvaluation * _metric_set_eval = new MetricSetEvaluation( _met, _property , _number_of_attribute , _value);
                parseContext._statements.push( _metric_set_eval );
                if (_met == NULL)
                {
#ifdef HAVE_CUBELIB_DEBUG
                    UTILS_DEBUG_PRINTF
                    (
                        ( CUBELIB_DEBUG_CUBEPL_PARSER | CUBELIB_DEBUG_CUBEPL_EXECUTION ),
                        " Metric with uniq name  %s.  doesn't exists in cube. metric::set has no action.",
                        uniq_name.c_str()
                    );
#endif
                }
            }
            parseContext.syntax_ok &= true;
}
#line 2647 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 173: // callpath_set: "cube::callpath::set" "(" expression "," quoted_string "," expression "," expression ")"
#line 2166 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
{
            if (!parseContext.test_modus)
            {
                GeneralEvaluation * _value = parseContext._stack.top();
                parseContext._stack.pop();
                GeneralEvaluation * _attribute_id = parseContext._stack.top();
                parseContext._stack.pop();
                GeneralEvaluation * _property = parseContext._stack.top();
                parseContext._stack.pop();
                GeneralEvaluation * _callpath_id = parseContext._stack.top();
                parseContext._stack.pop();
                CallpathSetEvaluation * _callpath_set_eval = new CallpathSetEvaluation(parseContext.cube, _callpath_id, _property, _attribute_id, _value );
                parseContext._statements.push( _callpath_set_eval );
            }
            parseContext.syntax_ok &= true;
}
#line 2668 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 174: // region_set: "cube::region::get" "(" expression "," quoted_string "," expression "," expression ")"
#line 2187 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
{
            if (!parseContext.test_modus)
            {
                GeneralEvaluation * _value = parseContext._stack.top();
                parseContext._stack.pop();
                GeneralEvaluation * _attribute_id = parseContext._stack.top();
                parseContext._stack.pop();
                GeneralEvaluation * _property = parseContext._stack.top();
                parseContext._stack.pop();
                GeneralEvaluation * _region_id = parseContext._stack.top();
                parseContext._stack.pop();
                RegionSetEvaluation * _region_set_eval = new RegionSetEvaluation(parseContext.cube, _region_id, _property, _attribute_id, _value );
                parseContext._statements.push( _region_set_eval );
            }
            parseContext.syntax_ok &= true;
}
#line 2689 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 175: // sysres_set: "cube::stn::set" "(" expression "," quoted_string "," expression "," expression ")"
#line 2208 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
                {
                    if (!parseContext.test_modus)
                    {
                        GeneralEvaluation * _value = parseContext._stack.top();
                        parseContext._stack.pop();
                        GeneralEvaluation * _attribute_id = parseContext._stack.top();
                        parseContext._stack.pop();
                        GeneralEvaluation * _property = parseContext._stack.top();
                        parseContext._stack.pop();
                        GeneralEvaluation * _sysres_id = parseContext._stack.top();
                        parseContext._stack.pop();
                        SysresSetEvaluation * _stn_set_eval = new SysresSetEvaluation(CUBE_SYSTEM_TREE_NODE, parseContext.cube, _sysres_id, _property, _attribute_id, _value );
                        parseContext._statements.push( _stn_set_eval );
                    }
                    parseContext.syntax_ok &= true;
                }
#line 2710 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 176: // sysres_set: "cube::locationgroup::set" "(" expression "," quoted_string "," expression "," expression ")"
#line 2226 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
                  {
                    if (!parseContext.test_modus)
                    {
                        GeneralEvaluation * _value = parseContext._stack.top();
                        parseContext._stack.pop();
                        GeneralEvaluation * _attribute_id = parseContext._stack.top();
                        parseContext._stack.pop();
                        GeneralEvaluation * _property = parseContext._stack.top();
                        parseContext._stack.pop();
                        GeneralEvaluation * _sysres_id = parseContext._stack.top();
                        parseContext._stack.pop();
                        SysresSetEvaluation * _stn_set_eval = new SysresSetEvaluation(CUBE_LOCATION_GROUP, parseContext.cube, _sysres_id, _property, _attribute_id, _value );
                        parseContext._statements.push( _stn_set_eval );
                    }
                    parseContext.syntax_ok &= true;
                }
#line 2731 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 177: // sysres_set: "cube::location::set" "(" expression "," quoted_string "," expression "," expression ")"
#line 2244 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
                {
                    if (!parseContext.test_modus)
                    {
                        GeneralEvaluation * _value = parseContext._stack.top();
                        parseContext._stack.pop();
                        GeneralEvaluation * _attribute_id = parseContext._stack.top();
                        parseContext._stack.pop();
                        GeneralEvaluation * _property = parseContext._stack.top();
                        parseContext._stack.pop();
                        GeneralEvaluation * _sysres_id = parseContext._stack.top();
                        parseContext._stack.pop();
                        SysresSetEvaluation * _stn_set_eval = new SysresSetEvaluation(CUBE_LOCATION, parseContext.cube, _sysres_id, _property, _attribute_id, _value );
                        parseContext._statements.push( _stn_set_eval );
                    }
                    parseContext.syntax_ok &= true;
                }
#line 2752 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 179: // init_metric: "cube::init::metric::" METRIC_NAME GhostMetricDefinition
#line 2269 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
                {
                if (!parseContext.test_modus)
                {
                  std::string expression = parseContext.str.str();
                  parseContext.str.str("");
                  std::string uniq_name = parseContext.name_of_metric;
                  Metric * _met = parseContext.cube->get_met(uniq_name);

                    if (_met == NULL)
                    {
#ifdef HAVE_CUBELIB_DEBUG
                                UTILS_DEBUG_PRINTF
                                (
                                    ( CUBELIB_DEBUG_CUBEPL_PARSER | CUBELIB_DEBUG_CUBEPL_EXECUTION ),
                                    " Metric with uniq name  %s doesn't  exists yet. Cannot assign CubePL initialization expression. Skip.",
                                    uniq_name.c_str()
                                );
#endif
                    }else
                    {
                        _met->set_init_expression( expression );
                    }
                  }else
                  {
                  std::string expression = parseContext.str.str();
                  std::string                  cubepl_program = string( "<cubepl>" ) + expression + string( "</cubepl>" );
                  cubeplparser::CubePL1Driver* driver         = new cubeplparser::CubePL1Driver( parseContext.cube ); // create driver for this cube
                  std::string nested_error;
                  if (! driver->test( cubepl_program, nested_error ))
                  {
                    parseContext.syntax_ok = false;
                  }
                  delete driver;
                  }
                  parseContext.syntax_ok &= true;
                }
#line 2793 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 180: // flex_aggr_plus: "cube::metric::plus::" INIT_METRIC_NAME GhostMetricDefinition
#line 2308 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
                {
                if (!parseContext.test_modus)
                {
                  std::string expression = parseContext.str.str();
                  parseContext.str.str("");
                  std::string uniq_name = parseContext.name_of_metric;
                  Metric * _met = parseContext.cube->get_met(uniq_name);

                    if (_met == NULL)
                    {
#ifdef HAVE_CUBELIB_DEBUG
                                UTILS_DEBUG_PRINTF
                                (
                                    ( CUBELIB_DEBUG_CUBEPL_PARSER | CUBELIB_DEBUG_CUBEPL_EXECUTION ),
                                    " Metric with uniq name  %s doesn't  exists yet. Cannot assign CubePL initialization expression. Skip.",
                                    uniq_name.c_str()
                                );
#endif
                    }else
                    {
                        _met->set_aggr_plus_expression( expression );
                    }
                  }else
                  {
                  std::string expression = parseContext.str.str();
                  std::string                  cubepl_program = string( "<cubepl>" ) + expression + string( "</cubepl>" );
                  cubeplparser::CubePL1Driver* driver         = new cubeplparser::CubePL1Driver( parseContext.cube ); // create driver for this cube
                  std::string nested_error;
                  if (! driver->test( cubepl_program, nested_error ))
                  {
                    parseContext.syntax_ok = false;
                  }
                  delete driver;
                  }
                  parseContext.syntax_ok &= true;
                }
#line 2834 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 181: // flex_aggr_minus: "cube::metric::minus::" INIT_METRIC_NAME GhostMetricDefinition
#line 2347 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
                {
                if (!parseContext.test_modus)
                {
                  std::string expression = parseContext.str.str();
                  parseContext.str.str("");
                  std::string uniq_name = parseContext.name_of_metric;
                  Metric * _met = parseContext.cube->get_met(uniq_name);

                    if (_met == NULL)
                    {
#ifdef HAVE_CUBELIB_DEBUG
                                UTILS_DEBUG_PRINTF
                                (
                                    ( CUBELIB_DEBUG_CUBEPL_PARSER | CUBELIB_DEBUG_CUBEPL_EXECUTION ),
                                    " Metric with uniq name  %s doesn't  exists yet. Cannot assign CubePL initialization expression. Skip.",
                                    uniq_name.c_str()
                                );
#endif
                    }else
                    {
                        _met->set_aggr_minus_expression( expression );
                    }
                  }else
                  {
                  std::string expression = parseContext.str.str();
                  std::string                  cubepl_program = string( "<cubepl>" ) + expression + string( "</cubepl>" );
                  cubeplparser::CubePL1Driver* driver         = new cubeplparser::CubePL1Driver( parseContext.cube ); // create driver for this cube
                  std::string nested_error;
                  if (! driver->test( cubepl_program, nested_error ))
                  {
                    parseContext.syntax_ok = false;
                  }
                  delete driver;
                  }
                  parseContext.syntax_ok &= true;
                }
#line 2875 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 182: // get_variable: get_variable_simple
#line 2388 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
                  {
                    if (!parseContext.test_modus)
                    {
                            GeneralEvaluation * _index = parseContext._stack.top();
                            parseContext._stack.pop();
                            std::string _string = parseContext.string_constants.top();
                            parseContext.string_constants.pop();
                            VariableEvaluation * _var_eval = new VariableEvaluation(  _string, _index, parseContext.cube->get_cubepl_memory_manager()   );
                            parseContext._stack.push( _var_eval );
                    }
                    parseContext.syntax_ok &= true;
                }
#line 2892 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 183: // get_variable: get_variable_indexed
#line 2401 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
                {
                  if (!parseContext.test_modus)
                  {
                          GeneralEvaluation * _index = parseContext._stack.top();
                          parseContext._stack.pop();
                          std::string _string = parseContext.string_constants.top();
                          parseContext.string_constants.pop();
                          VariableEvaluation * _var_eval = new VariableEvaluation(  _string, _index, parseContext.cube->get_cubepl_memory_manager()  );
                          parseContext._stack.push( _var_eval );
                  }
                  parseContext.syntax_ok &= true;
              }
#line 2909 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 184: // get_variable_simple: "$" "{" string_constant "}"
#line 2416 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
            {
                if (!parseContext.test_modus)
                {
                    parseContext._stack.push( new ConstantEvaluation(0) ); // pushed index 0 if array index is not specified
                }
                parseContext.syntax_ok &= true;
            }
#line 2921 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 186: // sizeof_variable: "sizeof" "(" string_constant ")"
#line 2429 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
            {
        if (!parseContext.test_modus)
        {
            std::string _string = parseContext.string_constants.top();
            parseContext.string_constants.pop();
            SizeOfVariableEvaluation * _sizeof_var_eval = new SizeOfVariableEvaluation(  _string, parseContext.cube->get_cubepl_memory_manager()  );
            parseContext._stack.push( _sizeof_var_eval );
        }
        parseContext.syntax_ok &= true;
            }
#line 2936 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 187: // defined_variable: "defined" "(" string_constant ")"
#line 2441 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
            {
        if (!parseContext.test_modus)
        {
            std::string _string = parseContext.string_constants.top();
            parseContext.string_constants.pop();
            DefinedVariableEvaluation * _sizeof_var_eval = new DefinedVariableEvaluation(  _string, parseContext.cube->get_cubepl_memory_manager(), parseContext.cube  );
            parseContext._stack.push( _sizeof_var_eval );
        }
            }
#line 2950 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 188: // local_variable: "local" "(" string_constant ")"
#line 2451 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
        {
        if (!parseContext.test_modus)
        {
            std::string _string = parseContext.string_constants.top();
           parseContext.cube->get_cubepl_memory_manager()->register_variable( _string , CUBEPL_VARIABLE);
        }
        parseContext.syntax_ok &= true;
        }
#line 2963 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 189: // global_variable: "global" "(" string_constant ")"
#line 2460 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
        {
        if (!parseContext.test_modus)
        {
            std::string _string = parseContext.string_constants.top();
            parseContext.cube->get_cubepl_memory_manager()->register_variable( _string , CUBEPL_GLOBAL_VARIABLE);
        }
        parseContext.syntax_ok &= true;
        }
#line 2976 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 190: // print_statement: "print" "(" expression ")"
#line 2470 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
        {
        if (!parseContext.test_modus)
        {
            GeneralEvaluation * _expression = parseContext._stack.top();
            parseContext._stack.pop();
            PrintExpressionEvaluation * _print_expression = new PrintExpressionEvaluation(  _expression  );
            parseContext._statements.push( _print_expression );
        }
        parseContext.syntax_ok &= true;
        }
#line 2991 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;

  case 191: // string_constant: STRING_CONSTANT
#line 2482 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
        {
            if (!parseContext.test_modus)
            {
                parseContext.string_constants.push(parseContext.value);
                parseContext.value = "";
            }
            parseContext.syntax_ok &= true;
        }
#line 3004 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"
    break;


#line 3008 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"

            default:
              break;
            }
        }
#if YY_EXCEPTIONS
      catch (const syntax_error& yyexc)
        {
          YYCDEBUG << "Caught exception: " << yyexc.what() << '\n';
          error (yyexc);
          YYERROR;
        }
#endif // YY_EXCEPTIONS
      YY_SYMBOL_PRINT ("-> $$ =", yylhs);
      yypop_ (yylen);
      yylen = 0;

      // Shift the result of the reduction.
      yypush_ (YY_NULLPTR, YY_MOVE (yylhs));
    }
    goto yynewstate;


  /*--------------------------------------.
  | yyerrlab -- here on detecting error.  |
  `--------------------------------------*/
  yyerrlab:
    // If not already recovering from an error, report this error.
    if (!yyerrstatus_)
      {
        ++yynerrs_;
        context yyctx (*this, yyla);
        std::string msg = yysyntax_error_ (yyctx);
        error (yyla.location, YY_MOVE (msg));
      }


    yyerror_range[1].location = yyla.location;
    if (yyerrstatus_ == 3)
      {
        /* If just tried and failed to reuse lookahead token after an
           error, discard it.  */

        // Return failure if at end of input.
        if (yyla.kind () == symbol_kind::S_YYEOF)
          YYABORT;
        else if (!yyla.empty ())
          {
            yy_destroy_ ("Error: discarding", yyla);
            yyla.clear ();
          }
      }

    // Else will try to reuse lookahead token after shifting the error token.
    goto yyerrlab1;


  /*---------------------------------------------------.
  | yyerrorlab -- error raised explicitly by YYERROR.  |
  `---------------------------------------------------*/
  yyerrorlab:
    /* Pacify compilers when the user code never invokes YYERROR and
       the label yyerrorlab therefore never appears in user code.  */
    if (false)
      YYERROR;

    /* Do not reclaim the symbols of the rule whose action triggered
       this YYERROR.  */
    yypop_ (yylen);
    yylen = 0;
    YY_STACK_PRINT ();
    goto yyerrlab1;


  /*-------------------------------------------------------------.
  | yyerrlab1 -- common code for both syntax error and YYERROR.  |
  `-------------------------------------------------------------*/
  yyerrlab1:
    yyerrstatus_ = 3;   // Each real token shifted decrements this.
    // Pop stack until we find a state that shifts the error token.
    for (;;)
      {
        yyn = yypact_[+yystack_[0].state];
        if (!yy_pact_value_is_default_ (yyn))
          {
            yyn += symbol_kind::S_YYerror;
            if (0 <= yyn && yyn <= yylast_
                && yycheck_[yyn] == symbol_kind::S_YYerror)
              {
                yyn = yytable_[yyn];
                if (0 < yyn)
                  break;
              }
          }

        // Pop the current state because it cannot handle the error token.
        if (yystack_.size () == 1)
          YYABORT;

        yyerror_range[1].location = yystack_[0].location;
        yy_destroy_ ("Error: popping", yystack_[0]);
        yypop_ ();
        YY_STACK_PRINT ();
      }
    {
      stack_symbol_type error_token;

      yyerror_range[2].location = yyla.location;
      YYLLOC_DEFAULT (error_token.location, yyerror_range, 2);

      // Shift the error token.
      error_token.state = state_type (yyn);
      yypush_ ("Shifting", YY_MOVE (error_token));
    }
    goto yynewstate;


  /*-------------------------------------.
  | yyacceptlab -- YYACCEPT comes here.  |
  `-------------------------------------*/
  yyacceptlab:
    yyresult = 0;
    goto yyreturn;


  /*-----------------------------------.
  | yyabortlab -- YYABORT comes here.  |
  `-----------------------------------*/
  yyabortlab:
    yyresult = 1;
    goto yyreturn;


  /*-----------------------------------------------------.
  | yyreturn -- parsing is finished, return the result.  |
  `-----------------------------------------------------*/
  yyreturn:
    if (!yyla.empty ())
      yy_destroy_ ("Cleanup: discarding lookahead", yyla);

    /* Do not reclaim the symbols of the rule whose action triggered
       this YYABORT or YYACCEPT.  */
    yypop_ (yylen);
    YY_STACK_PRINT ();
    while (1 < yystack_.size ())
      {
        yy_destroy_ ("Cleanup: popping", yystack_[0]);
        yypop_ ();
      }

    return yyresult;
  }
#if YY_EXCEPTIONS
    catch (...)
      {
        YYCDEBUG << "Exception caught: cleaning lookahead and stack\n";
        // Do not try to display the values of the reclaimed symbols,
        // as their printers might throw an exception.
        if (!yyla.empty ())
          yy_destroy_ (YY_NULLPTR, yyla);

        while (1 < yystack_.size ())
          {
            yy_destroy_ (YY_NULLPTR, yystack_[0]);
            yypop_ ();
          }
        throw;
      }
#endif // YY_EXCEPTIONS
  }

  void
  CubePL1Parser::error (const syntax_error& yyexc)
  {
    error (yyexc.location, yyexc.what ());
  }

  /* Return YYSTR after stripping away unnecessary quotes and
     backslashes, so that it's suitable for yyerror.  The heuristic is
     that double-quoting is unnecessary unless the string contains an
     apostrophe, a comma, or backslash (other than backslash-backslash).
     YYSTR is taken from yytname.  */
  std::string
  CubePL1Parser::yytnamerr_ (const char *yystr)
  {
    if (*yystr == '"')
      {
        std::string yyr;
        char const *yyp = yystr;

        for (;;)
          switch (*++yyp)
            {
            case '\'':
            case ',':
              goto do_not_strip_quotes;

            case '\\':
              if (*++yyp != '\\')
                goto do_not_strip_quotes;
              else
                goto append;

            append:
            default:
              yyr += *yyp;
              break;

            case '"':
              return yyr;
            }
      do_not_strip_quotes: ;
      }

    return yystr;
  }

  std::string
  CubePL1Parser::symbol_name (symbol_kind_type yysymbol)
  {
    return yytnamerr_ (yytname_[yysymbol]);
  }



  // CubePL1Parser::context.
  CubePL1Parser::context::context (const CubePL1Parser& yyparser, const symbol_type& yyla)
    : yyparser_ (yyparser)
    , yyla_ (yyla)
  {}

  int
  CubePL1Parser::context::expected_tokens (symbol_kind_type yyarg[], int yyargn) const
  {
    // Actual number of expected tokens
    int yycount = 0;

    int yyn = yypact_[+yyparser_.yystack_[0].state];
    if (!yy_pact_value_is_default_ (yyn))
      {
        /* Start YYX at -YYN if negative to avoid negative indexes in
           YYCHECK.  In other words, skip the first -YYN actions for
           this state because they are default actions.  */
        int yyxbegin = yyn < 0 ? -yyn : 0;
        // Stay within bounds of both yycheck and yytname.
        int yychecklim = yylast_ - yyn + 1;
        int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
        for (int yyx = yyxbegin; yyx < yyxend; ++yyx)
          if (yycheck_[yyx + yyn] == yyx && yyx != symbol_kind::S_YYerror
              && !yy_table_value_is_error_ (yytable_[yyx + yyn]))
            {
              if (!yyarg)
                ++yycount;
              else if (yycount == yyargn)
                return 0;
              else
                yyarg[yycount++] = YY_CAST (symbol_kind_type, yyx);
            }
      }

    if (yyarg && yycount == 0 && 0 < yyargn)
      yyarg[0] = symbol_kind::S_YYEMPTY;
    return yycount;
  }



  int
  CubePL1Parser::yy_syntax_error_arguments_ (const context& yyctx,
                                                 symbol_kind_type yyarg[], int yyargn) const
  {
    /* There are many possibilities here to consider:
       - If this state is a consistent state with a default action, then
         the only way this function was invoked is if the default action
         is an error action.  In that case, don't check for expected
         tokens because there are none.
       - The only way there can be no lookahead present (in yyla) is
         if this state is a consistent state with a default action.
         Thus, detecting the absence of a lookahead is sufficient to
         determine that there is no unexpected or expected token to
         report.  In that case, just report a simple "syntax error".
       - Don't assume there isn't a lookahead just because this state is
         a consistent state with a default action.  There might have
         been a previous inconsistent state, consistent state with a
         non-default action, or user semantic action that manipulated
         yyla.  (However, yyla is currently not documented for users.)
       - Of course, the expected token list depends on states to have
         correct lookahead information, and it depends on the parser not
         to perform extra reductions after fetching a lookahead from the
         scanner and before detecting a syntax error.  Thus, state merging
         (from LALR or IELR) and default reductions corrupt the expected
         token list.  However, the list is correct for canonical LR with
         one exception: it will still contain any token that will not be
         accepted due to an error action in a later state.
    */

    if (!yyctx.lookahead ().empty ())
      {
        if (yyarg)
          yyarg[0] = yyctx.token ();
        int yyn = yyctx.expected_tokens (yyarg ? yyarg + 1 : yyarg, yyargn - 1);
        return yyn + 1;
      }
    return 0;
  }

  // Generate an error message.
  std::string
  CubePL1Parser::yysyntax_error_ (const context& yyctx) const
  {
    // Its maximum.
    enum { YYARGS_MAX = 5 };
    // Arguments of yyformat.
    symbol_kind_type yyarg[YYARGS_MAX];
    int yycount = yy_syntax_error_arguments_ (yyctx, yyarg, YYARGS_MAX);

    char const* yyformat = YY_NULLPTR;
    switch (yycount)
      {
#define YYCASE_(N, S)                         \
        case N:                               \
          yyformat = S;                       \
        break
      default: // Avoid compiler warnings.
        YYCASE_ (0, YY_("syntax error"));
        YYCASE_ (1, YY_("syntax error, unexpected %s"));
        YYCASE_ (2, YY_("syntax error, unexpected %s, expecting %s"));
        YYCASE_ (3, YY_("syntax error, unexpected %s, expecting %s or %s"));
        YYCASE_ (4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
        YYCASE_ (5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
#undef YYCASE_
      }

    std::string yyres;
    // Argument number.
    std::ptrdiff_t yyi = 0;
    for (char const* yyp = yyformat; *yyp; ++yyp)
      if (yyp[0] == '%' && yyp[1] == 's' && yyi < yycount)
        {
          yyres += symbol_name (yyarg[yyi++]);
          ++yyp;
        }
      else
        yyres += *yyp;
    return yyres;
  }


  const short CubePL1Parser::yypact_ninf_ = -260;

  const signed char CubePL1Parser::yytable_ninf_ = -1;

  const short
  CubePL1Parser::yypact_[] =
  {
       6,   403,    18,  -260,   555,   555,  -260,    39,    50,   555,
    -260,  -260,  -260,  -260,  -260,  -260,  -260,  -260,  -260,  -260,
    -260,  -260,  -260,  -260,  -260,  -260,  -260,  -260,  -260,  -260,
      19,   -48,   -33,   -26,    59,    64,    73,    -7,   107,   128,
     141,   142,   164,  -260,  -260,   236,  -260,  -260,  -260,  -260,
    -260,  -260,  -260,  -260,  -260,  -260,  -260,  -260,  -260,  -260,
    -260,  -260,  -260,  -260,  -260,  -260,  -260,  -260,  -260,   165,
    -260,   166,  -260,  -260,  -260,  -260,  -260,  -260,     2,  -260,
    -260,  -260,  -260,  -260,  -260,    36,   444,    58,    58,   148,
      58,   173,   180,   188,   555,   555,   555,   190,   555,   555,
     555,   555,   555,  -260,   555,   555,   555,   555,   555,   555,
     555,   192,   194,   195,   197,   198,   155,    95,   115,   130,
     133,   185,   187,   284,   301,   302,   304,   305,   275,   290,
    -260,  -260,  -260,  -260,  -260,   303,  -260,  -260,   266,  -260,
    -260,  -260,  -260,  -260,  -260,  -260,  -260,  -260,  -260,  -260,
    -260,  -260,  -260,  -260,  -260,  -260,  -260,  -260,   308,   309,
    -260,   306,    24,    31,   555,   451,   458,   520,   223,     7,
      23,    47,   125,   135,    36,    36,   315,   315,  -260,   528,
     140,    58,    58,   555,   479,   479,    58,   310,   317,   310,
     310,   310,   319,   555,   555,   555,   555,   555,   555,   326,
       2,  -260,   -25,     2,   555,  -260,  -260,   313,  -260,  -260,
    -260,  -260,     9,  -260,    16,   172,  -260,  -260,  -260,    25,
     223,   223,   223,   223,   223,  -260,   555,   332,   334,   596,
     479,   320,  -260,  -260,   179,    10,  -260,  -260,  -260,  -260,
    -260,  -260,  -260,  -260,  -260,  -260,  -260,  -260,  -260,  -260,
    -260,  -260,    75,   327,   253,  -260,   -39,  -260,  -260,  -260,
     223,   213,   242,   247,   252,   257,   365,  -260,  -260,   337,
     303,   300,   316,  -260,   335,   472,   555,  -260,   -58,  -260,
     -58,   -58,  -260,   555,   285,   286,   296,   311,   312,   603,
    -260,  -260,  -260,   159,   212,   479,   555,   555,   555,   555,
     555,   555,   555,   555,   265,  -260,   479,   479,   479,   303,
     354,  -260,  -260,   357,   358,   325,   223,   223,   223,   223,
     223,  -260,   479,  -260,  -260,  -260,  -260,   381,   364,   374,
      30,   610,   555,   555,   555,   555,   555,  -260,  -260,   216,
     472,   472,   472,   472,   472,   472,   472,   472,  -260,  -260,
    -260,  -260,  -260,  -260,   555,   310,   310,   223,   329,   330,
     333,   342,   344,   299,  -260,  -260,  -260,  -260,   555,  -260,
     642,   650,   657,   664,   671,  -260,   413,  -260,  -260,    48,
     555,   555,   555,   555,   555,   303,   262,  -260,  -260,  -260,
    -260,  -260,  -260,  -260,   555,   278,   283,   298,   331,   349,
    -260,   -58,   678,   555,   555,   555,   555,   555,   387,  -260,
     685,   692,   699,   706,   713,  -260,  -260,  -260,  -260,  -260,
    -260
  };

  const unsigned char
  CubePL1Parser::yydefact_[] =
  {
       0,     0,     0,     3,     0,     0,   125,     0,     0,     0,
      37,    38,    89,    90,    91,    92,    93,    96,    97,    94,
      95,    99,    98,   100,   101,   102,   103,   104,   106,   107,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   108,    72,     0,     4,     5,     6,     7,
       8,     9,    10,    11,    18,    35,    36,    20,    21,    73,
      74,    75,    22,    23,    24,    25,    26,    12,    86,     0,
      87,     0,    13,    14,   109,   110,   111,    15,   126,    19,
     182,   183,    16,    17,     1,    34,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     2,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     128,   143,   144,   146,   145,     0,   129,   130,     0,   160,
     161,   139,   164,   165,   166,   134,   135,   136,   137,   138,
     140,   141,   142,   131,   132,   133,    27,   191,     0,     0,
      28,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    29,    30,    32,    31,    33,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     126,   157,   147,   126,     0,   186,   187,   184,   112,   120,
     121,   122,     0,   115,     0,     0,    78,    76,    77,     0,
       0,     0,     0,     0,     0,    88,     0,     0,     0,     0,
       0,     0,    57,    58,     0,     0,    39,    46,    47,    48,
      49,    50,    40,    41,    42,    43,    44,    45,    51,    65,
      66,    67,     0,     0,     0,   167,     0,   179,   180,   181,
       0,     0,     0,     0,     0,     0,     0,   123,   127,     0,
       0,   150,   151,   148,     0,   159,     0,   113,     0,   116,
       0,     0,    79,     0,     0,     0,     0,     0,     0,     0,
     188,   189,   190,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   154,     0,     0,     0,     0,
     162,   178,   170,     0,     0,     0,     0,     0,     0,     0,
       0,   124,     0,   155,   149,   152,   156,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   105,    52,     0,
      61,    59,    68,    69,    63,    64,    60,    62,    71,    70,
      54,    55,    56,   158,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   185,   114,   117,   118,     0,    80,
       0,     0,     0,     0,     0,    53,     0,   168,   169,     0,
       0,     0,     0,     0,     0,     0,     0,    81,    82,    83,
      84,    85,   163,   171,     0,     0,     0,     0,     0,     0,
     153,     0,     0,     0,     0,     0,     0,     0,     0,   172,
       0,     0,     0,     0,     0,   119,   173,   174,   175,   176,
     177
  };

  const short
  CubePL1Parser::yypgoto_[] =
  {
    -260,  -260,    -1,  -260,  -260,  -260,  -260,  -260,  -260,  -260,
    -260,  -260,  -260,  -260,  -183,  -260,  -260,  -260,  -260,  -260,
    -260,  -260,  -260,  -260,  -260,  -260,  -260,  -260,  -260,  -260,
    -260,  -260,  -158,  -260,  -260,  -260,  -260,  -260,  -260,  -260,
    -260,  -260,  -260,  -260,  -260,  -260,  -260,  -260,  -260,  -260,
    -260,  -260,  -162,  -260,  -260,  -260,  -166,  -260,  -260,  -260,
    -260,  -260,  -260,   104,  -260,  -260,   121,  -259,  -260,  -260,
    -260,  -260,  -260,  -260,  -260,  -260,  -260,  -260,  -184,  -260,
    -260,  -260,  -260,  -260,  -260,  -260,  -260,  -260,  -260,  -260,
    -260,  -260,  -260,  -260,  -260,  -260,   -71
  };

  const short
  CubePL1Parser::yydefgoto_[] =
  {
      -1,     2,   234,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,    56,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,   249,   250,
     251,   349,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,   212,    77,   199,    78,   128,   129,   130,   131,
     132,   133,   134,   271,   272,   135,   273,   202,   203,   136,
     137,   138,   139,   140,   141,   142,   143,   144,   255,   145,
     146,   147,   148,   149,   312,   150,   151,   152,    79,    80,
      81,    82,    83,   153,   154,   155,   158
  };

  const short
  CubePL1Parser::yytable_[] =
  {
      45,   214,   252,    85,    86,   257,   258,   259,    89,     1,
     219,   323,   104,   105,   106,   107,   108,   159,    84,   161,
     277,   305,   269,   270,   111,   112,   113,   279,   104,   105,
     106,   107,   108,    90,   268,   208,   282,   274,   209,   210,
     211,   367,   213,   106,   107,   108,    91,   294,   114,    87,
     353,   115,   104,   105,   106,   107,   108,   313,   314,   393,
      88,    92,   284,   285,   286,   287,   288,   116,    93,    94,
     306,   307,   308,   220,    95,   278,   117,   118,   119,   120,
     121,   122,   280,    96,   123,   124,   309,    97,   125,   221,
     126,   283,   127,   165,   166,   167,   368,   169,   170,   171,
     172,   173,   315,   174,   175,   176,   177,   178,   179,   180,
     227,   228,   339,   222,   394,   253,   328,    98,   329,   330,
     209,   210,   211,   350,   351,   352,   400,   209,   210,   211,
     104,   105,   106,   107,   108,   306,   307,   308,    99,   363,
     104,   105,   106,   107,   108,   104,   105,   106,   107,   108,
     157,   100,   101,   104,   105,   106,   107,   108,   358,   359,
     360,   361,   362,   215,   104,   105,   106,   107,   108,   186,
     156,   377,   378,   160,   102,   109,   110,   104,   105,   106,
     107,   108,   229,   162,   104,   105,   106,   107,   108,   187,
     163,   223,   261,   262,   263,   264,   265,   266,   164,   379,
     168,   224,   181,   275,   182,   183,   226,   184,   185,   188,
     296,   297,   298,   299,   300,   301,   302,   303,   104,   105,
     106,   107,   108,   338,   189,   289,   304,   375,   190,   293,
     296,   297,   298,   299,   300,   301,   302,   303,   281,   408,
     103,   104,   105,   106,   107,   108,   304,   104,   105,   106,
     107,   108,   104,   105,   106,   107,   108,   104,   105,   106,
     107,   108,   104,   105,   106,   107,   108,   104,   105,   106,
     107,   108,   306,   307,   308,   327,   306,   307,   308,   316,
     191,   192,   331,   104,   105,   106,   107,   108,   104,   105,
     106,   107,   108,   198,   193,   340,   341,   342,   343,   344,
     345,   346,   347,   104,   105,   106,   107,   108,   317,   200,
     385,   194,   195,   318,   196,   197,   204,   201,   319,   205,
     206,   207,    44,   320,   108,   276,   254,   256,   401,   260,
     295,   370,   371,   372,   373,   374,   104,   105,   106,   107,
     108,   267,   310,   290,   403,   291,   311,   322,   270,   404,
     326,   332,   333,   376,   104,   105,   106,   107,   108,   306,
     307,   308,   334,   269,   405,   348,   354,   386,   355,   356,
     104,   105,   106,   107,   108,   365,   325,   335,   336,   395,
     396,   397,   398,   399,   321,   366,   104,   105,   106,   107,
     108,   357,   324,   402,   364,   380,   381,   406,   415,   382,
       0,     0,   410,   411,   412,   413,   414,     3,   383,     4,
     384,     0,     0,     5,     0,   407,     0,     6,   104,   105,
     106,   107,   108,     7,     8,     0,   392,     0,     9,    10,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,   104,
     105,   106,   107,   108,     0,   156,   104,   105,   106,   107,
     108,     0,   216,   104,   105,   106,   107,   108,    30,   217,
       0,    31,    32,    33,    34,    35,    36,   104,   105,   106,
     107,   108,     0,    37,    38,     4,    39,     0,    40,   230,
      41,     0,    42,     6,    43,     0,     0,     0,     0,     7,
       8,     0,    44,     0,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,   104,   105,   106,   107,   108,
       0,   218,     0,   104,   105,   106,   107,   108,   231,   225,
       0,     0,   232,   233,    30,     0,     0,    31,    32,    33,
      34,    35,    36,     0,     0,     0,     0,     0,     0,    37,
      38,     4,    39,     0,    40,     5,    41,     0,    42,     6,
      43,     0,     0,     0,     0,     7,     8,     0,    44,     0,
       9,    10,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      29,   104,   105,   106,   107,   108,     0,   292,   104,   105,
     106,   107,   108,     0,   337,   104,   105,   106,   107,   108,
      30,   369,     0,    31,    32,    33,    34,    35,    36,     0,
       0,     0,     0,     0,     0,    37,    38,     0,    39,     0,
      40,     0,    41,     0,    42,     0,    43,   104,   105,   106,
     107,   108,     0,   387,    44,   104,   105,   106,   107,   108,
       0,   388,   104,   105,   106,   107,   108,     0,   389,   104,
     105,   106,   107,   108,     0,   390,   104,   105,   106,   107,
     108,     0,   391,   104,   105,   106,   107,   108,     0,   409,
     104,   105,   106,   107,   108,     0,   416,   104,   105,   106,
     107,   108,     0,   417,   104,   105,   106,   107,   108,     0,
     418,   104,   105,   106,   107,   108,     0,   419,   104,   105,
     106,   107,   108,     0,   420
  };

  const short
  CubePL1Parser::yycheck_[] =
  {
       1,   163,   185,     4,     5,   189,   190,   191,     9,     3,
     168,   270,     5,     6,     7,     8,     9,    88,     0,    90,
      11,    11,    47,    48,    22,    23,    24,    11,     5,     6,
       7,     8,     9,    14,   200,    11,    11,   203,    96,    97,
      98,    11,    11,     7,     8,     9,    94,   230,    46,    10,
     309,    49,     5,     6,     7,     8,     9,    96,    97,    11,
      10,    94,   220,   221,   222,   223,   224,    65,    94,    10,
      60,    61,    62,    66,    10,    66,    74,    75,    76,    77,
      78,    79,    66,    10,    82,    83,    11,    94,    86,    66,
      88,    66,    90,    94,    95,    96,    66,    98,    99,   100,
     101,   102,   260,   104,   105,   106,   107,   108,   109,   110,
     181,   182,   295,    66,    66,   186,   278,    10,   280,   281,
      96,    97,    98,   306,   307,   308,   385,    96,    97,    98,
       5,     6,     7,     8,     9,    60,    61,    62,    10,   322,
       5,     6,     7,     8,     9,     5,     6,     7,     8,     9,
      92,    10,    10,     5,     6,     7,     8,     9,   316,   317,
     318,   319,   320,   164,     5,     6,     7,     8,     9,    14,
      11,   355,   356,    25,    10,    10,    10,     5,     6,     7,
       8,     9,   183,    10,     5,     6,     7,     8,     9,    94,
      10,    66,   193,   194,   195,   196,   197,   198,    10,   357,
      10,    66,    10,   204,    10,    10,    66,    10,    10,    94,
      51,    52,    53,    54,    55,    56,    57,    58,     5,     6,
       7,     8,     9,    11,    94,   226,    67,    11,    95,   230,
      51,    52,    53,    54,    55,    56,    57,    58,    66,   401,
       4,     5,     6,     7,     8,     9,    67,     5,     6,     7,
       8,     9,     5,     6,     7,     8,     9,     5,     6,     7,
       8,     9,     5,     6,     7,     8,     9,     5,     6,     7,
       8,     9,    60,    61,    62,   276,    60,    61,    62,    66,
      95,    94,   283,     5,     6,     7,     8,     9,     5,     6,
       7,     8,     9,    18,    10,   296,   297,   298,   299,   300,
     301,   302,   303,     5,     6,     7,     8,     9,    66,    19,
      11,    10,    10,    66,    10,    10,    50,    14,    66,    11,
      11,    15,    99,    66,     9,    12,    16,    10,    66,    10,
      10,   332,   333,   334,   335,   336,     5,     6,     7,     8,
       9,    15,    15,    11,    66,    11,    93,    10,    48,    66,
      15,    66,    66,   354,     5,     6,     7,     8,     9,    60,
      61,    62,    66,    47,    66,   100,    12,   368,    11,    11,
       5,     6,     7,     8,     9,    11,   272,    66,    66,   380,
     381,   382,   383,   384,    19,    11,     5,     6,     7,     8,
       9,    66,   271,   394,    13,    66,    66,    66,    11,    66,
      -1,    -1,   403,   404,   405,   406,   407,     4,    66,     6,
      66,    -1,    -1,    10,    -1,    66,    -1,    14,     5,     6,
       7,     8,     9,    20,    21,    -1,    13,    -1,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    35,    36,
      37,    38,    39,    40,    41,    42,    43,    44,    45,     5,
       6,     7,     8,     9,    -1,    11,     5,     6,     7,     8,
       9,    -1,    11,     5,     6,     7,     8,     9,    65,    11,
      -1,    68,    69,    70,    71,    72,    73,     5,     6,     7,
       8,     9,    -1,    80,    81,     6,    83,    -1,    85,    10,
      87,    -1,    89,    14,    91,    -1,    -1,    -1,    -1,    20,
      21,    -1,    99,    -1,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    42,    43,    44,    45,     5,     6,     7,     8,     9,
      -1,    11,    -1,     5,     6,     7,     8,     9,    59,    11,
      -1,    -1,    63,    64,    65,    -1,    -1,    68,    69,    70,
      71,    72,    73,    -1,    -1,    -1,    -1,    -1,    -1,    80,
      81,     6,    83,    -1,    85,    10,    87,    -1,    89,    14,
      91,    -1,    -1,    -1,    -1,    20,    21,    -1,    99,    -1,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,     5,     6,     7,     8,     9,    -1,    11,     5,     6,
       7,     8,     9,    -1,    11,     5,     6,     7,     8,     9,
      65,    11,    -1,    68,    69,    70,    71,    72,    73,    -1,
      -1,    -1,    -1,    -1,    -1,    80,    81,    -1,    83,    -1,
      85,    -1,    87,    -1,    89,    -1,    91,     5,     6,     7,
       8,     9,    -1,    11,    99,     5,     6,     7,     8,     9,
      -1,    11,     5,     6,     7,     8,     9,    -1,    11,     5,
       6,     7,     8,     9,    -1,    11,     5,     6,     7,     8,
       9,    -1,    11,     5,     6,     7,     8,     9,    -1,    11,
       5,     6,     7,     8,     9,    -1,    11,     5,     6,     7,
       8,     9,    -1,    11,     5,     6,     7,     8,     9,    -1,
      11,     5,     6,     7,     8,     9,    -1,    11,     5,     6,
       7,     8,     9,    -1,    11
  };

  const unsigned char
  CubePL1Parser::yystos_[] =
  {
       0,     3,   104,     4,     6,    10,    14,    20,    21,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    42,    43,    44,    45,
      65,    68,    69,    70,    71,    72,    73,    80,    81,    83,
      85,    87,    89,    91,    99,   105,   106,   107,   108,   109,
     110,   111,   112,   113,   114,   115,   116,   135,   136,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,   151,   152,   153,   154,   156,   158,   191,
     192,   193,   194,   195,     0,   105,   105,    10,    10,   105,
      14,    94,    94,    94,    10,    10,    10,    94,    10,    10,
      10,    10,    10,     4,     5,     6,     7,     8,     9,    10,
      10,    22,    23,    24,    46,    49,    65,    74,    75,    76,
      77,    78,    79,    82,    83,    86,    88,    90,   159,   160,
     161,   162,   163,   164,   165,   168,   172,   173,   174,   175,
     176,   177,   178,   179,   180,   182,   183,   184,   185,   186,
     188,   189,   190,   196,   197,   198,    11,    92,   199,   199,
      25,   199,    10,    10,    10,   105,   105,   105,    10,   105,
     105,   105,   105,   105,   105,   105,   105,   105,   105,   105,
     105,    10,    10,    10,    10,    10,    14,    94,    94,    94,
      95,    95,    94,    10,    10,    10,    10,    10,    18,   157,
      19,    14,   170,   171,    50,    11,    11,    15,    11,    96,
      97,    98,   155,    11,   155,   105,    11,    11,    11,   135,
      66,    66,    66,    66,    66,    11,    66,   199,   199,   105,
      10,    59,    63,    64,   105,   117,   118,   119,   120,   121,
     122,   123,   124,   125,   126,   127,   128,   129,   130,   131,
     132,   133,   117,   199,    16,   181,    10,   181,   181,   181,
      10,   105,   105,   105,   105,   105,   105,    15,   159,    47,
      48,   166,   167,   169,   159,   105,    12,    11,    66,    11,
      66,    66,    11,    66,   135,   135,   135,   135,   135,   105,
      11,    11,    11,   105,   117,    10,    51,    52,    53,    54,
      55,    56,    57,    58,    67,    11,    60,    61,    62,    11,
      15,    93,   187,    96,    97,   135,    66,    66,    66,    66,
      66,    19,    10,   170,   169,   166,    15,   105,   155,   155,
     155,   105,    66,    66,    66,    66,    66,    11,    11,   117,
     105,   105,   105,   105,   105,   105,   105,   105,   100,   134,
     117,   117,   117,   170,    12,    11,    11,    66,   135,   135,
     135,   135,   135,   117,    13,    11,    11,    11,    66,    11,
     105,   105,   105,   105,   105,    11,   105,   181,   181,   135,
      66,    66,    66,    66,    66,    11,   105,    11,    11,    11,
      11,    11,    13,    11,    66,   105,   105,   105,   105,   105,
     170,    66,   105,    66,    66,    66,    66,    66,   155,    11,
     105,   105,   105,   105,   105,    11,    11,    11,    11,    11,
      11
  };

  const unsigned char
  CubePL1Parser::yyr1_[] =
  {
       0,   103,   104,   104,   105,   105,   105,   105,   105,   105,
     105,   105,   105,   105,   105,   105,   105,   105,   105,   105,
     105,   105,   105,   105,   105,   105,   105,   106,   107,   108,
     109,   110,   111,   112,   113,   114,   114,   115,   116,   117,
     117,   117,   117,   117,   117,   117,   117,   117,   117,   117,
     117,   117,   118,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   130,   130,   131,   132,
     133,   134,   135,   136,   136,   136,   137,   138,   139,   140,
     141,   142,   143,   144,   144,   144,   145,   145,   146,   147,
     147,   147,   147,   147,   147,   147,   147,   147,   147,   147,
     147,   147,   147,   147,   147,   148,   149,   149,   150,   151,
     151,   151,   152,   152,   152,   153,   153,   153,   154,   154,
     155,   155,   155,   156,   157,   158,   159,   159,   160,   160,
     160,   160,   160,   160,   160,   160,   160,   160,   160,   160,
     160,   160,   160,   161,   161,   161,   161,   162,   163,   164,
     165,   166,   166,   167,   168,   169,   170,   171,   172,   173,
     174,   174,   175,   176,   177,   177,   177,   178,   179,   180,
     181,   182,   183,   184,   185,   186,   186,   186,   187,   188,
     189,   190,   191,   191,   192,   193,   194,   195,   196,   197,
     198,   199
  };

  const signed char
  CubePL1Parser::yyr2_[] =
  {
       0,     2,     3,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     3,     3,     3,
       3,     3,     3,     3,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     3,     4,     3,     3,     3,     1,     1,     3,
       3,     3,     3,     3,     3,     1,     1,     1,     3,     3,
       3,     1,     1,     1,     1,     1,     4,     4,     4,     5,
       7,     8,     8,     8,     8,     8,     1,     1,     4,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     6,     1,     1,     1,     1,
       1,     1,     4,     5,     7,     4,     5,     7,     7,    11,
       1,     1,     1,     4,     3,     1,     0,     3,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     2,     3,     4,
       3,     1,     2,     5,     4,     2,     3,     1,     5,     3,
       1,     1,     4,     7,     1,     1,     1,     3,     6,     6,
       2,     7,     9,    10,    10,    10,    10,    10,     1,     3,
       3,     3,     1,     1,     4,     7,     4,     4,     4,     4,
       4,     1
  };


#if CUBEPLPARSERDEBUG || 1
  // YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
  // First, the terminals, then, starting at \a YYNTOKENS, nonterminals.
  const char*
  const CubePL1Parser::yytname_[] =
  {
  "\"end of file\"", "error", "\"invalid token\"", "\"<cubepl>\"",
  "\"</cubepl>\"", "\"+\"", "\"-\"", "\"*\"", "\"/\"", "\"^\"", "\"(\"",
  "\")\"", "\"[\"", "\"]\"", "\"{\"", "\"}\"", "\"<<\"", "\">>\"",
  "\"return\"", "\";\"", "\"sizeof\"", "\"defined\"", "\"local\"",
  "\"global\"", "\"print\"", "\"|\"", "\"arg1\"", "\"arg2\"", "\"sqrt\"",
  "\"sin\"", "\"asin\"", "\"cos\"", "\"acos\"", "\"tan\"", "\"atan\"",
  "\"exp\"", "\"log\"", "\"abs\"", "\"random\"", "\"sgn\"", "\"pos\"",
  "\"neg\"", "\"floor\"", "\"ceil\"", "\"min\"", "\"max\"", "\"if\"",
  "\"elseif\"", "\"else\"", "\"while\"", "\"=\"", "\">\"", "\"==\"",
  "\"eq\"", "\"seq\"", "\">=\"", "\"<=\"", "\"!=\"", "\"<\"", "\"not\"",
  "\"and\"", "\"or\"", "\"xor\"", "\"true\"", "\"false\"", "\"$\"",
  "\",\"", "\"=~\"", "\"metric::\"", "\"metric::fixed::\"",
  "\"metric::call::\"", "\"env\"", "\"lowercase\"", "\"uppercase\"",
  "\"cube::metric::postderived::\"", "\"cube::metric::prederived::\"",
  "\"cube::init::metric::\"", "\"cube::metric::plus::\"",
  "\"cube::metric::minus::\"", "\"cube::metric::set::\"",
  "\"cube::metric::get::\"", "\"cube::callpath::get\"",
  "\"cube::callpath::set\"", "\"cube::region::get\"",
  "\"cube::region::set\"", "\"cube::stn::get\"", "\"cube::stn::set\"",
  "\"cube::locationgroup::get\"", "\"cube::locationgroup::set\"",
  "\"cube::location::get\"", "\"cube::location::set\"", "CONSTANT",
  "STRING_CONSTANT", "STRING_TEXT", "METRIC_NAME", "INIT_METRIC_NAME",
  "\"i\"", "\"e\"", "SAME_MODIFICATOR", "QUOTED_STRING", "REGEXP_STRING",
  "FUNC2", "SIGN", "$accept", "document", "expression",
  "enclosed_expression", "absolute_value", "sum", "subtract", "division",
  "multiplication", "power", "negation", "arguments", "argument1",
  "argument2", "boolean_expression", "enclosed_boolean_expression",
  "and_expression", "or_expression", "xor_expression", "true_expression",
  "false_expression", "equality", "not_equality", "bigger", "smaller",
  "halfbigger", "halfsmaller", "string_operation", "string_equality",
  "string_semi_equality", "regexp", "regexp_expression", "quoted_string",
  "string_function", "lowercase", "uppercase", "getenv", "metric_get",
  "metric_get_ext", "callpath_get", "region_get", "sysres_get",
  "function_call", "one_variable_function", "function_name",
  "two_variables_function", "function2_name", "constant", "metric_refs",
  "context_metric", "fixed_metric", "metric_call",
  "calculationFlavourModificator", "lambda_calcul", "return_expression",
  "lambda_start", "list_of_statements", "statement", "if_statement",
  "simple_if_statement", "full_if_statement", "elseif_full_if_statement",
  "elseif_if_statement", "elseifs", "elseif_enclosed_list_of_statements",
  "if_condition", "else_enclosed_list_of_statements",
  "enclosed_list_of_statements", "enclosed_list_of_statements_start",
  "while_statement", "assignment", "assignment_target", "put_variable",
  "put_variable_indexed", "create_ghost_metric",
  "create_postderived_ghost_metric",
  "create_prederived_inclusive_ghost_metric",
  "create_prederived_exclusive_ghost_metric", "GhostMetricDefinition",
  "metric_set", "metric_set_ext", "callpath_set", "region_set",
  "sysres_set", "CubePLGhostText", "init_metric", "flex_aggr_plus",
  "flex_aggr_minus", "get_variable", "get_variable_simple",
  "get_variable_indexed", "sizeof_variable", "defined_variable",
  "local_variable", "global_variable", "print_statement",
  "string_constant", YY_NULLPTR
  };
#endif


#if CUBEPLPARSERDEBUG
  const short
  CubePL1Parser::yyrline_[] =
  {
       0,   335,   335,   344,   351,   352,   353,   354,   355,   356,
     357,   358,   359,   360,   361,   362,   363,   364,   365,   366,
     367,   368,   369,   370,   371,   372,   373,   377,   387,   400,
     413,   427,   440,   456,   468,   480,   480,   482,   491,   503,
     504,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   519,   529,   540,   553,   567,   580,   588,   597,
     611,   625,   638,   652,   666,   682,   683,   684,   689,   702,
     714,   729,   757,   768,   768,   768,   773,   784,   796,   810,
     837,   867,   883,   901,   902,   903,   919,   919,   921,   936,
     944,   952,   960,   968,   976,   984,   992,  1000,  1008,  1016,
    1024,  1032,  1040,  1048,  1056,  1067,  1083,  1091,  1102,  1113,
    1113,  1113,  1118,  1146,  1179,  1222,  1250,  1291,  1346,  1400,
    1477,  1485,  1493,  1504,  1534,  1536,  1545,  1547,  1553,  1564,
    1575,  1586,  1590,  1594,  1605,  1616,  1628,  1639,  1651,  1663,
    1667,  1671,  1675,  1687,  1688,  1689,  1690,  1694,  1721,  1760,
    1803,  1836,  1837,  1840,  1850,  1853,  1856,  1859,  1869,  1898,
    1915,  1915,  1918,  1928,  1932,  1933,  1934,  1938,  1992,  2045,
    2100,  2106,  2133,  2165,  2186,  2207,  2225,  2243,  2262,  2268,
    2307,  2346,  2387,  2400,  2415,  2424,  2428,  2440,  2450,  2459,
    2469,  2481
  };

  void
  CubePL1Parser::yy_stack_print_ () const
  {
    *yycdebug_ << "Stack now";
    for (stack_type::const_iterator
           i = yystack_.begin (),
           i_end = yystack_.end ();
         i != i_end; ++i)
      *yycdebug_ << ' ' << int (i->state);
    *yycdebug_ << '\n';
  }

  void
  CubePL1Parser::yy_reduce_print_ (int yyrule) const
  {
    int yylno = yyrline_[yyrule];
    int yynrhs = yyr2_[yyrule];
    // Print the symbols being reduced, and their result.
    *yycdebug_ << "Reducing stack by rule " << yyrule - 1
               << " (line " << yylno << "):\n";
    // The symbols being reduced.
    for (int yyi = 0; yyi < yynrhs; yyi++)
      YY_SYMBOL_PRINT ("   $" << yyi + 1 << " =",
                       yystack_[(yynrhs) - (yyi + 1)]);
  }
#endif // CUBEPLPARSERDEBUG

  CubePL1Parser::symbol_kind_type
  CubePL1Parser::yytranslate_ (int t)
  {
    // YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to
    // TOKEN-NUM as returned by yylex.
    static
    const signed char
    translate_table[] =
    {
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
      91,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
      92,     2,     2,     2,     2,     2,     2,     2,     2,     2,
      93,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
      94,    95,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
      99,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     100,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
      98,     2,     3,     4,     5,     6,     7,     8,     9,    10,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    42,    43,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      96,    97,   101,   102
    };
    // Last valid token kind.
    const int code_max = 693;

    if (t <= 0)
      return symbol_kind::S_YYEOF;
    else if (t <= code_max)
      return YY_CAST (symbol_kind_type, translate_table[t]);
    else
      return symbol_kind::S_YYUNDEF;
  }

} // cubeplparser
#line 3950 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.cpp"

#line 2491 "../../cubelib/build-frontend/../src/cube/src/syntax/cubepl/CubePL1Parser.yy"
 /*** Additional Code ***/


void cubeplparser::CubePL1Parser::error(const CubePL1Parser::location_type& l,
                                  const std::string& m)
{

    CubePL1Parser::location_type _l = l;


    _l.end.column = (_l.end.column<9)?1: _l.end.column-8;
    _l.begin.column = _l.end.column-1;

    parseContext.syntax_ok = false;
    stringstream sstr;
    string       str;
    sstr << _l;
    sstr >> str;
    parseContext.error_message = str + ":" + m;
    parseContext.error_place = _l;

/*   if (strstr(m.c_str(),"expecting <?xml")!=NULL) {
     driver.error_just_message("The cube file is probably empty or filled with wrong content. The file has ended before the header of cube started. \n");
    }
   if (strstr(m.c_str()," expecting </row>")!=NULL) {
     driver.error_just_message("One of the possible reasons is \n    1) that the severity value is malformed. CUBE expects the \"double\" value in C_LOCALE with dot instead of comma;. \n    2) that the CUBE file is not properly ended. Probably the writing of CUBE file was interrupted.");
    }
   if (strstr(m.c_str()," expecting <matrix")!=NULL ||
        (strstr(m.c_str()," expecting <severity>")!=NULL) ) {
     driver.error_just_message("The cube file has probably a proper structure, but doesn't contain any severity values.");
    }
   if (strstr(m.c_str()," expecting <metric")!=NULL) {
     driver.error_just_message("The cube file doesn't contain any information about metric dimension.");
    }
   if (strstr(m.c_str()," expecting <region")!=NULL) {
     driver.error_just_message("The cube file doesn't contain any information about program dimension.");
    }
   if (strstr(m.c_str()," expecting <machine")!=NULL) {
     driver.error_just_message("The cube file doesn't contain any information about system dimension.");
    }
   if (strstr(m.c_str()," expecting <thread")!=NULL) {
     driver.error_just_message("The system dimension of the cube file is malformed. It contains a process without any threads.");
    }
   if (strstr(m.c_str()," expecting <process")!=NULL) {
     driver.error_just_message("The system dimension of the cube file is malformed. It contains a node without any processes.");
    }
   if (strstr(m.c_str()," expecting <node")!=NULL) {
     driver.error_just_message("The system dimension of the cube file is malformed. It contains a machine without any computing nodes.");
    }
      driver.error(l, m);
*/
}
