/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2023-2024                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBE_CRITICAL_SECTION
#define CUBE_CRITICAL_SECTION
// RAII wrapper, make on of these in your 'work-doing' class to
// lock the critical section. once it goes out of scope the
// critical section is unlocked
// Note: If you can use C++ 17, use a std::scoped_lock(SemaphoreRef)
//       instead of this class

#include "CubeSemaphore.h"
namespace cube
{
class CubeCriticalSection
{
public:
    explicit
    CubeCriticalSection( cube::CubeSemaphore& s ) : semaphore( s )
    {
        semaphore.lock();
    }
    ~CubeCriticalSection()
    {
        semaphore.unlock();
    }
private:
    CubeSemaphore& semaphore;
};
};

#endif
