/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2023                                                     **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#include "ServerPlugin.h"
#include <iostream>
#include <fstream>
#include <string>

using namespace std;
using namespace cube;

const char*
ServerPluginExample::name() const
{
    return "ClientServerDemoPlugin"; // this name is used by the client to identify the server plugin
}

std::vector<unsigned char>
ServerPluginExample::send( const std::vector<unsigned char>& dataFromClient,
                           cube::CubeProxy*                   )
{
    std::vector<unsigned char> source;
    string                     line;

    std::string stringFromClient { dataFromClient.begin(), dataFromClient.end() };

    cout << "ServerPluginExample:: received from client: " << stringFromClient;

    stringFromClient = "From client: " + stringFromClient + "\nFrom server: This text been added by the server plugin.";

    std::vector<unsigned char> messageFromServer( stringFromClient.begin(), stringFromClient.end() );

    return messageFromServer;
}
