/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2023                                                     **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#include <vector>
#include "CubeServerPlugin.h"

namespace cube
{
class CubeProxy;
}

/**
 * @brief The ServerPluginExample class shows the usage of server side plugins. It is called by the
 * corresponding client side plugin.
 * The server searches for plugins in the directories given by the environment variable PLUGIN_PATH
 */
class ServerPluginExample : public cube::CubeServerPlugin
{
public:
    /* used by the client to identify the server plugin */
    virtual const char*
    name() const override;

    /* used by the server api to send data to the plugin and receive an answer, which is send to the client plugin */
    std::vector<unsigned char>
    send( const std::vector<unsigned char>& dataFromClient,
          cube::CubeProxy*                    ) override;
};

// the class factories which are required to create a plugin

extern "C" cube::CubeServerPlugin * create()
{
    return new ServerPluginExample();
}

extern "C" void
destroy( cube::CubeServerPlugin* plugin )
{
    delete plugin;
}
