/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 1998-2023                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/



#ifndef CUBEGUIPLUGIN_TOOLS_TAU2CUBE_H
#define CUBEGUIPLUGIN_TOOLS_TAU2CUBE_H

#include <QPushButton>
#include <QLabel>
#include <QCheckBox>
#include <QListWidget>
#include "ContextFreePlugin.h"
#include "ContextFreeServices.h"

namespace cube
{
class CubeProxy;
}

class Tau2Cube : public QObject, public cubepluginapi::ContextFreePlugin
{
    Q_OBJECT
    Q_INTERFACES( cubepluginapi::ContextFreePlugin )
    Q_PLUGIN_METADATA( IID "Tau2CubePlugin" )

public:
    // ContextFreePlugin interface
    virtual QString
    name() const;

    virtual void
    opened( cubepluginapi::ContextFreeServices* service );

    virtual void
    closed();

    virtual void
    version(        int& major,
                    int& minor,
                    int& bugfix ) const;

    virtual QString
    getHelpText() const;

private:
    void
    addTauDirectory();
    void
    addExperiments( const QStringList& list );
    void
    clearList();
    void
    startAction();

    cubepluginapi::ContextFreeServices* service;
    QStringList                         args;

    QPushButton* addCube;
    QPushButton* merge;
    QCheckBox*   remote;
    QCheckBox*   reduce;
    QCheckBox*   collapse;
    QListWidget* experiments;
    QWidget*     widget;

    QString url; // url to cube_server
};

#endif // CUBE_TOOLS_H
