/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2024                                                     **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBEGUIPLUGIN_POP_ADVISOR_WIDGET_H
#define CUBEGUIPLUGIN_POP_ADVISOR_WIDGET_H
#include "Compatibility.h"
#include <vector>
#include <QtGui>
#include <QWidget>
#include <QLabel>
#include <QComboBox>
#include <QPushButton>
#include <QToolButton>
#include "PluginServices.h"
#include "POPServerRequest.h"
#include "Future.h"
#include "POPCalculation.h"

namespace popadvisor_client
{
class POPAdvisorPlugin;

class CubePOPAdvisorWidget : public QWidget
{
    Q_OBJECT

public:
    CubePOPAdvisorWidget( POPAdvisorPlugin*,
                          QWidget* w = nullptr );

    virtual
    ~CubePOPAdvisorWidget()
    {
    }

    void
    setCallPathToCalculate( QString& );

    int
    currentAnalysis()
    {
        return analyses->currentData().toInt();
    };



    void
    enableAnalysis( const popcalculation::POP_ANALYSIS,
                    const std::string& );

public slots:
    void
    recalculate();

    void
    calculationResult( popserver_request::POPServerAnswer& );

    void
    calculationStart( QString& );

    void
    copyToClipboard();

    void
    enableControls( bool );

    void
    enableControls( int  )
    {
        enableControls( false );
    }

private:
    POPAdvisorPlugin* slotprocessor;
    QLabel*           callpaths;
    QLabel*           help;
    QComboBox*        analyses;
    QPushButton*      calculate_button;
    QPushButton*      copy_button;
    QToolButton*      show_more;

    std::vector<QLabel*> pop_labels;
    std::vector<QLabel*> pop_values;

    std::vector<QLabel*> gpu_labels;
    std::vector<QLabel*> gpu_values;

    std::vector<QLabel*> io_labels;
    std::vector<QLabel*> io_values;

    std::vector<QLabel*> additional_labels;
    std::vector<QLabel*> additional_values;

    std::vector<QLabel*> control_labels;
    std::vector<QLabel*> control_values;

    QString text_to_copy;
};
};

#endif // CUBEGUIPLUGIN_POP_ADVISOR_WIDGET_H
