/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2022-2024                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#include "config.h"
#include <QtPlugin>
#include <QDebug>
#include <QPushButton>
#include <QVBoxLayout>
#include <QFileDialog>
#include "measurementplugin.h"
#include "measurementwindow.h"
#include "ContextFreeServices.h"
#include "CubeProxy.h"

using namespace measurementplugin;
using namespace cube;
using namespace cubepluginapi;

#if QT_VERSION < 0x050000
Q_EXPORT_PLUGIN2( MeasurementPlugin, ContextFreePluginExample ) // ( PluginName, ClassName )
#endif

/**
 *  @brief Provides the version information of the plugin including the mijor, minor and bugfix version.
 *  @param major The variable into which the major version number will be written.
 *  @param minor The variable into which the minor version number will be written.
 *  @param bugfix The variable into which the bugfix version number will be written.
 */
void
MeasurementPlugin::version( int& major, int& minor, int& bugfix ) const
{
    major  = 1;
    minor  = 0;
    bugfix = 0;
}

/**
 * @brief Returns the name of the plugin.
 * @return The name of the plugin as a QString Object.
 */
QString
MeasurementPlugin::name() const
{
    return "MeasurementPlugin";
}

/**
 * @brief Initializes the plugin and sets up the user interface. This function is called when the plugin is
 * opened. It creates a measurementwindow::MeasurementWindow object and adds it the layout.
 * @param service A pointer to the ContextFreeServices variable.
 */
void
MeasurementPlugin::opened( cubepluginapi::ContextFreeServices* service )
{
    this->service = service;

    QWidget*     widget = service->getWidget();
    QVBoxLayout* layout = new QVBoxLayout();
    widget->setLayout( layout );

    measurementwindow::MeasurementWindow* window = new measurementwindow::MeasurementWindow( this->service );
    layout->addWidget( window );
}

/**
 * @brief This function is called when the plugin is closed and outputs a debug meassage to indicate that the
 * plugin has been closed.
 */
void
MeasurementPlugin::closed()
{
    qDebug() << "Measurement plugin closed";
}

/**
 * @brief This function returns the help text for the plugin.
 * @return The help text of the plugin as a QString object.
 */
QString
MeasurementPlugin::getHelpText() const
{
    return "context free plugin help text";
}

/**
 * @brief This function returns a pointer to the member variable service.
 * @return A pointer to the ContextFreeServices variable.
 */
ContextFreeServices*
MeasurementPlugin::getService()
{
    return this->service;
}
