/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2022-2023                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CONSOLE_H
#define CONSOLE_H

#include <QtWidgets>
#include <string>
#include "ContextFreePlugin.h"

// forward declaration of MeasurementWindow class to avoid recursive inclusion
namespace measurementwindow
{
class MeasurementWindow;
}


namespace console
{
/**
 * @file console.h
 * @brief Provides a class, which shows the console output in a virtual console
 */
class Console : public QWidget
{
    Q_OBJECT

public:
    Console( cubepluginapi::ContextFreeServices* service,
             QWidget*                            parent = nullptr );
    std::string
    execCommand( std::string cmd_str,
                 int&        returncode,
                 bool        showOutput = true,
                 bool        moduleCommand = false,
                 bool        saveSettings = true );
    void
    addCommand( std::string cmd,
                bool        saveSettings = true );
    void
    addOutput( std::string output,
               bool        saveSettings = true );

    /**
     * @brief The QTextEdit widget that is used to display commands and output.
     */
    QTextEdit* console;

protected:
    bool
    event( QEvent* event ) override;

private:
    std::string
    execute( const char* cmd,
             int&        returncode );

    cubepluginapi::ContextFreeServices*   service;
    measurementwindow::MeasurementWindow* measurementWindow;

    QLabel*      consoleTitle;
    QVBoxLayout* consoleLayout;
    QHBoxLayout* consoleTitleLayout;
    QScrollArea* scrollArea;
    QPushButton* consoleButton;
    QPalette     bgcolor;

private slots:
    void
    onConsoleButtonClicked();
};
}
#endif // CONSOLE_H
