/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 1998-2022                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  Copyright (c) 2009-2022                                                **
**  German Research School for Simulation Sciences GmbH,                   **
**  Laboratory for Parallel Programming                                    **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBEGUIPLUGIN_HORIZONTALRULERCONTROLLER_H
#define CUBEGUIPLUGIN_HORIZONTALRULERCONTROLLER_H


#include "AbstractRulerController.h"

class HorizontalRulerController : public AbstractRulerController
{
public:
    HorizontalRulerController( QWidget* parent );
    virtual void
    doPaint( QRect     viewport,
             QPainter& painter );
    virtual int
    pixelCoordToRulerCoord( int  pixelCoord,
                            bool oppositeDirection = false );
    virtual double
    pixelCoordToRulerCoordF( int  pixelCoord,
                             bool oppositeDirection = false );
};

#endif // HORIZONTALRULERCONTROLLER_H
