/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2015-2023                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#include <config.h>
#include <string>

std::string cubepl_time_init_str =
    "            {\n"
    "                global(execution);\n"
    "                global(overhead);\n"
    "                global(without_wait_state);\n"
    "\n"
    "                global(includesMPI);\n"
    "                global(mpi);\n"
    "                global(mpi_mgmt_startup);\n"
    "                global(mpi_mgmt_comm);\n"
    "                global(mpi_mgmt_file);\n"
    "                global(mpi_mgmt_win);\n"
    "                global(mpi_sync_collective);\n"
    "                global(mpi_sync_rma_active);\n"
    "                global(mpi_sync_rma_passive);\n"
    "                global(mpi_comm_p2p);\n"
    "                global(mpi_comm_collective);\n"
    "                global(mpi_comm_rma);\n"
    "                global(mpi_file_individual);\n"
    "                global(mpi_file_collective);\n"
    "                global(mpi_file_iops);\n"
    "                global(mpi_file_irops);\n"
    "                global(mpi_file_iwops);\n"
    "                global(mpi_file_cops);\n"
    "                global(mpi_file_crops);\n"
    "                global(mpi_file_cwops);\n"
    "\n"
    "                global(includesSHMEM);\n"
    "                global(shmem);\n"
    "                global(shmem_mgmt_initfini);\n"
    "                global(shmem_mgmt_activesets);\n"
    "                global(shmem_mgmt_query);\n"
    "                global(shmem_comm_rma);\n"
    "                global(shmem_comm_atomic);\n"
    "                global(shmem_comm_coll);\n"
    "                global(shmem_sync_rma);\n"
    "                global(shmem_sync_coll);\n"
    "                global(shmem_sync_locking);\n"
    "                global(shmem_memory_mgmt);\n"
    "                global(shmem_memory_ordering);\n"
    "                global(shmem_event);\n"
    "                global(shmem_cache);\n"
    "\n"
    "                global(includesOpenMP);\n"
    "                global(omp);\n"
    "                global(omp_sync_ebarrier);\n"
    "                global(omp_sync_ibarrier);\n"
    "                global(omp_sync_critical);\n"
    "                global(omp_sync_lock_api);\n"
    "                global(omp_sync_ordered);\n"
    "                global(omp_sync_taskwait);\n"
    "                global(omp_sync_create_task);\n"
    "                global(omp_flush);\n"
    "\n"
    "                global(includesPthread);\n"
    "                global(pthread);\n"
    "                global(pthread_mgmt);\n"
    "                global(pthread_sync_mutex);\n"
    "                global(pthread_sync_condition);\n"
    "\n"
    "                global(includesOpenCL);\n"
    "                global(opencl);\n"
    "                global(opencl_setup);\n"
    "                global(opencl_comm);\n"
    "                global(opencl_sync);\n"
    "                global(opencl_kernel_launches);\n"
    "                global(opencl_kernel_executions);\n"
    "\n"
    "                global(includesCUDA);\n"
    "                global(cuda);\n"
    "                global(cuda_setup);\n"
    "                global(cuda_comm);\n"
    "                global(cuda_sync);\n"
    "                global(cuda_kernel_launches);\n"
    "                global(cuda_kernel_executions);\n"
    "\n"
    "                global(includesLIBWRAP);\n"
    "                global(libwrap);\n"
    "\n"
    "                ${includesMPI}     = 0;\n"
    "                ${includesSHMEM}   = 0;\n"
    "                ${includesOpenMP}  = 0;\n"
    "                ${includesPthread} = 0;\n"
    "                ${includesOpenCL}  = 0;\n"
    "                ${includesCUDA}    = 0;\n"
    "                ${includesLIBWRAP} = 0;\n"
    "\n"
    "                ${i} = 0;\n"
    "                while ( ${i} < ${cube::#callpaths} )\n"
    "                {\n"
    "                    ${execution}[${i}] = 1;\n"
    "                    ${without_wait_state}[${i}] = 1;\n"
    "\n"
    "                    if ( ${cube::region::paradigm}[${cube::callpath::calleeid}[${i}]] eq \"mpi\" )\n"
    "                    {\n"
    "                        ${includesMPI} = 1;\n"
    "                        ${without_wait_state}[${i}] = 0;\n"
    "\n"
    "                        if ( not ( ${cube::region::name}[${cube::callpath::calleeid}[${i}]] eq \"PARALLEL\" ) )\n"
    "                        {\n"
    "                            ${mpi}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${cube::region::name}[${cube::callpath::calleeid}[${i}]] =~ /^MPI_(Init(_thread|ialized){0,1}|Finalize(d){0,1})$/ )\n"
    "                        {\n"
    "                            ${mpi_mgmt_startup}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${cube::region::name}[${cube::callpath::calleeid}[${i}]] =~ /^MPI_(Cart_(coords|create|get|map|rank|shift|sub)|Cartdim_get|Comm_(accept|compare|connect|create(_group|_keyval){0,1}|delete_attr|disconnect|dup(_with_info){0,1}|free(_keyval){0,1}|get_(attr|info|name|parent)|group|idup|join|rank|remote_(group|size)|set_(attr|info|name)|size|spawn(_multiple){0,1}|split(_type){0,1}|test_inter)|Dims_create|Dist_graph_(create(_adjacent){0,1}|neighbors(_count){0,1})|Graph_(create|get|map|neighbors(_count){0,1})|Graphdims_get|Intercomm_(create|merge)|Topo_test|(Close|Open)_port|(Lookup|Publish|Unpublish)_name)$/ )\n"
    "                        {\n"
    "                            ${mpi_mgmt_comm}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${cube::region::name}[${cube::callpath::calleeid}[${i}]] =~ /^MPI_File_(close|delete|get_(amode|atomicity|byte_offset|group|info|position(_shared){0,1}|size|type_extent|view)|open|preallocate|seek(_shared){0,1}|set_(atomicity|info|size|view)|sync)$/ )\n"
    "                        {\n"
    "                            ${mpi_mgmt_file}[${i}] = 1;\n"
    "\n"
    "                            if ( ${cube::region::name}[${cube::callpath::calleeid}[${i}]] =~ /(delete|get|seek)/ )\n"
    "                            {\n"
    "                                ${mpi_file_iops}[${i}] = 1;\n"
    "                            }\n"
    "                            else\n"
    "                            {\n"
    "                                ${mpi_file_cops}[${i}] = 1;\n"
    "                            };\n"
    "                        };\n"
    "\n"
    "                        if ( ${cube::region::name}[${cube::callpath::calleeid}[${i}]] =~ /^MPI_Win_(allocate(_shared){0,1}|attach|create(_dynamic|_keyval){0,1}|delete_attr|detach|free(_keyval){0,1}|get_(attr|group|info|name)|set_(attr|info|name)|shared_query)$/ )\n"
    "                        {\n"
    "                            ${mpi_mgmt_win}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${cube::region::role}[${cube::callpath::calleeid}[${i}]] eq \"barrier\" )\n"
    "                        {\n"
    "                            ${mpi_sync_collective}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${cube::region::name}[${cube::callpath::calleeid}[${i}]] =~ /^MPI_Win_(complete|fence|post|start|test|wait)$/ )\n"
    "                        {\n"
    "                            ${mpi_sync_rma_active}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${cube::region::name}[${cube::callpath::calleeid}[${i}]] =~ /^MPI_Win_((flush(_local){0,1}|lock|unlock)(_all){0,1}|sync)$/ )\n"
    "                        {\n"
    "                            ${mpi_sync_rma_passive}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if (\n"
    "                            ( ${cube::region::role}[${cube::callpath::calleeid}[${i}]] eq \"point2point\" )\n"
    "                            or\n"
    "                            ( ${cube::region::name}[${cube::callpath::calleeid}[${i}]] =~ /^MPI_(Test|Wait)(all|any|some){0,1}$/ )\n"
    "                           )\n"
    "                        {\n"
    "                            ${mpi_comm_p2p}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${cube::region::role}[${cube::callpath::calleeid}[${i}]] =~ /^(one2all|all2one|all2all|other collective)$/ )\n"
    "                        {\n"
    "                            ${mpi_comm_collective}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${cube::region::role}[${cube::callpath::calleeid}[${i}]] =~ /^(rma|atomic)$/ )\n"
    "                        {\n"
    "                            ${mpi_comm_rma}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${cube::region::name}[${cube::callpath::calleeid}[${i}]] =~ /^MPI_File_i{0,1}(read|write)(_at|_shared){0,1}$/ )\n"
    "                        {\n"
    "                            ${mpi_file_individual}[${i}] = 1;\n"
    "                            ${mpi_file_iops}[${i}]       = 1;\n"
    "\n"
    "                            if ( ${cube::region::name}[${cube::callpath::calleeid}[${i}]] =~ /read/ )\n"
    "                            {\n"
    "                                ${mpi_file_irops}[${i}] = 1;\n"
    "                            }\n"
    "                            else\n"
    "                            {\n"
    "                                ${mpi_file_iwops}[${i}] = 1;\n"
    "                            };\n"
    "                        };\n"
    "\n"
    "                        if ( ${cube::region::name}[${cube::callpath::calleeid}[${i}]] =~ /^MPI_File_((iread|iwrite)_(all|at_all)|(read|write)_(all|at_all|ordered)(_begin|_end){0,1})$/ )\n"
    "                        {\n"
    "                            ${mpi_file_collective}[${i}] = 1;\n"
    "                            ${mpi_file_cops}[${i}]       = 1;\n"
    "\n"
    "                            if ( ${cube::region::name}[${cube::callpath::calleeid}[${i}]] =~ /read/ )\n"
    "                            {\n"
    "                                ${mpi_file_crops}[${i}] = 1;\n"
    "                            }\n"
    "                            else\n"
    "                            {\n"
    "                                ${mpi_file_cwops}[${i}] = 1;\n"
    "                            };\n"
    "                        };\n"
    "                    };\n"
    "\n"
    "                    if ( ${cube::region::paradigm}[${cube::callpath::calleeid}[${i}]] eq \"shmem\" )\n"
    "                    {\n"
    "                        ${includesSHMEM} = 1;\n"
    "                        ${shmem}[${i}] = 1;\n"
    "\n"
    "                        if ( ${cube::region::name}[${cube::callpath::calleeid}[${i}]] =~ /^(shmem_init(_thread){0,1}|start_pes|shmem_finalize)$/ )\n"
    "                        {\n"
    "                            ${shmem_mgmt_initfini}[${i}] = 1;\n"
    "                        };\n"
    "                        if ( ${cube::region::name}[${cube::callpath::calleeid}[${i}]] =~ /^((shmem_|_){0,1}(my_pe|num_pes)|shmem_team_(split|create_strided|free|npes|mype|translate_pe))$/ )\n"
    "                        {\n"
    "                            ${shmem_mgmt_activesets}[${i}] = 1;\n"
    "                        };\n"
    "                        if ( ${cube::region::name}[${cube::callpath::calleeid}[${i}]] =~ /^(shmem_((pe|adr)_accessible|ptr))$/ )\n"
    "                        {\n"
    "                            ${shmem_mgmt_query}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${cube::region::role}[${cube::callpath::calleeid}[${i}]] eq \"rma\" )\n"
    "                        {\n"
    "                            ${shmem_comm_rma}[${i}] = 1;\n"
    "                        };\n"
    "                        if ( ${cube::region::role}[${cube::callpath::calleeid}[${i}]] eq \"atomic\" )\n"
    "                        {\n"
    "                            ${shmem_comm_atomic}[${i}] = 1;\n"
    "                        };\n"
    "                        if ( ${cube::region::role}[${cube::callpath::calleeid}[${i}]] =~ /^(one2all|all2one|all2all|other collective)$/ )\n"
    "                        {\n"
    "                            ${shmem_comm_coll}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${cube::region::name}[${cube::callpath::calleeid}[${i}]] =~ /^(shmem(short|int|long|longlong){0,1}_wait(_until){0,1})$/ )\n"
    "                        {\n"
    "                            ${shmem_sync_rma}[${i}] = 1;\n"
    "                        };\n"
    "                        if ( ${cube::region::role}[${cube::callpath::calleeid}[${i}]] eq \"barrier\" )\n"
    "                        {\n"
    "                            ${shmem_sync_coll}[${i}] = 1;\n"
    "                        };\n"
    "                        if ( ${cube::region::name}[${cube::callpath::calleeid}[${i}]] =~ /^(shmem_(set|test|clear)_lock)$/ )\n"
    "                        {\n"
    "                            ${shmem_sync_locking}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${cube::region::role}[${cube::callpath::calleeid}[${i}]] =~ /^((de|re){0,1}allocate)$/ )\n"
    "                        {\n"
    "                            ${shmem_memory_mgmt}[${i}] = 1;\n"
    "                        };\n"
    "                        if ( ${cube::region::name}[${cube::callpath::calleeid}[${i}]] =~ /^(shmem_(fence|quiet))$/ )\n"
    "                        {\n"
    "                            ${shmem_memory_ordering}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${cube::region::name}[${cube::callpath::calleeid}[${i}]] =~ /^(shmem_(set|test|clear|wait)_event)$/ )\n"
    "                        {\n"
    "                            ${shmem_event}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${cube::region::name}[${cube::callpath::calleeid}[${i}]] =~ /^(shmem_((clear|set)_cache(_line){0,1}_inv|udcflush(_line){0,1}))$/ )\n"
    "                        {\n"
    "                            ${shmem_cache}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                    };\n"
    "\n"
    "                    if ( ${cube::region::paradigm}[${cube::callpath::calleeid}[${i}]] eq \"openmp\" )\n"
    "                    {\n"
    "                        ${includesOpenMP} = 1;\n"
    "                        ${omp}[${i}] = 0;\n"
    "\n"
    "                        if ( ${cube::region::role}[${cube::callpath::calleeid}[${i}]] eq \"barrier\" )\n"
    "                        {\n"
    "                            ${without_wait_state}[${i}] = 0;\n"
    "                            ${omp_sync_ebarrier}[${i}] = 1;\n"
    "                            ${omp}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${cube::region::role}[${cube::callpath::calleeid}[${i}]] eq \"implicit barrier\" )\n"
    "                        {\n"
    "                            ${without_wait_state}[${i}] = 0;\n"
    "                            ${omp_sync_ibarrier}[${i}] = 1;\n"
    "                            ${omp}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${cube::region::role}[${cube::callpath::calleeid}[${i}]] =~ /^(atomic|critical)$/ )\n"
    "                        {\n"
    "                            ${without_wait_state}[${i}] = 0;                            \n"
    "                            ${omp_sync_critical}[${i}] = 1;\n"
    "                            ${omp}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${cube::region::name}[${cube::callpath::calleeid}[${i}]] =~ /^omp_(destroy|init|set|test|unset)(_nest){0,1}_lock$/ )\n"
    "                        {\n"
    "                            ${without_wait_state}[${i}] = 0;\n"
    "                            ${omp_sync_lock_api}[${i}] = 1;\n"
    "                            ${omp}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${cube::region::role}[${cube::callpath::calleeid}[${i}]] eq \"ordered\" )\n"
    "                        {\n"
    "                            ${without_wait_state}[${i}] = 0;\n"
    "                            ${omp_sync_ordered}[${i}] = 1;\n"
    "                            ${omp}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${cube::region::role}[${cube::callpath::calleeid}[${i}]] eq \"taskwait\" )\n"
    "                        {\n"
    "                            ${without_wait_state}[${i}] = 0;\n"
    "                            ${omp_sync_taskwait}[${i}] = 1;\n"
    "                            ${omp}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${cube::region::role}[${cube::callpath::calleeid}[${i}]] eq \"task create\" )\n"
    "                        {\n"
    "                            ${without_wait_state}[${i}] = 0;\n"
    "                            ${omp_sync_create_task}[${i}] = 1;\n"
    "                            ${omp}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${cube::region::role}[${cube::callpath::calleeid}[${i}]] eq \"flush\" )\n"
    "                        {\n"
    "                            ${without_wait_state}[${i}] = 0;\n"
    "                            ${omp_flush}[${i}] = 1;\n"
    "                            ${omp}[${i}] = 1;\n"
    "                        };\n"
    "                    };\n"
    "\n"
    "                    if ( ${cube::region::paradigm}[${cube::callpath::calleeid}[${i}]] eq \"pthread\" )\n"
    "                    {\n"
    "                        ${includesPthread} = 1;\n"
    "                        ${pthread}[${i}] = 1;\n"
    "\n"
    "                        if ( ${cube::region::name}[${cube::callpath::calleeid}[${i}]] =~ /^pthread_(cancel|create|detach|exit|join)$/ )\n"
    "                        {\n"
    "                            ${without_wait_state}[${i}] = 0;\n"
    "                            ${pthread_mgmt}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${cube::region::name}[${cube::callpath::calleeid}[${i}]] =~ /^pthread_mutex_(destroy|init|lock|trylock|unlock)$/ )\n"
    "                        {\n"
    "                            ${without_wait_state}[${i}] = 0;\n"
    "                            ${pthread_sync_mutex}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${cube::region::name}[${cube::callpath::calleeid}[${i}]] =~ /^pthread_cond_(broadcast|destroy|init|signal|timedwait|wait)$/ )\n"
    "                        {\n"
    "                            ${without_wait_state}[${i}] = 0;\n"
    "                            ${pthread_sync_condition}[${i}] = 1;\n"
    "                        };\n"
    "                    };\n"
    "\n"
    "                    if ( ${cube::region::paradigm}[${cube::callpath::calleeid}[${i}]] eq \"opencl\" )\n"
    "                    {\n"
    "                        ${includesOpenCL} = 1;\n"
    "                        ${without_wait_state}[${i}] = 0;\n"
    "\n"
    "                        if ( not ( ${cube::region::name}[${cube::callpath::calleeid}[${i}]] eq \"BUFFER FLUSH\" ) )\n"
    "                        {\n"
    "                            ${opencl}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${cube::region::name}[${cube::callpath::calleeid}[${i}]] =~ /^cl(GetPlatformIDs|GetPlatformInfo|GetDeviceIDs|GetDeviceInfo|CreateSubDevices|RetainDevice|ReleaseDevice|CreateContext|CreateContextFromType|RetainContext|ReleaseContext|GetContextInfo|CreateProgramWithSource|CreateProgramWithBinary|RetainProgram|ReleaseProgram|GetProgramInfo|GetProgramBuildInfo|CreateKernelsInProgram|CreateProgramWithBuildInKernels|BuildProgram|CompileProgram|LinkProgram|CreateKernel|Retainkernel|ReleaseKernel|GetEventInfo|RetainEvent|ReleaseEvent|GetEventProfilingInfo|CreateUserInfo|SetUserEventStatus|SetEventCallback|CreateCommandQueue|CreateCommandQueueWithProperties|RetainCommandQueue|ReleaseCommandQueue|GetCommandQueueInfo|SetCommandQueueProperty|GetKernelInfo|GetKernelWorkGroupInfo|GetKernelArgInfo|Flush|UnloadCompiler|UnloadPlatformCompiler|GetExtensionFunctionAddress|GetExtensionFunctionAddressForPlatform|SetMemObjectDestructorCallback|GetMemObjectInfo|GetPipeInfo|GetSupportedImageFormats|GetImageInfo|GetSamplerInfo)$/ )\n"
    "                        {\n"
    "                            ${opencl_setup}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${cube::region::name}[${cube::callpath::calleeid}[${i}]] =~ /^cl(CreateBuffer|CreateSubBuffer|EnqueueReadBuffer|EnqueueReadBufferRect|EnqueueWriteBuffer|EnqueueWriteBufferRect|EnqueueFillBuffer|EnqueueCopyBuffer|EnqueueCopyBufferRect|EnqueueMapBuffer|EnqueueUnmapMemObjectCopy|EnqueueMigrateMemObjects|CreatePipe|SVMAlloc|SVMFree|EnqueueSVMFree|EnqueueSVMMemcpy|EnqueueSVMMemFill|EnqueueSVMMap|EnqueueSVMUnmap|CreateImage|CreateImage2D|CreateImage3D|EnqueueReadImage|EnqueueWriteImage|EnqueueCopyImage|EnqueueCopyImageToBuffer|EnqueueCopyBufferToImage|EnqueueMapImage|EnqueueFillImage|CreateSamplerWithProperties|CreateSampler|ReleaseSampler|RetainSampler|RetainMemObject|ReleaseMemObject)$/ )\n"
    "                        {\n"
    "                            ${opencl_comm}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${cube::region::name}[${cube::callpath::calleeid}[${i}]] =~ /^(clFinish|clWaitForEvents|clEnqueueWaitForEvents|clEnqueueBarrier|clEnqueueMarker|clEnqueueMarkerWithWaitList|clEnqueueBarrierWithWaitList)$/ )\n"
    "                        {\n"
    "                            ${opencl_sync}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${cube::region::name}[${cube::callpath::calleeid}[${i}]] eq \"WAIT FOR COMMAND QUEUE\" )\n"
    "                        {\n"
    "                            ${opencl_sync}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${cube::region::name}[${cube::callpath::calleeid}[${i}]] =~ /^cl(SetKernelArg|SetKernelArgSVMPointer|SetKernelExecInfo|EnqueueNDRangeKernel|EnqueueTask)$/ )\n"
    "                        {\n"
    "                            ${opencl_kernel_launches}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${cube::region::mod}[${cube::callpath::calleeid}[${i}]] seq \"OPENCL_KERNEL\" )\n"
    "                        {\n"
    "                            ${opencl_kernel_executions}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${cube::region::name}[${cube::callpath::calleeid}[${i}]] eq \"BUFFER FLUSH\" )\n"
    "                        {\n"
    "                            ${opencl}[${i}]    = 0;\n"
    "                            ${execution}[${i}] = 0;\n"
    "                            ${overhead}[${i}]  = 1;\n"
    "                        };\n"
    "                    };\n"
    "\n"
    "                    if ( ${cube::region::paradigm}[${cube::callpath::calleeid}[${i}]] eq \"cuda\" )\n"
    "                    {\n"
    "                        ${includesCUDA} = 1;\n"
    "                        ${without_wait_state}[${i}] = 0;\n"
    "\n"
    "                        if ( not ( ${cube::region::name}[${cube::callpath::calleeid}[${i}]] eq \"BUFFER FLUSH\" ) )\n"
    "                        {\n"
    "                            ${cuda}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${cube::region::name}[${cube::callpath::calleeid}[${i}]] =~ /^cuda(ChooseDevice|DeviceGetAttribute|DeviceGetByPCIBusId|DeviceGetCacheConfig|DeviceGetLimit|DeviceGetPCIBusId|DeviceGetSharedMemConfig|DeviceGetStreamPriorityRange|DeviceReset|DeviceSetCacheConfig|DeviceSetLimit|DeviceSetSharedMemConfig|GetDevice|GetDeviceCount|GetDeviceFlags|GetDeviceProperties|SetDevice|SetDeviceFlags|SetValidDevices|ThreadExit|ThreadGetCacheConfig|ThreadGetLimit|ThreadSetCacheConfig|ThreadSetLimit|StreamCreate|StreamCreateWithFlags|StreamCreateWithPriority|StreamDestroy|EventCreate|EventCreateWithFlags|EventDestroy|FuncSetCacheConfig)$/ )\n"
    "                        {\n"
    "                            ${cuda_setup}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${cube::region::name}[${cube::callpath::calleeid}[${i}]] =~ /^cuda(Free|FreeArray|FreeHost|FreeMipmappedArray|HostAlloc|Malloc|Malloc3D|Malloc3DArray|MallocArray|MallocHost|MallocManaged|MallocMipmappedArray|MallocPitch|Memcpy|Memcpy2D|Memcpy2DArrayToArray|Memcpy2DAsync|Memcpy2DFromArray|Memcpy2DFromArrayAsync|Memcpy2DToArray|Memcpy2DToArrayAsync|Memcpy3D|Memcpy3DAsync|MemcpyPeer|MemcpyPeerAsync|MemcpyArrayToArray|MemcpyAsync|MemcpyFromArray|MemcpyFromArrayAsync|MemcpyFromSymbol|MemcpyFromSymbolAsync|MemcpyFromPeer|MemcpyFromPeerAsync|MemcpyToArray|MemcpyToArrayAsync|MemcpyToSymbol|MemcpyToSymbolAsync)$/ )\n"
    "                        {\n"
    "                            ${cuda_comm}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${cube::region::name}[${cube::callpath::calleeid}[${i}]] =~ /^cuda(StreamWaitEvent|StreamSynchronize|EventSynchronize|DeviceSynchronize|ThreadSynchronize)$/ )\n"
    "                        {\n"
    "                            ${cuda_sync}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${cube::region::name}[${cube::callpath::calleeid}[${i}]] =~ /^cuda(LaunchKernel|Launch|GetParameterBufferV2|Memset|Memset2D|Memset2DAsync|Memset3D|Memset3DAsync|MemsetAsync)$/ )\n"
    "                        {\n"
    "                            ${cuda_kernel_launches}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${cube::region::name}[${cube::callpath::calleeid}[${i}]] =~ /^cu(Init|DeviceGet|DeviceGetAttribute|DeviceGetCount|DeviceGetName|DeviceTotalMem|DeviceComputeCapability|DeviceGetProperties|DevicePrimaryCtxGetState|DevicePrimaryCtxRelease|DevicePrimaryCtxReset|DevicePrimaryCtxRetain|DevicePrimaryCtxSetFlags|CtxCrate|CtxDestroy|CtxGetApiVersion|CtxGetCacheConfig|CtxGetCurrent|CtxGetDevice|CtxGetFlags|CtxGetLimit|CtxGetSharedMemConfig|CtxGetStreamPriorityRange|CtxPopCurrent|CtxPushCurrent|CtxSetCacheConfig|CtxSetCurrent|CtxSetLimit|CtxSetSharedMemConfig|CtxAttach|CtxDetach|LinkCreate|LinkDestroy|EventCreate|EventDestroy|StreamCreate|StreamCreateWithPriority|StreamDestroy|MemFree|MemFreeHost|MemHostAlloc)$/ )\n"
    "                        {\n"
    "                            ${cuda_setup}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${cube::region::name}[${cube::callpath::calleeid}[${i}]] =~ /^cu(Array3DCreate|ArrayCreate|ArrayDestroy|MemAlloc|MemAllocHost|MemAllocManaged|MemAllocPitch|Memcpy|Memcpy2D|Memcpy2DAsync|Memcpy2DUnaligned|Memcpy3D|Memcpy3DAsync|Memcpy3DPeer|Memcpy3DPeerAsync|MemcpyAsync|MemcpyAtoA|MemcpyAtoD|MemcpyAtoH|MemcpyAtoHAsync|MemcpyDtoA|MemcpyDtoD|MemcpyDtoDAsync|MemcpyDtoH|MemcpyDtoHAsync|MemcpyHtoA|MemcpyHtoAAsync|MemcpyHtoD|MemcpyHtoDAsync|MemcpyPeer|MemcpyPeerAsync|MemsetD16|MemsetD16Async|MemsetD2D16|MemsetD2D16Async|MemsetD2D32|MemsetD2D32Async|MemsetD2D8|MemsetD2D8Async|MemsetD32|MemsetD32Async|MemsetD8|MemsetD8Async|MipmappedArrayCreate|MipmappedArrayDestroy)$/ )\n"
    "                        {\n"
    "                            ${cuda_comm}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${cube::region::name}[${cube::callpath::calleeid}[${i}]] =~ /^cu(CtxSynchronize|StreamWaitEvent|StreamSynchronize|EventSynchronize)$/ )\n"
    "                        {\n"
    "                            ${cuda_sync}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${cube::region::name}[${cube::callpath::calleeid}[${i}]] =~ /^cu(LaunchKernel|Launch|LaunchGrid|LaunchGridAsync)$/ )\n"
    "                        {\n"
    "                            ${cuda_kernel_launches}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${cube::region::name}[${cube::callpath::calleeid}[${i}]] eq \"DEVICE SYNCHRONIZE\" )\n"
    "                        {\n"
    "                            ${cuda_sync}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${cube::region::mod}[${cube::callpath::calleeid}[${i}]] seq \"CUDA_KERNEL\" )\n"
    "                        {\n"
    "                            ${cuda_kernel_executions}[${i}] = 1;\n"
    "                        };\n"
    "\n"
    "                        if ( ${cube::region::name}[${cube::callpath::calleeid}[${i}]] eq \"BUFFER FLUSH\" )\n"
    "                        {\n"
    "                            ${cuda}[${i}]      = 0;\n"
    "                            ${execution}[${i}] = 0;\n"
    "                            ${overhead}[${i}]  = 1;\n"
    "                        };\n"
    "                    };\n"
    "\n"
    "                    if ( ${cube::region::paradigm}[${cube::callpath::calleeid}[${i}]] eq \"measurement\" )\n"
    "                    {\n"
    "                        if ( ${cube::region::name}[${cube::callpath::calleeid}[${i}]] eq \"TRACE BUFFER FLUSH\" )\n"
    "                        {\n"
    "                            ${without_wait_state}[${i}] = 0;\n"
    "                            ${execution}[${i}] = 0;\n"
    "                            ${overhead}[${i}]  = 1;\n"
    "                        };\n"
    "                    };\n"
    "\n"
    "                    if ( ${cube::region::paradigm}[${cube::callpath::calleeid}[${i}]] =~ /^libwrap:(.+)$/ )\n"
    "                    {\n"
    "                        ${includesLIBWRAP} = 1;\n"
    "                        ${libwrap}[${i}] = 1;\n"
    "                    };\n"
    "\n"
    "                    ${i} = ${i} + 1;\n"
    "                };\n"
    "\n"
    "\n"
    "                return 0;\n"
    "            }";



std::string cubepl_time_set_str =
    "            {\n"
    "                if ( ${includesMPI} == 0 )\n"
    "                {\n"
    "                    cube::metric::set::mpi(\"value\", \"VOID\");\n"
    "                    cube::metric::set::mpi_management(\"value\", \"VOID\");\n"
    "                    cube::metric::set::mpi_init_exit(\"value\", \"VOID\");\n"
    "                    cube::metric::set::mpi_mgmt_comm(\"value\", \"VOID\");\n"
    "                    cube::metric::set::mpi_mgmt_file(\"value\", \"VOID\");\n"
    "                    cube::metric::set::mpi_mgmt_win(\"value\", \"VOID\");\n"
    "                    cube::metric::set::mpi_synchronization(\"value\", \"VOID\");\n"
    "                    cube::metric::set::mpi_sync_collective(\"value\", \"VOID\");\n"
    "                    cube::metric::set::mpi_rma_synchronization(\"value\", \"VOID\");\n"
    "                    cube::metric::set::mpi_rma_sync_active(\"value\", \"VOID\");\n"
    "                    cube::metric::set::mpi_rma_sync_passive(\"value\", \"VOID\");\n"
    "                    cube::metric::set::mpi_communication(\"value\", \"VOID\");\n"
    "                    cube::metric::set::mpi_point2point(\"value\", \"VOID\");\n"
    "                    cube::metric::set::mpi_collective(\"value\", \"VOID\");\n"
    "                    cube::metric::set::mpi_rma_communication(\"value\", \"VOID\");\n"
    "                    cube::metric::set::mpi_io(\"value\", \"VOID\");\n"
    "                    cube::metric::set::mpi_io_individual(\"value\", \"VOID\");\n"
    "                    cube::metric::set::mpi_io_collective(\"value\", \"VOID\");\n"
    "                    cube::metric::set::mpi_file_ops(\"value\", \"VOID\");\n"
    "                    cube::metric::set::mpi_file_iops(\"value\", \"VOID\");\n"
    "                    cube::metric::set::mpi_file_irops(\"value\", \"VOID\");\n"
    "                    cube::metric::set::mpi_file_iwops(\"value\", \"VOID\");\n"
    "                    cube::metric::set::mpi_file_cops(\"value\", \"VOID\");\n"
    "                    cube::metric::set::mpi_file_crops(\"value\", \"VOID\");\n"
    "                    cube::metric::set::mpi_file_cwops(\"value\", \"VOID\");\n"
    "                    cube::metric::set::wait_time_mpi(\"value\", \"VOID\");\n"
    "                };\n"
    "\n"
    "                if ( ${includesSHMEM} == 0 )\n"
    "                {\n"
    "                    cube::metric::set::shmem_time(\"value\", \"VOID\");\n"
    "                    cube::metric::set::shmem_mgmt_time(\"value\", \"VOID\");\n"
    "                    cube::metric::set::shmem_mgmt_initfini_time(\"value\", \"VOID\");\n"
    "                    cube::metric::set::shmem_mgmt_activesets_time(\"value\", \"VOID\");\n"
    "                    cube::metric::set::shmem_mgmt_query_time(\"value\", \"VOID\");\n"
    "                    cube::metric::set::shmem_comm_time(\"value\", \"VOID\");\n"
    "                    cube::metric::set::shmem_comm_rma_time(\"value\", \"VOID\");\n"
    "                    cube::metric::set::shmem_comm_atomic_time(\"value\", \"VOID\");\n"
    "                    cube::metric::set::shmem_comm_coll_time(\"value\", \"VOID\");\n"
    "                    cube::metric::set::shmem_sync_time(\"value\", \"VOID\");\n"
    "                    cube::metric::set::shmem_sync_rma_time(\"value\", \"VOID\");\n"
    "                    cube::metric::set::shmem_sync_coll_time(\"value\", \"VOID\");\n"
    "                    cube::metric::set::shmem_sync_locking_time(\"value\", \"VOID\");\n"
    "                    cube::metric::set::shmem_memory_time(\"value\", \"VOID\");\n"
    "                    cube::metric::set::shmem_memory_mgmt_time(\"value\", \"VOID\");\n"
    "                    cube::metric::set::shmem_memory_ordering_time(\"value\", \"VOID\");\n"
    "                    cube::metric::set::shmem_event_time(\"value\", \"VOID\");\n"
    "                    cube::metric::set::shmem_cache_time(\"value\", \"VOID\");\n"
    "                };\n"
    "\n"
    "                if ( ${includesOpenMP} == 0 )\n"
    "                {\n"
    "                    cube::metric::set::omp_time(\"value\", \"VOID\");\n"
    "                    cube::metric::set::omp_synchronization(\"value\", \"VOID\");\n"
    "                    cube::metric::set::omp_barrier(\"value\", \"VOID\");\n"
    "                    cube::metric::set::omp_ebarrier(\"value\", \"VOID\");\n"
    "                    cube::metric::set::omp_ibarrier(\"value\", \"VOID\");\n"
    "                    cube::metric::set::omp_critical(\"value\", \"VOID\");\n"
    "                    cube::metric::set::omp_lock_api(\"value\", \"VOID\");\n"
    "                    cube::metric::set::omp_ordered(\"value\", \"VOID\");\n"
    "                    cube::metric::set::omp_taskwait(\"value\", \"VOID\");\n"
    "                    cube::metric::set::omp_flush(\"value\", \"VOID\");\n"
    "                    cube::metric::set::omp_idle_threads(\"value\", \"VOID\");\n"
    "                    cube::metric::set::omp_limited_parallelism(\"value\", \"VOID\");\n"

    "                    cube::metric::set::omp_comp_time(\"value\", \"VOID\");\n"
    "                    cube::metric::set::omp_non_wait_time(\"value\", \"VOID\");\n"
    "                    cube::metric::set::par_execution_time(\"value\", \"VOID\");\n"
    "                    cube::metric::set::omp_execution_time(\"value\", \"VOID\");\n"
    "                    cube::metric::set::max_omp_serial_comp_time(\"value\", \"VOID\");\n"
    "                    cube::metric::set::max_omp_time(\"value\", \"VOID\");\n"
    "                    cube::metric::set::max_omp_comp_time(\"value\", \"VOID\");\n"
    "                    cube::metric::set::avg_omp_comp_time(\"value\", \"VOID\");\n"
    "                    cube::metric::set::avg_omp_time(\"value\", \"VOID\");\n"
    "                };\n"
    "\n"
    "                if ( ${includesPthread} == 0 )\n"
    "                {\n"
    "                    cube::metric::set::pthread_time(\"value\", \"VOID\");\n"
    "                    cube::metric::set::pthread_management(\"value\", \"VOID\");\n"
    "                    cube::metric::set::pthread_synchronization(\"value\", \"VOID\");\n"
    "                    cube::metric::set::pthread_lock_api(\"value\", \"VOID\");\n"
    "                    cube::metric::set::pthread_conditional(\"value\", \"VOID\");\n"
    "                };\n"
    "\n"
    "                if ( ${includesOpenCL} == 0 )\n"
    "                {\n"
    "                    cube::metric::set::opencl_time(\"value\", \"VOID\");\n"
    "                    cube::metric::set::opencl_kernel_executions(\"value\", \"VOID\");\n"
    "                };\n"
    "\n"
    "                if ( ${includesCUDA} == 0 )\n"
    "                {\n"
    "                    cube::metric::set::cuda_time(\"value\", \"VOID\");\n"
    "                    cube::metric::set::cuda_kernel_executions(\"value\", \"VOID\");\n"
    "                };\n"
    "\n"
    "                if ( ${includesLIBWRAP} == 0 )\n"
    "                {\n"
    "                    cube::metric::set::libwrap_time(\"value\", \"VOID\");\n"
    "                };\n"
    "\n"
    "                return 0;\n"
    "            }";


std::string cubepl_knl_init_str =
    "           {\n"
    "                //--- Global callpath type masks ----------------------------\n"
    "                // Each type mask field contains one entry for each callpath,\n"
    "                // by default set to 0.  It is set to 1 if the callpath is of\n"
    "                // the corresponding category.\n"
    "                //\n"
    "\n"
    "                // Generic masks\n"
    "                global(loop);\n"
    "\n"
    "                //--- Callpath categorization -------------------------------\n"
    "                // Each callpath is categorized by type and its global type\n"
    "                // mask entry is set accordingly.\n"
    "\n"
    "                ${i} = 0;                \n"
    "                while ( ${i} < ${cube::#callpaths} )\n"
    "                {\n"
    "                   ${regionid} = ${cube::callpath::calleeid}[${i}];\n"
    "                    ${name}     = ${cube::region::name}[${regionid}];\n"
    "                    ${paradigm} = ${cube::region::paradigm}[${regionid}];\n"
    "                    ${role}     = ${cube::region::role}[${regionid}];\n"
    "                    ${isloop} = 0;\n"
    "                    if ( ${role} eq \"loop\")\n"
    "                    {\n"
    "                        ${isloop} = 1;\n"
    "                    }\n"
    "                    else \n"
    "                    {\n"
    "                        ${parent}   = ${cube::callpath::parent::id}[${i}];\n"
    "                        ${parentregion}   = ${cube::callpath::calleeid}[${parent}];\n"
    "                        while ( ${parent} != -1 )\n"
    "                        {\n"
    "                            if (${cube::region::role}[${parentregion}] eq \"loop\")\n"
    "                            {\n"
    "                                ${isloop} = 1;\n"
    "                                ${parent} = -1;\n"
    "                            }\n"
    "                            else\n"
    "                            {\n"
    "                                ${parent}   = ${cube::callpath::parent::id}[${parent}];\n"
    "                                ${parentregion}   = ${cube::callpath::calleeid}[${parent}];\n"
    "                            };\n"
    "                        };\n"
    "                    };\n"
    "                    if ( ${isloop} == 1)\n"
    "                    {\n"
    "                     ${loop}[${i}] = 1;\n"
    "                    };\n"
    "                ${i} = ${i} + 1; \n"
    "                };\n"
    "                return 0;\n"
    "            }";
