/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2015-2023                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#include <config.h>
#include <QList>
#include "CubeAdvisorProgress.h"
#include "JSCHybridAuditAnalysis.h"
#include "TreeItem.h"
#include "CubeAdvice.h"
#include "PerformanceTest.h"


using namespace cube;
using namespace cubegui;
using namespace cubepluginapi;
using namespace advisor;



JSCAuditPerformanceAnalysis::JSCAuditPerformanceAnalysis( cube::CubeProxy* _cube ) : PerformanceAnalysis( _cube )
{
    stalled_resources = new JSCStalledResourcesTest( cube );
    ipc               = new JSCIPCTest( cube );
    no_wait_ins       = new JSCNoWaitINSTest( cube );
    comp              = new JSCComputationTime( cube );

    pop_ser_eff      = new JSCSerialisationTest( cube );
    pop_transfer_eff = new JSCTransferTest( cube );
    comm_eff         = new JSCCommunicationEfficiencyTest( cube, pop_ser_eff, pop_transfer_eff );
    lb_eff           = new JSCImbalanceTest( cube );

    pop_omp_ser_eff      = new JSCOmpSerialisationTest( cube );
    pop_omp_transfer_eff = new JSCOmpTransferTest( cube );
    lb_omp_eff           = new JSCOmpImbalanceTest( cube );

    pop_amdahl_eff = new JSCAmdahlTest( cube );

    max_ipc            = ipc->getMaximum();
    COMM_EFF_ISSUE     = tr( "This call path has very low communication efficiency (%1) " );
    LB_EFF_ISSUE       = tr( "This call not sufficient load balance efficiency (%1)" );
    SER_EFF_ISSUE      = tr( "This call not sufficient serialisation efficiency (%1)" );
    TRANSFER_EFF_ISSUE = tr( "This call not sufficient transfer efficiency (%1)" );
    STL_ISSUE          = tr( "This call waits for stalled resources (%1)" );
    IPC_ISSUE          = tr( "This call has a little ratio of instructions per cycle (%1 of %2)" );
    OMP_LB_ISSUE       = tr( "This call has not sufficient OMP load balance efficiency in MPI rank %1 (%2 )" );
    OMP_SER_ISSUE      = tr( "This call has not sufficient OMP serialization efficiency in MPI rank %1 (%2 )" );
    OMP_TRANSFER_ISSUE = tr( "This call has not sufficient OMP transfer efficiency in MPI rank %1 (%2 )" );
}


JSCAuditPerformanceAnalysis::~JSCAuditPerformanceAnalysis()
{
    delete stalled_resources;
    delete ipc;
    delete no_wait_ins;
    delete comp;

    delete comm_eff;
    delete lb_eff;
    delete pop_ser_eff;
    delete pop_transfer_eff;

    delete lb_omp_eff;
    delete pop_omp_ser_eff;
    delete pop_omp_transfer_eff;

    delete pop_amdahl_eff;
};


QList<PerformanceTest*>
JSCAuditPerformanceAnalysis::getPerformanceTests()
{
    QList<PerformanceTest*> to_return;
    to_return
        << lb_eff
        << comm_eff
        << pop_ser_eff
        << pop_transfer_eff
        << pop_amdahl_eff
        << lb_omp_eff
        << pop_omp_ser_eff
        << stalled_resources
        << ipc
        << no_wait_ins
        << comp;
    return to_return;
}


// ------ overview tests ---------

bool
JSCAuditPerformanceAnalysis::isActive() const
{
    return true;
}

QString
JSCAuditPerformanceAnalysis::getAnchorHowToMeasure()
{
    return "MeasurementForJSCAnalysis";
}
