/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2015-2023                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBEGUIPLUGIN_PERFORMANCE_ANALYSIS_H
#define CUBEGUIPLUGIN_PERFORMANCE_ANALYSIS_H

#include <string>
#include <QObject>
#include <QToolBar>
#include <QList>
#include <QStringList>

#include "CubeProxy.h"
#include "TreeItem.h"

namespace advisor
{
class AdvisorAdvice;
class PerformanceTest;


class PerformanceAnalysis : public QObject
{
    Q_OBJECT
protected:

    cube::CubeProxy * cube;
    cube::Cnode* root_cnode;
    std::string  test_name;
    QStringList  header;


    void
    findRoot();

public:
    PerformanceAnalysis( cube::CubeProxy* _cube ) : QObject()
    {
        cube = _cube;
        if ( cube != nullptr )
        {
            findRoot();
        }
    }

    virtual
    ~PerformanceAnalysis()
    {
    };

    inline
    const
    std::string
    name() const
    {
        return test_name;
    }

    virtual
    QString
    getAnchorHowToMeasure() = 0;

    virtual
    QList<PerformanceTest*>
    getPerformanceTests() = 0;

    QStringList&
    getAdviceHeader()
    {
        return header;
    }




// ------ overview tests ---------

    virtual
    bool
    isActive() const = 0;
};
};

#endif // ADVISER_RATING_WIDGET_H
