/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2015-2023                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#include <config.h>
#include "PerformanceAnalysis.h"
#include "CubeRegion.h"

using namespace cube;
using namespace cubepluginapi;
using namespace advisor;

void
PerformanceAnalysis::findRoot()
{
    const std::vector<cube::Cnode*>& cnodes = cube->getRootCnodes();
    if ( cnodes.size() == 1 )
    {
        root_cnode = cnodes[ 0 ];
        return;
    }
    for ( std::vector<cube::Cnode*>::const_iterator iter = cnodes.begin(); iter != cnodes.end(); ++iter )
    {
        if ( ( ( *iter )->get_callee()->get_name().compare( "main" ) == 0 ) ||
             ( ( *iter )->get_callee()->get_name().compare( "MAIN" ) == 0 ) )
        {
            root_cnode = *iter;
            return;
        }
    }
    root_cnode = nullptr;
}
