/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 1998-2025                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBEGUI_INFOWIDGET_H
#define CUBEGUI_INFOWIDGET_H

#include <QLayout>
#include <QSplitter>
#include <QTextBrowser>
#include <QPushButton>
#include <QTabWidget>
#include "TabInterface.h"

namespace cube
{
class CubeProxy;
}

namespace cubegui
{
class HtmlWidget;
class TreeItem;

/**
 * @brief The InfoWidget class
 * The InfoWidget class displays a textual message in a tabbed widget.
 */
class InfoWidget : public QWidget, public TabInterface
{
    Q_OBJECT
public:
    enum ContentType { Info, TreeInfo, PluginInfo };

    static InfoWidget*
    getInstance();

    ~InfoWidget();

    void
    showTreeInfo( TreeItem* metricItem,
                  TreeItem* callItem,
                  TreeItem* systemItem );

    void
    showPluginInfo( const QString& txt,
                    QPushButton*   button );

    /* The panel which contains the system item information is minimized per default. This function distributes
     * the horizontal space equally among all 3 trees info panels */
    void
    showSystemInfo();

    void
    activateTab( DisplayType type );

    // TabInterface interface
    QWidget*
    widget();
    QString
    label() const;
    QIcon
    icon() const;
    void
    setActive( bool );

    void
    setGlobalInfo();

    /** Closes the info widget, if it is currently shown as system tab and deletes it.
        This allows to create a new instance with a different HtmlWidget (e.g. QWebEngineView) */
    static void
    deleteInstance();

    static QString
    formatAsTable( const QList<QPair<QString, QString> >& list );

    void
    deleteContent( QWidget* widget );

    /** adds the info tab to the system tab as subtab in "Other" */
    void
    activate();

    /** sets the info tab as current tab or raises the window, if the tab is detached */
    void
    toFront();

signals:
    void
    tabActivated();

private slots:
    void
    changeTreeInfoOrientation();

private:
    InfoWidget();

    const QString embeddedStart;
    QString       globalInfoText;
    QString       debugInfoText;

    // tree info components
    QSplitter*    horizontal;
    QSplitter*    vertical;
    QTextBrowser* metricInfo;
    QTextBrowser* callInfo;
    QTextBrowser* sysInfo;
    QTextBrowser* globalInfo;
    QTextBrowser* debugInfo;
    QTabWidget*   doc;

    QWidget*    treeInfo;
    ContentType content;

    static InfoWidget* single;
    void
    setDebugInfo();
    QString
    getInfoString( TreeItem* item ) const;
    QString
    getDocumentation( TreeItem* item );

    std::map<QString, QString> documentCache;
};
}
#endif // INFOWIDGET_H
